/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MonarchActionMessage
extends DOMMessage {
    private Monarch.MonarchAction action;
    private StringTemplate template;
    private String tax;
    private String resultString;

    public MonarchActionMessage(Monarch.MonarchAction action, StringTemplate template) {
        this.action = action;
        this.template = template;
        this.tax = null;
        this.resultString = null;
    }

    public MonarchActionMessage(Game game, Element element) {
        this.action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        this.tax = element.getAttribute("tax");
        this.resultString = element.getAttribute("result");
        NodeList children = element.getChildNodes();
        if (children.getLength() == 1) {
            this.template = StringTemplate.label(" ");
            this.template.readFromXMLElement((Element)children.item(0));
        } else {
            this.template = null;
        }
    }

    public Monarch.MonarchAction getAction() {
        return this.action;
    }

    public StringTemplate getTemplate() {
        return this.template;
    }

    public int getTax() {
        try {
            return Integer.parseInt(this.tax);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setTax(int tax) {
        this.tax = Integer.toString(tax);
    }

    public boolean getResult() {
        return Boolean.valueOf(this.resultString);
    }

    public void setResult(boolean accept) {
        this.resultString = Boolean.toString(accept);
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        return null;
    }

    public Element toXMLElement() {
        Element result = MonarchActionMessage.createMessage(MonarchActionMessage.getXMLElementTagName(), "action", this.action.toString());
        if (this.tax != null) {
            result.setAttribute("tax", this.tax);
        }
        if (this.resultString != null) {
            result.setAttribute("result", this.resultString);
        }
        result.appendChild(this.template.toXMLElement(null, result.getOwnerDocument()));
        return result;
    }

    public static String getXMLElementTagName() {
        return "monarchAction";
    }
}

