/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class JoinColonyMessage
extends DOMMessage {
    String colonyId;
    String builderId;

    public JoinColonyMessage(Colony colony, Unit builder) {
        this.colonyId = colony.getId();
        this.builderId = builder.getId();
    }

    public JoinColonyMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
        this.builderId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Colony colony;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.builderId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            colony = player.getFreeColGameObject(this.colonyId, Colony.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().joinColony(serverPlayer, unit, colony);
    }

    public Element toXMLElement() {
        return JoinColonyMessage.createMessage(JoinColonyMessage.getXMLElementTagName(), "colony", this.colonyId, "unit", this.builderId);
    }

    public static String getXMLElementTagName() {
        return "joinColony";
    }
}

