/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EquipUnitMessage
extends DOMMessage {
    private String unitId;
    private String typeId;
    private String amountString;

    public EquipUnitMessage(Unit unit, EquipmentType type, int amount) {
        this.unitId = unit.getId();
        this.typeId = type.getId();
        this.amountString = Integer.toString(amount);
    }

    public EquipUnitMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.typeId = element.getAttribute("type");
        this.amountString = element.getAttribute("amount");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        int amount;
        EquipmentType type;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        if (!unit.isInEurope()) {
            if (unit.getTile() == null) {
                return DOMMessage.clientError("Unit is not on the map: " + this.unitId);
            }
            if (unit.getSettlement() == null) {
                return DOMMessage.clientError("Unit is not in a settlement: " + this.unitId);
            }
        }
        if ((type = game.getSpecification().getEquipmentType(this.typeId)) == null) {
            return DOMMessage.clientError("Bad equipment type: " + this.typeId);
        }
        try {
            amount = Integer.parseInt(this.amountString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad amount: " + this.amountString);
        }
        if (amount == 0) {
            return DOMMessage.clientError("Amount must be non-zero: " + this.amountString);
        }
        if (amount > 0) {
            if (!unit.canBeEquippedWith(type)) {
                return DOMMessage.clientError("Unable to equip unit " + this.unitId + " with " + this.typeId);
            }
        } else if (-amount > unit.getEquipmentCount(type)) {
            return DOMMessage.clientError("Too much to remove (" + -amount + ") of " + this.typeId + " from unit " + this.unitId);
        }
        return server.getInGameController().equipUnit(serverPlayer, unit, type, amount);
    }

    public Element toXMLElement() {
        return EquipUnitMessage.createMessage(EquipUnitMessage.getXMLElementTagName(), "unit", this.unitId, "type", this.typeId, "amount", this.amountString);
    }

    public static String getXMLElementTagName() {
        return "equipUnit";
    }
}

