/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class EmbarkMessage
extends DOMMessage {
    private String unitId;
    private String carrierId;
    private String directionString;

    public EmbarkMessage(Unit unit, Unit carrier, Map.Direction direction) {
        this.unitId = unit.getId();
        this.carrierId = carrier.getId();
        this.directionString = direction == null ? null : String.valueOf((Object)direction);
    }

    public EmbarkMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.carrierId = element.getAttribute("carrier");
        this.directionString = !element.hasAttribute("direction") ? null : element.getAttribute("direction");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit carrier;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            carrier = player.getFreeColGameObject(this.carrierId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        Location sourceLocation = unit.getLocation();
        if (this.directionString == null) {
            if (!carrier.isAtLocation(sourceLocation)) {
                return DOMMessage.clientError("Unit " + this.unitId + " at " + (FreeColGameObject)((Object)sourceLocation) + " and carrier " + this.carrierId + " at " + (FreeColGameObject)((Object)carrier.getLocation()) + " are not co-located.");
            }
        } else {
            if (unit.getMovesLeft() <= 0) {
                return DOMMessage.clientError("Unit has no moves left: " + this.unitId);
            }
            Tile destinationTile = null;
            try {
                destinationTile = unit.getNeighbourTile(this.directionString);
            }
            catch (Exception e) {
                return DOMMessage.clientError(e.getMessage());
            }
            if (carrier.getTile() != destinationTile) {
                return DOMMessage.clientError("Carrier: " + this.carrierId + " is not at destination tile: " + destinationTile.toString());
            }
        }
        return server.getInGameController().embarkUnit(serverPlayer, unit, carrier);
    }

    public Element toXMLElement() {
        Element result = EmbarkMessage.createMessage(EmbarkMessage.getXMLElementTagName(), "unit", this.unitId, "carrier", this.carrierId);
        if (this.directionString != null) {
            result.setAttribute("direction", this.directionString);
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "embark";
    }
}

