/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NetworkReplyObject;
import net.sf.freecol.common.networking.ReceivingThread;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Connection {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    private static final int TIMEOUT = 5000;
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    private InputStream in = null;
    private Socket socket = null;
    private OutputStream out = null;
    private Transformer xmlTransformer = null;
    private ReceivingThread thread = null;
    private MessageHandler messageHandler = null;
    private String name;
    protected static boolean dump = FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS);

    protected Connection(String name) {
        this.name = name;
    }

    public Connection(String host, int port, MessageHandler messageHandler, String name) throws IOException {
        this(Connection.createSocket(host, port), messageHandler, name);
    }

    public Connection(Socket socket, MessageHandler messageHandler, String name) throws IOException {
        this(name);
        this.in = socket.getInputStream();
        this.socket = socket;
        this.out = socket.getOutputStream();
        Transformer myTransformer = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            myTransformer = factory.newTransformer();
            myTransformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "Failed to install transformer!", e);
        }
        this.xmlTransformer = myTransformer;
        this.thread = new ReceivingThread(this, this.in, name);
        this.messageHandler = messageHandler;
        this.name = name;
        this.thread.start();
    }

    private static Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress addr = new InetSocketAddress(host, port);
        socket.connect(addr, 5000);
        return socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setMessageHandler(MessageHandler mh) {
        this.messageHandler = mh;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public String getName() {
        return this.name;
    }

    public void close() {
        try {
            this.sendDumping(DOMMessage.createMessage("disconnect", new String[0]));
            this.reallyClose();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing " + this.toString(), e);
        }
    }

    public void reallyClose() throws IOException {
        if (this.thread != null) {
            this.thread.askToStop();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        logger.fine("Connection really closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Element element, boolean logOK) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            try {
                this.xmlTransformer.transform(new DOMSource(element), new StreamResult(this.out));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to transform and send!", e);
            }
            this.out.write(10);
            this.out.flush();
            this.out.notifyAll();
        }
        if (logOK) {
            logger.fine("Send: " + element.getTagName());
        }
    }

    public void send(Element element) throws IOException {
        this.send(element, logger.isLoggable(Level.FINE));
    }

    public void sendDumping(Element element) throws IOException {
        if (dump) {
            String x = this.getName() + "-send";
            try {
                System.err.println("<" + x + ">" + DOMMessage.elementToString(element) + "</" + x + ">\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.send(element);
    }

    public void sendAndWait(Element element) throws IOException {
        this.askDumping(element);
    }

    public Element ask(Element element) throws IOException {
        Element reply;
        int networkReplyId = this.thread.getNextNetworkReplyId();
        String tag = element.getTagName();
        if (Thread.currentThread() == this.thread) {
            throw new IOException("wait(ReceivingThread) for: " + tag);
        }
        Element question = element.getOwnerDocument().createElement("question");
        question.setAttribute("networkReplyId", Integer.toString(networkReplyId));
        question.appendChild(element);
        NetworkReplyObject nro = this.thread.waitForNetworkReply(networkReplyId);
        this.send(question, false);
        DOMMessage response = (DOMMessage)nro.getResponse();
        Element element2 = reply = response == null ? null : response.getDocument().getDocumentElement();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Ask(" + networkReplyId + "): " + tag + ", reply: " + (reply == null ? "null" : reply.getTagName()));
        }
        return reply == null ? null : (Element)reply.getFirstChild();
    }

    public Element askDumping(Element request) throws IOException {
        Element reply;
        if (dump) {
            String x = this.getName() + "-request";
            try {
                System.err.println("<" + x + ">" + DOMMessage.elementToString(request) + "</" + x + ">\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dump) {
            try {
                reply = this.ask(request);
                try {
                    String x = this.getName() + "-reply";
                    System.err.println("<" + x + ">" + DOMMessage.elementToString(reply) + "</" + x + ">\n");
                }
                catch (Exception x) {}
            }
            catch (IOException e) {
                try {
                    System.err.println("<" + this.getName() + "-exception e=\"" + e.getMessage() + "\" />\n");
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw e;
            }
        } else {
            reply = this.ask(request);
        }
        return reply;
    }

    public void handleAndSendReply(BufferedInputStream in) throws IOException {
        DOMMessage msg;
        boolean question;
        String networkReplyId;
        in.mark(200);
        XMLInputFactory xif = XMLInputFactory.newInstance();
        try {
            XMLStreamReader xmlIn = xif.createXMLStreamReader(in);
            xmlIn.nextTag();
            networkReplyId = xmlIn.getAttributeValue(null, "networkReplyId");
            question = xmlIn.getLocalName().equals("question");
            xmlIn.close();
        }
        catch (XMLStreamException xme) {
            logger.log(Level.WARNING, "XML stream failure", xme);
            return;
        }
        in.reset();
        try {
            msg = new DOMMessage(in);
        }
        catch (SAXException e) {
            logger.log(Level.WARNING, "Unable to read message.", e);
            return;
        }
        final Connection conn = this;
        Thread t = new Thread(msg.getType()){

            public void run() {
                Element element = msg.getDocument().getDocumentElement();
                try {
                    Element reply;
                    if (question) {
                        reply = Connection.this.messageHandler.handle(conn, (Element)element.getFirstChild());
                        if (reply == null) {
                            reply = DOMMessage.createMessage("reply", "networkReplyId", networkReplyId);
                        } else {
                            Element header = reply.getOwnerDocument().createElement("reply");
                            header.setAttribute("networkReplyId", networkReplyId);
                            header.appendChild(reply);
                            reply = header;
                        }
                    } else {
                        reply = Connection.this.messageHandler.handle(conn, element);
                    }
                    if (reply != null) {
                        conn.sendDumping(reply);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Handler failed: " + element.toString(), e);
                }
            }
        };
        t.setName(this.name + "-MessageHandler-" + t.getName());
        t.start();
    }

    public String toString() {
        return "[Connection " + this.name + " (" + this.socket + ") ]";
    }
}

