/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class ClaimLandMessage
extends DOMMessage {
    private String tileId;
    private String claimantId;
    private String priceString;

    public ClaimLandMessage(Tile tile, FreeColGameObject claimant, int price) {
        this.tileId = tile.getId();
        this.claimantId = claimant.getId();
        this.priceString = Integer.toString(price);
    }

    public ClaimLandMessage(Game game, Element element) {
        this.tileId = element.getAttribute("tile");
        this.claimantId = element.getAttribute("claimant");
        this.priceString = element.getAttribute("price");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element handle(FreeColServer server, Player player, Connection connection) {
        int price;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        ServerGame game = server.getGame();
        Tile tile = game.getFreeColGameObject(this.tileId, Tile.class);
        if (tile == null) {
            return DOMMessage.clientError("Not a file: " + this.tileId);
        }
        Unit unit = game.getFreeColGameObject(this.claimantId, Unit.class);
        Settlement settlement = game.getFreeColGameObject(this.claimantId, Settlement.class);
        if (unit != null) {
            if (!player.owns(unit)) {
                return DOMMessage.clientError("Not your unit: " + this.claimantId);
            }
            if (unit.getTile() != tile) {
                return DOMMessage.clientError("Unit not at tile: " + this.tileId);
            }
        } else {
            if (settlement == null) return DOMMessage.clientError("Not a unit or settlement: " + this.claimantId);
            if (!player.owns(settlement)) {
                return DOMMessage.clientError("Not your settlement: " + this.claimantId);
            }
            if (settlement.getOwner().isEuropean() && !settlement.getTile().isAdjacent(tile)) {
                return DOMMessage.clientError("Settlement can not claim tile: " + this.tileId);
            }
        }
        try {
            price = Integer.parseInt(this.priceString);
        }
        catch (NumberFormatException e) {
            return DOMMessage.clientError("Bad price: " + this.priceString);
        }
        int value = player.getLandPrice(tile);
        Player owner = tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        if (owner == null) {
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else if (owner == player) {
            if (settlement != null && ownerSettlement != null && tile.isInUse()) {
                return DOMMessage.createError("tileTakenSelf", null);
            }
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else if (owner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement() != settlement) return DOMMessage.createError("tileTakenEuro", null);
            price = 0;
            return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
        } else {
            if (price < 0 || price >= value) return server.getInGameController().claimLand(serverPlayer, tile, settlement, price);
            return DOMMessage.createError("tileTakenInd", null);
        }
    }

    public Element toXMLElement() {
        return ClaimLandMessage.createMessage(ClaimLandMessage.getXMLElementTagName(), "tile", this.tileId, "claimant", this.claimantId, "price", this.priceString);
    }

    public static String getXMLElementTagName() {
        return "claimLand";
    }
}

