/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseFoundingFatherMessage
extends DOMMessage {
    private List<FoundingFather> fathers;
    private FoundingFather foundingFather;

    public ChooseFoundingFatherMessage(List<FoundingFather> fathers) {
        this.fathers = fathers;
        this.foundingFather = null;
    }

    public ChooseFoundingFatherMessage(Game game, Element element) {
        FoundingFather f;
        String id;
        Specification spec = game.getSpecification();
        this.fathers = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            id = element.getAttribute(type.toString());
            if (id == null || "".equals(id) || (f = spec.getFoundingFather(id)) == null) continue;
            this.fathers.add(f);
        }
        id = element.getAttribute("foundingFather");
        this.foundingFather = id == null || "".equals(id) || (f = spec.getFoundingFather(id)) == null ? null : f;
    }

    public List<FoundingFather> getFathers() {
        return this.fathers;
    }

    public FoundingFather getResult() {
        return this.foundingFather;
    }

    public void setResult(FoundingFather foundingFather) {
        this.foundingFather = foundingFather;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        return null;
    }

    @Override
    public Element toXMLElement() {
        Element result = ChooseFoundingFatherMessage.createMessage(ChooseFoundingFatherMessage.getXMLElementTagName(), new String[0]);
        for (FoundingFather f : this.fathers) {
            result.setAttribute(f.getType().toString(), f.getId());
        }
        if (this.foundingFather != null) {
            result.setAttribute("foundingFather", this.foundingFather.getId());
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "chooseFoundingFather";
    }
}

