/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkLocation
extends UnitLocation
implements Ownable {
    private Colony colony;

    protected WorkLocation() {
    }

    protected WorkLocation(Game game) {
        super(game);
    }

    public WorkLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public WorkLocation(Game game, String id) {
        super(game, id);
    }

    public final void setColony(Colony newColony) {
        this.colony = newColony;
    }

    public Settlement getOwningSettlement() {
        return this.colony;
    }

    @Override
    public Player getOwner() {
        return this.colony.getOwner();
    }

    @Override
    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public boolean canBeWorked() {
        return this.getNoWorkReason() == UnitLocation.NoAddReason.NONE;
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public ProductionInfo getProductionInfo() {
        return this.getColony().getProductionInfo(this);
    }

    public List<AbstractGoods> getProduction() {
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return Collections.emptyList();
        }
        return info.getProduction();
    }

    public int getTotalProductionOf(GoodsType goodsType) {
        if (goodsType == null) {
            throw new IllegalArgumentException("Null GoodsType.");
        }
        for (AbstractGoods ag : this.getProduction()) {
            if (ag.getType() != goodsType) continue;
            return ag.getAmount();
        }
        return 0;
    }

    public int getMaximumProductionOf(GoodsType goodsType) {
        ProductionInfo info = this.getProductionInfo();
        if (info == null) {
            return 0;
        }
        List<AbstractGoods> production = info.getMaximumProduction();
        if (production != null) {
            for (AbstractGoods ag : production) {
                if (ag.getType() != goodsType) continue;
                return ag.getAmount();
            }
        }
        return this.getTotalProductionOf(goodsType);
    }

    @Override
    public final Tile getTile() {
        return this.colony.getTile();
    }

    @Override
    public boolean add(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (super.add(unit)) {
            if (this.canTeach()) {
                Unit student = unit.getStudent();
                if (student == null && (student = this.getColony().findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                }
                unit.setWorkType(null);
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher == null && (teacher = this.getColony().findTeacher(unit)) != null) {
                    unit.setTeacher(teacher);
                    teacher.setStudent(unit);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (super.remove(unit)) {
            if (this.canTeach()) {
                Unit student = unit.getStudent();
                if (student != null) {
                    student.setTeacher(null);
                    unit.setStudent(null);
                }
                unit.setTurnsOfTraining(0);
            }
            return true;
        }
        return false;
    }

    @Override
    public final Settlement getSettlement() {
        return this.colony;
    }

    @Override
    public final Colony getColony() {
        return this.colony;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isPerson() ? super.getNoAddReason(locatable) : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    public abstract UnitLocation.NoAddReason getNoWorkReason();

    public abstract boolean canAutoProduce();

    public abstract int getProductionOf(Unit var1, GoodsType var2);

    public abstract int getPotentialProduction(GoodsType var1, UnitType var2);

    public abstract List<Modifier> getProductionModifiers(GoodsType var1, UnitType var2);

    public abstract GoodsType getBestWorkType(Unit var1);

    public StringTemplate getClaimTemplate() {
        return StringTemplate.name("");
    }

    @Override
    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.colony = this.getFreeColGameObject(in, "colony", Colony.class);
    }

    @Override
    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("colony", this.colony.getId());
    }
}

