/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTypeChange
extends FreeColObject {
    public static final Map<ChangeType, String> tags = new EnumMap<ChangeType, String>(ChangeType.class);
    private UnitType newUnitType = null;
    protected int turnsToLearn = 0;
    protected Map<ChangeType, Integer> changeTypes = new EnumMap<ChangeType, Integer>(ChangeType.class);
    private List<Scope> scopes = null;
    private static final String TURNS_TO_LEARN_TAG = "turnsToLearn";
    private static final String UNIT_TAG = "unit";

    public UnitTypeChange() {
    }

    public UnitTypeChange(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setId(in.getAttributeValue(null, "id"));
        this.setSpecification(specification);
        this.readFromXML(in);
    }

    public final UnitType getNewUnitType() {
        return this.newUnitType;
    }

    public final void setNewUnitType(UnitType newUnitType) {
        this.newUnitType = newUnitType;
    }

    public final int getTurnsToLearn() {
        return this.turnsToLearn;
    }

    public final void setTurnsToLearn(int newTurnsToLearn) {
        this.turnsToLearn = newTurnsToLearn;
    }

    public Map<ChangeType, Integer> getChangeTypes() {
        return this.changeTypes;
    }

    public final int getProbability(ChangeType type) {
        Integer result = this.changeTypes.get((Object)type);
        return result == null ? 0 : result;
    }

    public boolean asResultOf(ChangeType type) {
        return this.changeTypes.containsKey((Object)type) && this.changeTypes.get((Object)type) > 0;
    }

    public boolean canBeTaught() {
        return this.asResultOf(ChangeType.EDUCATION) && this.turnsToLearn > 0;
    }

    public List<Scope> getScopes() {
        return this.scopes == null ? new ArrayList() : this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public boolean appliesTo(Player player) {
        if (this.scopes == null || this.scopes.isEmpty()) {
            return true;
        }
        for (Scope scope : this.scopes) {
            if (!scope.appliesTo(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(UnitTypeChange.getXMLElementTagName());
        if (this.newUnitType != null) {
            this.writeAttribute(out, UNIT_TAG, this.newUnitType);
        }
        if (this.turnsToLearn != Integer.MIN_VALUE) {
            this.writeAttribute(out, TURNS_TO_LEARN_TAG, this.turnsToLearn);
        }
        for (Map.Entry<ChangeType, Integer> entry : this.changeTypes.entrySet()) {
            this.writeAttribute(out, tags.get((Object)entry.getKey()), entry.getValue().toString());
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        if (this.hasAttribute(in, UNIT_TAG)) {
            this.newUnitType = spec.getType(in, UNIT_TAG, UnitType.class, null);
            this.turnsToLearn = this.getAttribute(in, TURNS_TO_LEARN_TAG, Integer.MIN_VALUE);
            if (this.turnsToLearn > 0) {
                this.changeTypes.put(ChangeType.EDUCATION, 100);
            }
            for (ChangeType type : ChangeType.values()) {
                String value = this.getAttribute(in, tags.get((Object)type), null);
                if (value == null) continue;
                if (value.equalsIgnoreCase("false")) {
                    this.changeTypes.put(type, 0);
                    continue;
                }
                if (value.equalsIgnoreCase("true")) {
                    this.changeTypes.put(type, 100);
                    continue;
                }
                this.changeTypes.put(type, Math.max(0, Math.min(100, new Integer(value))));
            }
        }
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.scopes = null;
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String tag = in.getLocalName();
        if (Scope.getXMLElementTagName().equals(tag)) {
            Scope scope = new Scope(in);
            if (scope != null) {
                if (this.scopes == null) {
                    this.scopes = new ArrayList<Scope>();
                }
                this.scopes.add(scope);
            }
        } else {
            super.readChild(in);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.newUnitType.toString());
        sb.append(" ");
        sb.append(Integer.toString(this.turnsToLearn));
        for (Map.Entry<ChangeType, Integer> entry : this.changeTypes.entrySet()) {
            sb.append(" ");
            sb.append(tags.get((Object)entry.getKey()));
            sb.append("/");
            sb.append(entry.getValue().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static final String getXMLElementTagName() {
        return "upgrade";
    }

    static {
        tags.put(ChangeType.EDUCATION, "learnInSchool");
        tags.put(ChangeType.NATIVES, "learnFromNatives");
        tags.put(ChangeType.EXPERIENCE, "learnFromExperience");
        tags.put(ChangeType.LOST_CITY, "learnInLostCity");
        tags.put(ChangeType.PROMOTION, "promotion");
        tags.put(ChangeType.CLEAR_SKILL, "clearSkill");
        tags.put(ChangeType.DEMOTION, "demotion");
        tags.put(ChangeType.CAPTURE, "capture");
        tags.put(ChangeType.CREATION, "creation");
        tags.put(ChangeType.ENTER_COLONY, "enterColony");
        tags.put(ChangeType.INDEPENDENCE, "independence");
        tags.put(ChangeType.UNDEAD, "undead");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        EDUCATION,
        NATIVES,
        EXPERIENCE,
        LOST_CITY,
        PROMOTION,
        CREATION,
        ENTER_COLONY,
        INDEPENDENCE,
        CLEAR_SKILL,
        DEMOTION,
        CAPTURE,
        UNDEAD;

    }
}

