/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public class PathNode {
    private Location location;
    private int movesLeft;
    private int turns;
    private boolean onCarrier = false;
    public PathNode next = null;
    public PathNode previous = null;

    public PathNode(Location location, int movesLeft, int turns, boolean onCarrier, PathNode previous, PathNode next) {
        this.location = location;
        this.movesLeft = movesLeft;
        this.turns = turns;
        this.onCarrier = onCarrier;
        this.previous = previous;
        this.next = next;
    }

    public Location getLocation() {
        return this.location;
    }

    public Tile getTile() {
        return this.location == null ? null : this.location.getTile();
    }

    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int movesLeft) {
        this.movesLeft = movesLeft;
    }

    public int getTurns() {
        return this.turns;
    }

    public void setTurns(int turns) {
        this.turns = turns;
    }

    public void addTurns(int turns) {
        PathNode p = this;
        while (p != null) {
            p.setTurns(p.getTurns() + turns);
            p = p.next;
        }
    }

    public boolean isOnCarrier() {
        return this.onCarrier;
    }

    public void setOnCarrier(boolean onCarrier) {
        this.onCarrier = onCarrier;
    }

    public int getLength() {
        int n = 0;
        PathNode temp = this;
        while (temp != null) {
            ++n;
            temp = temp.next;
        }
        return n;
    }

    public Map.Direction getDirection() {
        if (this.previous == null || this.previous.getTile() == null || this.getTile() == null) {
            return null;
        }
        Tile prev = this.previous.getTile();
        return prev.getMap().getDirection(prev, this.getTile());
    }

    public PathNode getTransportDropNode() {
        PathNode temp = this;
        while (temp.next != null && temp.isOnCarrier()) {
            temp = temp.next;
        }
        return temp;
    }

    public PathNode getFirstNode() {
        PathNode path = this;
        while (path.previous != null) {
            path = path.previous;
        }
        return path;
    }

    public PathNode getLastNode() {
        PathNode path = this;
        while (path.next != null) {
            path = path.next;
        }
        return path;
    }

    public int getTotalTurns() {
        return this.getLastNode().getTurns();
    }

    public int getTransportDropTurns() {
        return this.getTransportDropNode().getTurns();
    }

    public static int getCost(int turns, int movesLeft) {
        return 100 * turns + (100 - movesLeft);
    }

    public int getCost() {
        return PathNode.getCost(this.turns, this.movesLeft);
    }

    public PathNode getCarrierMove() {
        PathNode path = this;
        while (path != null) {
            if (path.isOnCarrier()) {
                return path;
            }
            path = path.next;
        }
        return null;
    }

    public boolean usesCarrier() {
        return this.getFirstNode().getCarrierMove() != null;
    }

    public String toString() {
        return "PathNode loc=" + ((FreeColGameObject)((Object)this.location)).toString() + " movesLeft=" + Integer.toString(this.movesLeft) + " turns=" + Integer.toString(this.turns) + " onCarrier=" + Boolean.toString(this.onCarrier) + " direction=" + (Object)((Object)this.getDirection()) + " cost=" + this.getCost();
    }

    public String fullPathToString() {
        StringBuilder sb = new StringBuilder(500);
        PathNode p = this;
        while (p != null) {
            sb.append(p.toString());
            sb.append("\n");
            p = p.next;
        }
        return sb.toString();
    }
}

