/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;

public class ModelMessage
extends StringTemplate {
    private String ownerId;
    private String sourceId;
    private String displayId;
    private MessageType messageType;
    private boolean beenDisplayed = false;

    public ModelMessage() {
    }

    public ModelMessage(String id, FreeColGameObject source, FreeColObject display) {
        this(MessageType.DEFAULT, id, source, display);
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source) {
        this(messageType, id, source, ModelMessage.getDefaultDisplay(messageType, source));
    }

    public ModelMessage(String id, FreeColGameObject source) {
        this(MessageType.DEFAULT, id, source, ModelMessage.getDefaultDisplay(MessageType.DEFAULT, source));
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source, FreeColObject display) {
        super(id, StringTemplate.TemplateType.TEMPLATE);
        this.messageType = messageType;
        this.sourceId = source.getId();
        this.displayId = display != null ? display.getId() : source.getId();
        this.ownerId = null;
    }

    public final ModelMessage setDefaultId(String newDefaultId) {
        super.setDefaultId(newDefaultId);
        return this;
    }

    private static FreeColObject getDefaultDisplay(MessageType messageType, FreeColGameObject source) {
        FreeColObject o = null;
        switch (messageType) {
            case SONS_OF_LIBERTY: 
            case GOVERNMENT_EFFICIENCY: {
                o = source.getSpecification().getGoodsType("model.goods.bells");
                break;
            }
            case UNIT_IMPROVED: 
            case UNIT_DEMOTED: 
            case UNIT_LOST: 
            case UNIT_ADDED: 
            case LOST_CITY_RUMOUR: 
            case COMBAT_RESULT: 
            case DEMANDS: 
            case GOODS_MOVEMENT: {
                o = source;
                break;
            }
            case BUILDING_COMPLETED: {
                o = source.getSpecification().getGoodsType("model.goods.hammers");
                break;
            }
            default: {
                if (!(source instanceof Player)) break;
                o = source;
            }
        }
        return o;
    }

    public boolean hasBeenDisplayed() {
        return this.beenDisplayed;
    }

    public void setBeenDisplayed(boolean beenDisplayed) {
        this.beenDisplayed = beenDisplayed;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getMessageTypeName() {
        return "model.message." + this.messageType.toString();
    }

    public void divert(FreeColGameObject newSource) {
        if (this.displayId == this.sourceId) {
            this.displayId = newSource.getId();
        }
        this.sourceId = newSource.getId();
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public ModelMessage add(String key, String value) {
        super.add(key, value);
        return this;
    }

    public ModelMessage add(String value) {
        super.add(value);
        return this;
    }

    public ModelMessage addName(String key, String value) {
        super.addName(key, value);
        return this;
    }

    public ModelMessage addName(String value) {
        super.addName(value);
        return this;
    }

    public ModelMessage addName(String key, FreeColObject object) {
        super.addName(key, object);
        return this;
    }

    public ModelMessage addAmount(String key, int amount) {
        super.addAmount(key, amount);
        return this;
    }

    public ModelMessage addStringTemplate(String key, StringTemplate template) {
        super.addStringTemplate(key, template);
        return this;
    }

    public ModelMessage addStringTemplate(StringTemplate template) {
        super.addStringTemplate(template);
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof ModelMessage) {
            ModelMessage m = (ModelMessage)o;
            if (this.sourceId.equals(m.sourceId) && this.getId().equals(m.getId()) && this.messageType == m.messageType) {
                return super.equals(m);
            }
        }
        return false;
    }

    public int hashCode() {
        int value = 1;
        value = 37 * value + this.sourceId.hashCode();
        value = 37 * value + this.getId().hashCode();
        value = 37 * value + this.messageType.ordinal();
        value = 37 * value + super.hashCode();
        return value;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, ModelMessage.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.ownerId != null) {
            out.writeAttribute("owner", this.ownerId);
        }
        out.writeAttribute("source", this.sourceId);
        if (this.displayId != null) {
            out.writeAttribute("display", this.displayId);
        }
        out.writeAttribute("messageType", this.messageType.toString());
        out.writeAttribute("hasBeenDisplayed", String.valueOf(this.beenDisplayed));
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.ownerId = in.getAttributeValue(null, "owner");
        this.messageType = Enum.valueOf(MessageType.class, this.getAttribute(in, "messageType", MessageType.DEFAULT.toString()));
        this.beenDisplayed = Boolean.parseBoolean(in.getAttributeValue(null, "hasBeenDisplayed"));
        this.sourceId = in.getAttributeValue(null, "source");
        this.displayId = in.getAttributeValue(null, "display");
        super.readChildren(in);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ModelMessage<" + this.hashCode() + ", ");
        sb.append((this.sourceId == null ? "null" : this.sourceId) + ", ");
        sb.append((this.displayId == null ? "null" : this.displayId) + ", ");
        sb.append(super.toString());
        sb.append(", " + (Object)((Object)this.messageType) + " >");
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "modelMessage";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        DEFAULT(""),
        WARNING("model.option.guiShowWarning"),
        SONS_OF_LIBERTY("model.option.guiShowSonsOfLiberty"),
        GOVERNMENT_EFFICIENCY("model.option.guiShowGovernmentEfficiency"),
        WAREHOUSE_CAPACITY("model.option.guiShowWarehouseCapacity"),
        UNIT_IMPROVED("model.option.guiShowUnitImproved"),
        UNIT_DEMOTED("model.option.guiShowUnitDemoted"),
        UNIT_LOST("model.option.guiShowUnitLost"),
        UNIT_ADDED("model.option.guiShowUnitAdded"),
        BUILDING_COMPLETED("model.option.guiShowBuildingCompleted"),
        FOREIGN_DIPLOMACY("model.option.guiShowForeignDiplomacy"),
        MARKET_PRICES("model.option.guiShowMarketPrices"),
        LOST_CITY_RUMOUR(null),
        MISSING_GOODS("model.option.guiShowMissingGoods"),
        TUTORIAL("model.option.guiShowTutorial"),
        COMBAT_RESULT(null),
        GIFT_GOODS("model.option.guiShowGifts"),
        DEMANDS("model.option.guiShowDemands"),
        GOODS_MOVEMENT("model.option.guiShowGoodsMovement");

        private String optionName;

        private MessageType(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }
    }
}

