/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Map
extends FreeColGameObject
implements Location {
    private static final Logger logger = Logger.getLogger(Map.class.getName());
    public static final int POLAR_HEIGHT = 2;
    private Tile[][] tiles;
    private Layer layer;
    private int minimumLatitude = -90;
    private int maximumLatitude = 90;
    private float latitudePerRow;
    private final java.util.Map<String, Region> regions = new HashMap<String, Region>();
    private boolean traceSearch = false;

    public Map(Game game, Tile[][] tiles) {
        super(game);
        this.tiles = tiles;
        this.setLayer(Layer.RESOURCES);
        this.calculateLatitudePerRow();
    }

    public Map(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public Map(Game game, String id) {
        super(game, id);
    }

    public static boolean isValid(int x, int y, int width, int height) {
        return x >= 0 && x < width && y >= 0 && y < height;
    }

    public boolean isValid(int x, int y) {
        return Map.isValid(x, y, this.getWidth(), this.getHeight());
    }

    public boolean isValid(Position position) {
        return this.isValid(position.getX(), position.getY());
    }

    public Tile getTile(int x, int y) {
        return this.isValid(x, y) ? this.tiles[x][y] : null;
    }

    public Tile getTile(Position p) {
        return this.getTile(p.getX(), p.getY());
    }

    public void setTile(Tile tile, int x, int y) {
        this.tiles[x][y] = tile;
    }

    public int getWidth() {
        return this.tiles == null ? 0 : this.tiles.length;
    }

    public int getHeight() {
        return this.tiles == null ? 0 : this.tiles[0].length;
    }

    public final Layer getLayer() {
        return this.layer;
    }

    public final void setLayer(Layer newLayer) {
        this.layer = newLayer;
    }

    public final int getMinimumLatitude() {
        return this.minimumLatitude;
    }

    public final void setMinimumLatitude(int newMinimumLatitude) {
        this.minimumLatitude = newMinimumLatitude;
        this.calculateLatitudePerRow();
    }

    public final int getMaximumLatitude() {
        return this.maximumLatitude;
    }

    public final void setMaximumLatitude(int newMaximumLatitude) {
        this.maximumLatitude = newMaximumLatitude;
        this.calculateLatitudePerRow();
    }

    public final float getLatitudePerRow() {
        return this.latitudePerRow;
    }

    private final void calculateLatitudePerRow() {
        this.latitudePerRow = 1.0f * (float)(this.maximumLatitude - this.minimumLatitude) / (float)(this.getHeight() - 1);
    }

    public int getLatitude(int row) {
        return this.minimumLatitude + (int)((float)row * this.latitudePerRow);
    }

    public int getRow(int latitude) {
        return (int)((float)(latitude - this.minimumLatitude) / this.latitudePerRow);
    }

    public Collection<Region> getRegions() {
        return this.regions.values();
    }

    public Region getRegion(String key) {
        return this.regions.get(key);
    }

    public Region getRegionByName(String name) {
        if (name == null) {
            return null;
        }
        for (Region region : this.regions.values()) {
            if (!name.equals(region.getName())) continue;
            return region;
        }
        return null;
    }

    public void putRegion(Region region) {
        this.regions.put(region.getNameKey(), region);
    }

    public static final boolean isSameLocation(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null ? false : l1.getTile() == l2.getTile()));
    }

    public static final boolean isSameContiguity(Location l1, Location l2) {
        return l1 == null || l2 == null ? false : (l1 == l2 ? true : (l1.getTile() == null || l2.getTile() == null ? false : l1.getTile().getContiguity() == l2.getTile().getContiguity()));
    }

    public boolean isPolar(Tile tile) {
        return tile.getY() <= 2 || tile.getY() >= this.getHeight() - 2 - 1;
    }

    public Direction getDirection(Tile t1, Tile t2) {
        for (Direction d : Direction.values()) {
            if (t1.getNeighbourOrNull(d) != t2) continue;
            return d;
        }
        return null;
    }

    public Tile getAdjacentTile(int x, int y, Direction direction) {
        return this.getTile(x += (y & 1) != 0 ? direction.getOddDX() : direction.getEvenDX(), y += (y & 1) != 0 ? direction.getOddDY() : direction.getEvenDY());
    }

    private SearchHeuristic getManhattenHeuristic(final Tile endTile) {
        return new SearchHeuristic(){

            public int getValue(Tile tile) {
                return tile.getDistanceTo(endTile);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Location findRealStart(Unit unit, Location start, Unit carrier) {
        Location entry;
        if (unit == null) {
            throw new IllegalArgumentException("Null unit.");
        }
        if (carrier != null && !carrier.canCarryUnits()) {
            throw new IllegalArgumentException("Non-carrier carrier: " + carrier);
        }
        if (carrier != null && !carrier.couldCarry(unit)) {
            throw new IllegalArgumentException("Carrier could not carry unit: " + carrier + "/" + unit);
        }
        if (start == null) {
            throw new IllegalArgumentException("Null start: " + unit);
        }
        if (start instanceof Unit) {
            Location unitLoc = ((Unit)start).getLocation();
            if (unitLoc == null) {
                throw new IllegalArgumentException("Null on-carrier start: " + unit + "/" + (Unit)start);
            }
            if (unitLoc instanceof HighSeas) {
                if (carrier == null) {
                    throw new IllegalArgumentException("Null carrier when starting on high seas: " + unit);
                }
                if (carrier != (Unit)start) {
                    throw new IllegalArgumentException("Wrong carrier when starting on high seas: " + unit + "/" + carrier + " != " + (Unit)start);
                }
                entry = carrier.resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                entry = unitLoc;
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else if (start instanceof HighSeas) {
            if (unit.isOnCarrier()) {
                entry = unit.getCarrier().resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                if (!unit.isNaval()) throw new IllegalArgumentException("No carrier when starting on high seas: " + unit + "/" + unit.getLocation());
                entry = unit.resolveDestination();
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else {
            if (!(start instanceof Europe) && start.getTile() == null) throw new IllegalArgumentException("Invalid start: " + start);
            entry = start;
        }
        return entry.getTile() != null ? entry.getTile() : entry;
    }

    private Location findRealEnd(Location end) {
        if (end == null) {
            throw new IllegalArgumentException("Null end.");
        }
        if (end instanceof Europe) {
            return end;
        }
        if (end.getTile() != null) {
            return end.getTile();
        }
        throw new IllegalArgumentException("Invalid end: " + end);
    }

    private PathNode getBestEntryPath(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        return this.searchMap(unit, tile, GoalDeciders.getHighSeasGoalDecider(), costDecider, Integer.MAX_VALUE, carrier, null);
    }

    public Tile getBestEntryTile(Unit unit, Tile tile, Unit carrier, CostDecider costDecider) {
        PathNode path = this.getBestEntryPath(unit, tile, carrier, costDecider);
        return path == null ? null : path.getLastNode().getTile();
    }

    private PathNode findMapPath(Unit unit, Tile start, Tile end, Unit carrier, CostDecider costDecider) {
        PathNode path;
        Unit offMapUnit = carrier != null ? carrier : unit;
        GoalDecider gd = GoalDeciders.getLocationGoalDecider(end);
        SearchHeuristic sh = this.getManhattenHeuristic(end);
        if (start.getContiguity() == end.getContiguity()) {
            PathNode carrierPath;
            path = this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, null, sh);
            PathNode pathNode = carrierPath = carrier == null ? null : this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh);
            if (carrierPath != null && (path == null || path.getLastNode().getCost() > carrierPath.getLastNode().getCost())) {
                path = carrierPath;
            }
        } else {
            path = offMapUnit != null ? this.searchMap(unit, start, gd, costDecider, Integer.MAX_VALUE, carrier, sh) : null;
        }
        return path;
    }

    public PathNode findPath(Unit unit, Location start, Location end, Unit carrier, CostDecider costDecider) {
        Location realStart = this.findRealStart(unit, start, carrier);
        Location realEnd = this.findRealEnd(end);
        Unit offMapUnit = carrier != null ? carrier : unit;
        PathNode path = null;
        if (realStart instanceof Europe && realEnd instanceof Europe) {
            path = new PathNode(realStart, unit.getMovesLeft(), 0, false, null, null);
        } else if (realStart instanceof Europe && realEnd instanceof Tile) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                return null;
            }
            PathNode p = this.getBestEntryPath(unit, (Tile)realEnd, carrier, costDecider);
            if (p == null) {
                return null;
            }
            Tile tile = p.getLastNode().getTile();
            path = this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider);
            if (path == null) {
                boolean old = this.traceSearch;
                this.setSearchTrace(true);
                path = this.findMapPath(unit, tile, (Tile)realEnd, carrier, costDecider);
                this.setSearchTrace(old);
                throw new IllegalStateException("FINDPATH-FAIL: " + unit + "/" + carrier + " from " + tile + " to " + end + "\n" + p.fullPathToString());
            }
            path.addTurns(offMapUnit.getSailTurns());
            path = path.previous = new PathNode(realStart, unit.getMovesLeft(), 0, carrier != null, null, path);
            if (carrier != null && unit.getLocation() != carrier) {
                path = path.previous = new PathNode(realStart, unit.getMovesLeft(), 0, false, null, path);
            }
        } else if (realStart instanceof Tile && realEnd instanceof Europe) {
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                return null;
            }
            path = this.searchMap(unit, (Tile)realStart, GoalDeciders.getHighSeasGoalDecider(), costDecider, Integer.MAX_VALUE, carrier, null);
            if (path != null) {
                PathNode last = path.getLastNode();
                last.next = new PathNode(realEnd, unit.getInitialMovesLeft(), last.getTurns() + offMapUnit.getSailTurns(), last.isOnCarrier(), last, null);
            }
        } else if (realStart instanceof Tile && realEnd instanceof Tile) {
            path = this.findMapPath(unit, (Tile)realStart, (Tile)realEnd, carrier, costDecider);
        } else {
            throw new IllegalStateException("Can not happen: " + realStart + ", " + realEnd);
        }
        if (path != null) {
            int initialTurns;
            int n = !unit.isAtSea() ? 0 : (initialTurns = (unit.isOnCarrier() ? unit.getCarrier() : unit).getWorkLeft());
            if (initialTurns != 0) {
                path.addTurns(initialTurns);
            }
        }
        return path;
    }

    public PathNode search(Unit unit, Location start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier) {
        PathNode path;
        Location realStart = this.findRealStart(unit, start, carrier);
        if (realStart instanceof Europe) {
            Unit offMapUnit;
            Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
            if (offMapUnit == null || !offMapUnit.getType().canMoveToHighSeas()) {
                return null;
            }
            path = this.searchMap(unit, (Tile)offMapUnit.getEntryLocation(), goalDecider, costDecider, maxTurns, carrier, null);
            if (path != null) {
                path = this.findPath(unit, realStart, path.getLastNode().getTile(), carrier, costDecider);
            }
        } else {
            path = this.searchMap(unit, realStart.getTile(), goalDecider, costDecider, maxTurns, carrier, null);
        }
        if (path != null) {
            int initialTurns;
            int n = !unit.isAtSea() ? 0 : (initialTurns = (unit.isOnCarrier() ? unit.getCarrier() : unit).getWorkLeft());
            if (initialTurns != 0) {
                path.addTurns(initialTurns);
            }
        }
        return path;
    }

    public void setSearchTrace(boolean trace) {
        this.traceSearch = trace;
    }

    private boolean usedCarrier(PathNode path) {
        while (path != null) {
            if (path.isOnCarrier()) {
                return true;
            }
            path = path.previous;
        }
        return false;
    }

    private static boolean embarkedThisTurn(PathNode p, int turns) {
        while (p != null) {
            if (p.getTurns() < turns) {
                return false;
            }
            if (!p.isOnCarrier()) {
                return true;
            }
            p = p.previous;
        }
        return false;
    }

    private PathNode searchMap(Unit unit, Tile start, GoalDecider goalDecider, CostDecider costDecider, int maxTurns, Unit carrier, SearchHeuristic searchHeuristic) {
        PathNode best;
        Unit offMapUnit;
        HashMap<String, PathNode> openList = new HashMap<String, PathNode>();
        HashMap<String, PathNode> closedList = new HashMap<String, PathNode>();
        final HashMap<String, Integer> f = new HashMap<String, Integer>();
        PriorityQueue<PathNode> openListQueue = new PriorityQueue<PathNode>(1024, new Comparator<PathNode>(){

            @Override
            public int compare(PathNode p1, PathNode p2) {
                return (Integer)f.get(p1.getLocation().getId()) - (Integer)f.get(p2.getLocation().getId());
            }
        });
        Europe europe = unit.getOwner().getEurope();
        ArrayList<PathNode> tracing = this.traceSearch ? new ArrayList<PathNode>() : null;
        Unit unit2 = offMapUnit = carrier != null ? carrier : unit;
        Unit currentUnit = start.isLand() ? (start.getSettlement() != null && start.getSettlement().isConnectedPort() && unit != null && unit.getLocation() == carrier ? carrier : unit) : offMapUnit;
        PathNode firstNode = new PathNode(start, currentUnit != null ? currentUnit.getMovesLeft() : -1, 0, carrier != null && currentUnit == carrier, null, null);
        f.put(start.getId(), new Integer(searchHeuristic == null ? 0 : searchHeuristic.getValue(start)));
        openList.put(start.getId(), firstNode);
        openListQueue.offer(firstNode);
        while (!openList.isEmpty()) {
            PathNode currentNode = openListQueue.poll();
            Location currentLocation = currentNode.getLocation();
            if (tracing != null) {
                tracing.add(currentNode);
            }
            openList.remove(currentLocation.getId());
            closedList.put(currentLocation.getId(), currentNode);
            Unit unit3 = currentUnit = currentNode.isOnCarrier() ? carrier : unit;
            if (goalDecider.check(currentUnit, currentNode) && !goalDecider.hasSubGoals()) break;
            if (currentNode.getTurns() > maxTurns) continue;
            int currentMovesLeft = currentNode.getMovesLeft();
            int currentTurns = currentNode.getTurns();
            boolean currentOnCarrier = currentNode.isOnCarrier();
            Tile currentTile = currentNode.getTile();
            if (currentTile == null) continue;
            for (Tile moveTile : currentTile.getSurroundingTiles(1)) {
                MoveCandidate move;
                if (currentNode.previous != null && currentNode.previous.getTile() == moveTile || closedList.containsKey(moveTile.getId())) continue;
                boolean isGoal = goalDecider.check(unit, new PathNode(moveTile, currentMovesLeft, currentTurns, false, currentNode, null));
                Unit.MoveType umt = unit.getSimpleMoveType(currentTile, moveTile);
                boolean unitMove = isGoal ? umt.isLegal() : umt.isProgress();
                boolean carrierMove = carrier != null && carrier.isTileAccessible(moveTile);
                boolean embarked = Map.embarkedThisTurn(currentNode, currentTurns);
                boolean disembarkToGoal = false;
                if (unitMove && carrierMove && currentOnCarrier && !embarked && isGoal) {
                    CostDecider cd = costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(carrier);
                    int cost = cd.getCost(carrier, currentNode.getLocation(), moveTile, currentMovesLeft);
                    if (cost == -1) {
                        carrierMove = false;
                    } else {
                        boolean bl = disembarkToGoal = cd.getNewTurns() > 0;
                    }
                }
                MoveStep step = currentOnCarrier ? (carrierMove && !disembarkToGoal ? MoveStep.BYWATER : (unitMove ? MoveStep.DISEMBARK : MoveStep.FAIL)) : (carrierMove && !this.usedCarrier(currentNode) ? MoveStep.EMBARK : (unitMove || isGoal ? (unit.isNaval() ? MoveStep.BYWATER : MoveStep.BYLAND) : MoveStep.FAIL));
                switch (step) {
                    case BYLAND: {
                        move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, false, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        break;
                    }
                    case BYWATER: {
                        move = new MoveCandidate(offMapUnit, currentNode, moveTile, currentMovesLeft, currentTurns, currentOnCarrier, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(offMapUnit));
                        break;
                    }
                    case EMBARK: {
                        move = new MoveCandidate(unit, currentNode, moveTile, currentMovesLeft, currentTurns, true, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        move.embarkUnit(carrier);
                        break;
                    }
                    case DISEMBARK: {
                        move = new MoveCandidate(unit, currentNode, moveTile, embarked ? 0 : unit.getInitialMovesLeft(), currentTurns, false, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(unit));
                        break;
                    }
                    default: {
                        move = null;
                    }
                }
                if (move == null) continue;
                move.resetPath();
                if (isGoal) {
                    move.recoverGoal();
                }
                if (!move.canImprove(openList.get(moveTile.getId()))) continue;
                move.improve(openList, openListQueue, f, searchHeuristic);
            }
            if (europe == null || currentNode.previous == null || currentNode.previous.getLocation() == europe || closedList.containsKey(europe.getId()) || currentUnit == null || !currentUnit.getType().canMoveToHighSeas() || !currentTile.isDirectlyHighSeasConnected()) continue;
            MoveCandidate move = new MoveCandidate(currentUnit, currentNode, europe, currentMovesLeft, currentTurns, currentOnCarrier, costDecider != null ? costDecider : CostDeciders.defaultCostDeciderFor(currentUnit));
            move.resetPath();
            if (!move.canImprove((PathNode)openList.get(europe.getId()))) continue;
            move.improve(openList, openListQueue, f, null);
        }
        if ((best = goalDecider.getGoal()) != null) {
            while (best.previous != null) {
                best.previous.next = best;
                best = best.previous;
            }
        }
        if (tracing != null) {
            String logMe = "Search trace(" + unit + ", " + start + ", " + (carrier == null ? "null" : carrier) + "):";
            for (PathNode p : tracing) {
                logMe = logMe + "\n   " + p;
            }
            if (best != null) {
                logMe = logMe + "\n" + best.fullPathToString();
            }
            logger.info(logMe);
        }
        return best;
    }

    public Tile searchCircle(Tile start, GoalDecider goalDecider, int radius) {
        Tile t;
        PathNode path;
        if (start == null || goalDecider == null || radius <= 0) {
            return null;
        }
        Iterator<Tile> i$ = this.getCircleTiles(start, true, radius).iterator();
        while (i$.hasNext() && (!goalDecider.check(null, path = new PathNode(t = i$.next(), 0, start.getDistanceTo(t), false, null, null)) || goalDecider.hasSubGoals())) {
        }
        PathNode best = goalDecider.getGoal();
        return best == null ? null : best.getTile();
    }

    private Iterable<Tile> makeMapIteratorIterable(final MapIterator m) {
        return new Iterable<Tile>(){

            @Override
            public Iterator<Tile> iterator() {
                return new Iterator<Tile>(){

                    @Override
                    public boolean hasNext() {
                        return m.hasNext();
                    }

                    @Override
                    public Tile next() {
                        return Map.this.getTile(m.next());
                    }

                    @Override
                    public void remove() {
                        m.remove();
                    }
                };
            }
        };
    }

    public CircleIterator getCircleIterator(Position center, boolean isFilled, int radius) {
        return new CircleIterator(center, isFilled, radius);
    }

    public Iterable<Tile> getCircleTiles(Tile center, boolean isFilled, int radius) {
        return this.makeMapIteratorIterable(this.getCircleIterator(center.getPosition(), isFilled, radius));
    }

    public MapIterator getWholeMapIterator() {
        return new WholeMapIterator();
    }

    public Iterable<Tile> getAllTiles() {
        return this.makeMapIteratorIterable(this.getWholeMapIterator());
    }

    public Tile getLandWithinDistance(int x, int y, int distance) {
        for (Tile t : this.getCircleTiles(this.getTile(x, y), true, distance)) {
            if (!t.isLand()) continue;
            return t;
        }
        return null;
    }

    public static boolean[][] floodFill(boolean[][] boolmap, Position p) {
        return Map.floodFill(boolmap, p, Integer.MAX_VALUE);
    }

    public static boolean[][] floodFill(boolean[][] boolmap, Position p, int limit) {
        LinkedList<Position> q = new LinkedList<Position>();
        boolean[][] visited = new boolean[boolmap.length][boolmap[0].length];
        visited[p.getX()][p.getY()] = true;
        --limit;
        do {
            for (Direction direction : Direction.values()) {
                Position n = p.getAdjacent(direction);
                if (!n.isValid(boolmap.length, boolmap[0].length) || !boolmap[n.getX()][n.getY()] || visited[n.getX()][n.getY()] || limit <= 0) continue;
                visited[n.getX()][n.getY()] = true;
                --limit;
                q.add(n);
            }
        } while ((p = (Position)q.poll()) != null && limit > 0);
        return visited;
    }

    public void resetContiguity() {
        Tile t;
        int xx;
        int yy;
        boolean[][] found;
        Tile tile;
        int x;
        int y;
        boolean[][] waterMap = new boolean[this.getWidth()][this.getHeight()];
        for (int y2 = 0; y2 < this.getHeight(); ++y2) {
            for (int x2 = 0; x2 < this.getWidth(); ++x2) {
                if (!this.isValid(x2, y2)) continue;
                waterMap[x2][y2] = !this.getTile(x2, y2).isLand();
            }
        }
        int contig = 0;
        for (y = 0; y < this.getHeight(); ++y) {
            for (x = 0; x < this.getWidth(); ++x) {
                tile = this.getTile(x, y);
                if (!waterMap[x][y] || tile.getContiguity() >= 0) continue;
                found = Map.floodFill(waterMap, new Position(x, y));
                for (yy = 0; yy < this.getHeight(); ++yy) {
                    for (xx = 0; xx < this.getWidth(); ++xx) {
                        if (!found[xx][yy] || (t = this.getTile(xx, yy)).getContiguity() >= 0) continue;
                        t.setContiguity(contig);
                    }
                }
                ++contig;
            }
        }
        for (y = 0; y < this.getHeight(); ++y) {
            for (x = 0; x < this.getWidth(); ++x) {
                if (!this.isValid(x, y)) continue;
                waterMap[x][y] = !waterMap[x][y];
            }
        }
        for (y = 0; y < this.getHeight(); ++y) {
            for (x = 0; x < this.getWidth(); ++x) {
                if (!waterMap[x][y] || (tile = this.getTile(x, y)).getContiguity() >= 0) continue;
                found = Map.floodFill(waterMap, new Position(x, y));
                for (yy = 0; yy < this.getHeight(); ++yy) {
                    for (xx = 0; xx < this.getWidth(); ++xx) {
                        if (!found[xx][yy] || (t = this.getTile(xx, yy)).getContiguity() >= 0) continue;
                        t.setContiguity(contig);
                    }
                }
                ++contig;
            }
        }
    }

    public void resetHighSeasCount() {
        ArrayList curr = new ArrayList();
        ArrayList<Tile> next = new ArrayList<Tile>();
        int hsc = 0;
        for (Tile t : this.getAllTiles()) {
            t.setHighSeasCount(-1);
            if (t.isLand()) continue;
            if ((t.getX() == 0 || t.getX() == this.getWidth() - 1) && t.getType().isHighSeasConnected() && !t.getType().isDirectlyHighSeasConnected() && t.getMoveToEurope() == null) {
                t.setMoveToEurope(true);
            }
            if (!t.isDirectlyHighSeasConnected()) continue;
            t.setHighSeasCount(hsc);
            next.add(t);
        }
        while (!next.isEmpty()) {
            ++hsc;
            curr.addAll(next);
            next.clear();
            while (!curr.isEmpty()) {
                Tile tile = (Tile)curr.remove(0);
                Position position = new Position(tile.getX(), tile.getY());
                for (Direction d : Direction.values()) {
                    Tile t;
                    Position p = position.getAdjacent(d);
                    if (!this.isValid(p) || (t = this.getTile(p)).getHighSeasCount() >= 0) continue;
                    t.setHighSeasCount(hsc);
                    if (t.isLand()) continue;
                    next.add(t);
                }
            }
        }
    }

    @Override
    public Tile getTile() {
        return null;
    }

    @Override
    public StringTemplate getLocationName() {
        return StringTemplate.key("NewWorld");
    }

    @Override
    public StringTemplate getLocationNameFor(Player player) {
        String name = player.getNewLandName();
        return name == null ? this.getLocationName() : StringTemplate.name(name);
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            unit.setLocation(unit.getEntryLocation());
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        Tile tile;
        if (locatable instanceof Unit && (tile = ((Unit)locatable).getTile()) != null) {
            return tile.remove(locatable);
        }
        return false;
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable instanceof Unit && locatable.getLocation() != null && locatable.getLocation().getTile() != null;
    }

    @Override
    public boolean canAdd(Locatable locatable) {
        return locatable instanceof Unit;
    }

    @Override
    public int getUnitCount() {
        return -1;
    }

    @Override
    public List<Unit> getUnitList() {
        return Collections.emptyList();
    }

    @Override
    public Iterator<Unit> getUnitIterator() {
        return this.getUnitList().iterator();
    }

    @Override
    public GoodsContainer getGoodsContainer() {
        return null;
    }

    @Override
    public Settlement getSettlement() {
        return null;
    }

    @Override
    public Colony getColony() {
        return null;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeStartElement(Map.getXMLElementTagName());
        this.writeAttributes(out, player, showAll, toSavedGame);
        this.writeChildren(out, player, showAll, toSavedGame);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        out.writeAttribute("ID", this.getId());
        out.writeAttribute("width", Integer.toString(this.getWidth()));
        out.writeAttribute("height", Integer.toString(this.getHeight()));
        out.writeAttribute("layer", this.layer.toString());
        out.writeAttribute("minimumLatitude", Integer.toString(this.minimumLatitude));
        out.writeAttribute("maximumLatitude", Integer.toString(this.maximumLatitude));
    }

    protected void writeChildren(XMLStreamWriter out, Player player, boolean showAll, boolean toSavedGame) throws XMLStreamException {
        for (Region region : this.regions.values()) {
            region.toXML(out);
        }
        for (Tile tile : this.getAllTiles()) {
            if (showAll || toSavedGame || player.hasExplored(tile)) {
                tile.toXML(out, player, showAll, toSavedGame);
                continue;
            }
            tile.toXMLMinimal(out);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        this.setLayer(Layer.valueOf(this.getAttribute(in, "layer", "ALL")));
        if (this.tiles == null) {
            int width = Integer.parseInt(in.getAttributeValue(null, "width"));
            int height = Integer.parseInt(in.getAttributeValue(null, "height"));
            this.tiles = new Tile[width][height];
        }
        this.minimumLatitude = this.getAttribute(in, "minimumLatitude", -90);
        this.maximumLatitude = this.getAttribute(in, "maximumLatitude", 90);
        this.calculateLatitudePerRow();
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        boolean fixupHighSeas = false;
        while (in.nextTag() != 2) {
            String tag = in.getLocalName();
            if (Tile.getXMLElementTagName().equals(tag)) {
                Tile t = this.updateFreeColGameObject(in, Tile.class);
                this.setTile(t, t.getX(), t.getY());
                if (t.getHighSeasCount() != Integer.MAX_VALUE) continue;
                fixupHighSeas = true;
                continue;
            }
            if (Region.getXMLElementTagName().equals(tag)) {
                this.putRegion(this.updateFreeColGameObject(in, Region.class));
                continue;
            }
            logger.warning("Unknown tag: " + tag + " loading map");
            in.nextTag();
        }
        if (fixupHighSeas) {
            this.resetHighSeasCount();
        }
    }

    public static String getXMLElementTagName() {
        return "map";
    }

    private final class WholeMapIterator
    extends MapIterator {
        private int x;
        private int y;

        public WholeMapIterator() {
            this.x = 0;
            this.y = 0;
        }

        public boolean hasNext() {
            return this.y < Map.this.getHeight();
        }

        public Position nextPosition() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("WholeMapIterator exhausted");
            }
            Position newPosition = new Position(this.x, this.y);
            ++this.x;
            if (this.x == Map.this.getWidth()) {
                this.x = 0;
                ++this.y;
            }
            return newPosition;
        }
    }

    private final class CircleIterator
    extends MapIterator {
        private int radius;
        private int currentRadius;
        private int n;
        private Position nextPosition;

        public CircleIterator(Position center, boolean isFilled, int radius) {
            this.nextPosition = null;
            if (center == null) {
                throw new IllegalArgumentException("center must not be null.");
            }
            this.radius = radius;
            this.n = 0;
            if (isFilled || radius == 1) {
                this.nextPosition = center.getAdjacent(Direction.NE);
                this.currentRadius = 1;
            } else {
                this.currentRadius = radius;
                this.nextPosition = center;
                for (int i = 1; i < radius; ++i) {
                    this.nextPosition = this.nextPosition.getAdjacent(Direction.N);
                }
                this.nextPosition = this.nextPosition.getAdjacent(Direction.NE);
            }
            if (!Map.this.isValid(this.nextPosition)) {
                this.determineNextPosition();
            }
        }

        public int getCurrentRadius() {
            return this.currentRadius;
        }

        private void determineNextPosition() {
            boolean positionReturned = this.n != 0;
            do {
                Direction direction;
                ++this.n;
                int width = this.currentRadius * 2;
                if (this.n >= width * 4) {
                    ++this.currentRadius;
                    if (this.currentRadius > this.radius) {
                        this.nextPosition = null;
                        continue;
                    }
                    if (!positionReturned) {
                        this.nextPosition = null;
                        continue;
                    }
                    this.n = 0;
                    positionReturned = false;
                    this.nextPosition = this.nextPosition.getAdjacent(Direction.NE);
                    continue;
                }
                int i = this.n / width;
                switch (i) {
                    case 0: {
                        direction = Direction.SE;
                        break;
                    }
                    case 1: {
                        direction = Direction.SW;
                        break;
                    }
                    case 2: {
                        direction = Direction.NW;
                        break;
                    }
                    case 3: {
                        direction = Direction.NE;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("i=" + i + ", n=" + this.n + ", width=" + width);
                    }
                }
                this.nextPosition = this.nextPosition.getAdjacent(direction);
            } while (this.nextPosition != null && !Map.this.isValid(this.nextPosition));
        }

        public boolean hasNext() {
            return this.nextPosition != null;
        }

        public Position nextPosition() {
            if (this.nextPosition == null) {
                return null;
            }
            Position p = this.nextPosition;
            this.determineNextPosition();
            return p;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MapIterator
    implements Iterator<Position> {
        private MapIterator() {
        }

        public abstract Position nextPosition() throws NoSuchElementException;

        @Override
        public Position next() {
            return this.nextPosition();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MoveCandidate {
        private Unit unit;
        private PathNode current;
        private Location dst;
        private int movesLeft;
        private int turns;
        private boolean onCarrier;
        private CostDecider decider;
        private int cost;
        private PathNode path;

        public MoveCandidate(Unit unit, PathNode current, Location dst, int movesLeft, int turns, boolean onCarrier, CostDecider decider) {
            this.unit = unit;
            this.current = current;
            this.dst = dst;
            this.movesLeft = movesLeft;
            this.turns = turns;
            this.onCarrier = onCarrier;
            this.decider = decider;
            this.cost = decider.getCost(unit, current.getLocation(), dst, movesLeft);
            if (this.cost != -1) {
                this.turns += decider.getNewTurns();
                this.movesLeft = decider.getMovesLeft();
                this.cost = PathNode.getCost(turns, movesLeft);
            }
            this.path = null;
        }

        public void embarkUnit(Unit unit) {
            this.unit = unit;
            this.movesLeft = unit.getInitialMovesLeft();
            this.cost = PathNode.getCost(this.turns, this.movesLeft);
        }

        public void resetPath() {
            this.path = new PathNode(this.dst, this.movesLeft, this.turns, this.onCarrier, this.current, null);
        }

        public void recoverGoal() {
            if (this.cost == -1 && this.unit != null && this.current.getTile() != null && this.dst.getTile() != null) {
                this.movesLeft = this.unit.getInitialMovesLeft();
                ++this.turns;
                this.cost = PathNode.getCost(this.turns, this.movesLeft);
                this.resetPath();
            }
        }

        public boolean canImprove(PathNode best) {
            return this.cost != -1 && (best == null || this.cost < best.getCost() || this.cost == best.getCost() && best.getLength() < this.path.getLength());
        }

        public void improve(HashMap<String, PathNode> openList, PriorityQueue<PathNode> openListQueue, HashMap<String, Integer> f, SearchHeuristic sh) {
            PathNode best = openList.get(this.dst.getId());
            if (best != null) {
                openList.remove(this.dst.getId());
                openListQueue.remove(best);
            }
            int fcost = this.cost;
            if (sh != null && this.dst.getTile() != null) {
                fcost += sh.getValue(this.dst.getTile());
            }
            f.put(this.dst.getId(), new Integer(fcost));
            openList.put(this.dst.getId(), this.path);
            openListQueue.offer(this.path);
        }

        public String toString() {
            return "[candidate unit=" + this.unit.toString() + " dst=" + ((FreeColGameObject)((Object)this.dst)).toString() + " movesLeft=" + this.movesLeft + " turns=" + this.turns + " onCarrier=" + this.onCarrier + " decider=" + this.decider + " cost=" + this.cost + "]";
        }
    }

    private static interface SearchHeuristic {
        public int getValue(Tile var1);
    }

    public static final class Position {
        public final int x;
        public final int y;

        public Position(int posX, int posY) {
            this.x = posX;
            this.y = posY;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isValid(int width, int height) {
            return Map.isValid(this.x, this.y, width, height);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            return this.x == ((Position)other).x && this.y == ((Position)other).y;
        }

        public int hashCode() {
            return this.x | this.y << 16;
        }

        public Position getAdjacent(Direction direction) {
            int x = this.x + ((this.y & 1) != 0 ? direction.getOddDX() : direction.getEvenDX());
            int y = this.y + ((this.y & 1) != 0 ? direction.getOddDY() : direction.getEvenDY());
            return new Position(x, y);
        }

        public int getDistance(Position position) {
            int ay = this.getY();
            int by = position.getY();
            int r = position.getX() - this.getX() - (ay - by) / 2;
            if (by > ay && ay % 2 == 0 && by % 2 != 0) {
                ++r;
            } else if (by < ay && ay % 2 != 0 && by % 2 == 0) {
                --r;
            }
            return Math.max(Math.abs(ay - by + r), Math.abs(r));
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        N(0, -2, 0, -2),
        NE(1, -1, 0, -1),
        E(1, 0, 1, 0),
        SE(1, 1, 0, 1),
        S(0, 2, 0, 2),
        SW(0, 1, -1, 1),
        W(-1, 0, -1, 0),
        NW(0, -1, -1, -1);

        public static final int NUMBER_OF_DIRECTIONS;
        public static final Direction[] longSides;
        public static final Direction[] corners;
        private int oddDX;
        private int oddDY;
        private int evenDX;
        private int evenDY;

        private Direction(int oddDX, int oddDY, int evenDX, int evenDY) {
            this.oddDX = oddDX;
            this.oddDY = oddDY;
            this.evenDX = evenDX;
            this.evenDY = evenDY;
        }

        public int getOddDX() {
            return this.oddDX;
        }

        public int getOddDY() {
            return this.oddDY;
        }

        public int getEvenDX() {
            return this.evenDX;
        }

        public int getEvenDY() {
            return this.evenDY;
        }

        private Direction rotate(int n) {
            return Direction.values()[(this.ordinal() + n + NUMBER_OF_DIRECTIONS) % NUMBER_OF_DIRECTIONS];
        }

        public Direction getNextDirection() {
            return this.rotate(1);
        }

        public Direction getPreviousDirection() {
            return this.rotate(-1);
        }

        public Direction getReverseDirection() {
            return this.rotate(NUMBER_OF_DIRECTIONS / 2);
        }

        public String getNameKey() {
            return "direction." + this.toString();
        }

        public static Direction getRandomDirection(String logMe, Random random) {
            return Direction.values()[Utils.randomInt(logger, logMe, random, NUMBER_OF_DIRECTIONS)];
        }

        public static Direction[] getRandomDirections(String logMe, Random random) {
            int[] randoms = Utils.randomInts(logger, logMe, random, NUMBER_OF_DIRECTIONS, NUMBER_OF_DIRECTIONS);
            Direction[] directions = Direction.values();
            for (int i = 0; i < directions.length; ++i) {
                if (randoms[i] == i) continue;
                Direction temp = directions[randoms[i]];
                directions[randoms[i]] = directions[i];
                directions[i] = temp;
            }
            return directions;
        }

        public Direction[] getClosestDirections(String logMe, Random random) {
            int nbits = (NUMBER_OF_DIRECTIONS - 2) / 2;
            int r = Utils.randomInt(logger, logMe, random, 1 << nbits);
            Direction[] ret = new Direction[NUMBER_OF_DIRECTIONS];
            ret[0] = this;
            int step = 1;
            int mask = 1;
            for (int i = 1; i < NUMBER_OF_DIRECTIONS - 1; i += 2) {
                Direction dr = this.rotate(step);
                Direction dl = this.rotate(NUMBER_OF_DIRECTIONS - step);
                ret[i] = (r & mask) == 0 ? dr : dl;
                ret[i + 1] = (r & mask) == 0 ? dl : dr;
                ++step;
                mask *= 2;
            }
            ret[Direction.NUMBER_OF_DIRECTIONS - 1] = this.getReverseDirection();
            return ret;
        }

        static {
            NUMBER_OF_DIRECTIONS = Direction.values().length;
            longSides = new Direction[]{NE, SE, SW, NW};
            corners = new Direction[]{N, E, S, W};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Layer {
        NONE,
        LAND,
        TERRAIN,
        REGIONS,
        RIVERS,
        RESOURCES,
        NATIVES,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MoveStep {
        FAIL,
        BYLAND,
        BYWATER,
        EMBARK,
        DISEMBARK;

    }
}

