/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.OptionGroup;

public class FreeColGameObjectType
extends FreeColObject {
    protected static final String DELETE_TAG = "delete";
    protected static final String EXTENDS_TAG = "extends";
    public static final String PRESERVE_TAG = "preserve";
    private int index = -1;
    private int modifierIndex = 100;
    private boolean abstractType;
    private FeatureContainer featureContainer = null;
    private static final String ABSTRACT_TAG = "abstract";

    protected FreeColGameObjectType() {
    }

    public FreeColGameObjectType(String id) {
        this(id, null);
    }

    public FreeColGameObjectType(Specification specification) {
        this(null, specification);
    }

    public FreeColGameObjectType(String id, Specification specification) {
        this.setId(id);
        this.setSpecification(specification);
    }

    public final FeatureContainer getFeatureContainer() {
        if (this.featureContainer == null) {
            this.featureContainer = new FeatureContainer();
        }
        return this.featureContainer;
    }

    protected int getIndex() {
        return this.index;
    }

    protected final void setIndex(int index) {
        this.index = index;
    }

    public final String getNameKey() {
        return this.getId() + ".name";
    }

    public final String getDescriptionKey() {
        return this.getId() + ".description";
    }

    public final String getSuffix(String prefix) {
        return this.getId().startsWith(prefix) ? this.getId().substring(prefix.length()) : this.getId();
    }

    public void applyDifficultyLevel(OptionGroup difficulty) {
    }

    public final int getModifierIndex() {
        return this.modifierIndex;
    }

    public int getModifierIndex(Modifier modifier) {
        return this.modifierIndex;
    }

    public final void setModifierIndex(int newModifierIndex) {
        this.modifierIndex = newModifierIndex;
    }

    public final boolean isAbstractType() {
        return this.abstractType;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        super.toXML(out, tag);
    }

    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.featureContainer != null) {
            for (Ability ability : this.getAbilities()) {
                ability.toXMLImpl(out);
            }
            for (Modifier modifier : this.getModifiers()) {
                modifier.toXMLImpl(out);
            }
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.abstractType = this.getAttribute(in, ABSTRACT_TAG, false);
    }

    protected boolean readShouldClearContainers(XMLStreamReader in) {
        return !this.hasAttribute(in, EXTENDS_TAG) && !this.hasAttribute(in, PRESERVE_TAG);
    }

    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        if (this.featureContainer != null && this.readShouldClearContainers(in)) {
            this.featureContainer.clear();
        }
        super.readChildren(in);
    }

    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = in.getLocalName();
        if (Ability.getXMLElementTagName().equals(tag)) {
            if (this.getAttribute(in, DELETE_TAG, false)) {
                String id = this.getAttribute(in, "id", null);
                this.removeAbilities(id);
                in.nextTag();
            } else {
                Ability ability = new Ability(in, spec);
                if (ability.getSource() == null) {
                    ability.setSource(this);
                }
                this.addAbility(ability);
                spec.addAbility(ability);
            }
        } else if (Modifier.getXMLElementTagName().equals(tag)) {
            if (this.getAttribute(in, DELETE_TAG, false)) {
                String id = this.getAttribute(in, "id", null);
                this.removeModifiers(id);
                in.nextTag();
            } else {
                Modifier modifier = new Modifier(in, spec);
                if (modifier.getSource() == null) {
                    modifier.setSource(this);
                }
                if (modifier.getIndex() < 0) {
                    modifier.setIndex(this.getModifierIndex(modifier));
                }
                this.addModifier(modifier);
                spec.addModifier(modifier);
            }
        } else {
            super.readChild(in);
        }
    }

    public String toString() {
        return this.getId();
    }
}

