/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Effect;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.RandomChoice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Disaster
extends FreeColGameObjectType {
    public static final String BANKRUPTCY = "model.disaster.bankruptcy";
    private boolean natural = false;
    private Effects numberOfEffects = Effects.ONE;
    private List<RandomChoice<Effect>> effects;

    public Disaster(String id, Specification specification) {
        super(id, specification);
    }

    public final boolean isNatural() {
        return this.natural;
    }

    public final void setNatural(boolean newNatural) {
        this.natural = newNatural;
    }

    public final Effects getNumberOfEffects() {
        return this.numberOfEffects;
    }

    public final void setNumberOfEffects(Effects newNumberOfEffects) {
        this.numberOfEffects = newNumberOfEffects;
    }

    public final List<RandomChoice<Effect>> getEffects() {
        return this.effects;
    }

    public final void setEffects(List<RandomChoice<Effect>> newEffects) {
        this.effects = newEffects;
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String extendString = in.getAttributeValue(null, "extends");
        Disaster parent = extendString == null ? this : this.getSpecification().getDisaster(extendString);
        this.natural = this.getAttribute(in, "natural", parent.natural);
        String effectString = in.getAttributeValue(null, "effects");
        this.numberOfEffects = effectString == null ? parent.numberOfEffects : Effects.valueOf(effectString);
        this.effects = new ArrayList<RandomChoice<Effect>>();
        if (parent != this) {
            for (RandomChoice<Effect> choice : parent.effects) {
                Effect effect = new Effect(choice.getObject());
                effect.getFeatureContainer().replaceSource(parent, this);
                this.effects.add(new RandomChoice<Effect>(effect, effect.getProbability()));
            }
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        String nodeName = in.getLocalName();
        if ("effect".equals(nodeName)) {
            Effect effect = new Effect(in, this.getSpecification());
            effect.getFeatureContainer().replaceSource(null, this);
            this.effects.add(new RandomChoice<Effect>(effect, effect.getProbability()));
        } else {
            super.readChild(in);
        }
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Disaster.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("natural", Boolean.toString(this.natural));
        out.writeAttribute("effects", this.numberOfEffects.toString());
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        for (RandomChoice<Effect> choice : this.effects) {
            choice.getObject().toXMLImpl(out);
        }
    }

    public static String getXMLElementTagName() {
        return "disaster";
    }

    @Override
    public String toString() {
        String result = this.getId();
        for (RandomChoice<Effect> choice : this.effects) {
            result = result + " " + choice.getObject();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Effects {
        ONE,
        SEVERAL,
        ALL;

    }
}

