/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TradeItem;

public class ColonyTradeItem
extends TradeItem {
    private String colonyId;
    private Colony colony;
    private String colonyName;

    public ColonyTradeItem(Game game, Player source, Player destination, Colony colony) {
        super(game, "tradeItem.colony", source, destination);
        this.colony = colony;
        this.colonyId = colony.getId();
        this.colonyName = colony.getName();
    }

    public ColonyTradeItem(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
        this.readFromXML(in);
    }

    public boolean isValid() {
        return this.colony.getOwner() == this.getSource() && this.getDestination().isEuropean();
    }

    public boolean isUnique() {
        return false;
    }

    public String getColonyName() {
        return this.colonyName;
    }

    public Colony getColony() {
        return this.colony;
    }

    public void setColony(Colony colony) {
        this.colony = colony;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, ColonyTradeItem.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("colony", this.colonyId);
        out.writeAttribute("colonyName", this.colonyName);
    }

    public void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readFromXML(in);
        this.colonyName = in.getAttributeValue(null, "colonyName");
        this.colonyId = in.getAttributeValue(null, "colony");
        this.colony = this.game.getFreeColGameObject(this.colonyId, Colony.class);
        in.nextTag();
    }

    public static String getXMLElementTagName() {
        return "colonyTradeItem";
    }
}

