/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildingType
extends BuildableType
implements Comparable<BuildingType> {
    private int level = 1;
    private int workPlaces = 3;
    private int basicProduction = 3;
    private int minSkill = Integer.MIN_VALUE;
    private int maxSkill = Integer.MAX_VALUE;
    private int upkeep = 0;
    private int priority = 800;
    private GoodsType consumes = null;
    private GoodsType produces = null;
    private Modifier productionModifier = null;
    private BuildingType upgradesFrom = null;
    private BuildingType upgradesTo = null;
    private static final String BASIC_PRODUCTION_TAG = "basicProduction";
    private static final String CONSUMES_TAG = "consumes";
    private static final String MAX_SKILL_TAG = "maxSkill";
    private static final String MIN_SKILL_TAG = "minSkill";
    private static final String PRIORITY_TAG = "priority";
    private static final String PRODUCES_TAG = "produces";
    private static final String UPGRADES_FROM_TAG = "upgradesFrom";
    private static final String UPKEEP_TAG = "upkeep";
    private static final String WORKPLACES_TAG = "workplaces";

    public BuildingType(String id, Specification specification) {
        super(id, specification);
        this.setModifierIndex(Modifier.BUILDING_PRODUCTION_INDEX);
    }

    public int getLevel() {
        return this.level;
    }

    public int getWorkPlaces() {
        return this.workPlaces;
    }

    public int getBasicProduction() {
        return this.basicProduction;
    }

    public int getUpkeep() {
        return this.upkeep;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean canAdd(UnitType unitType) {
        return this.workPlaces > 0 && unitType.hasSkill() && unitType.getSkill() >= this.minSkill && unitType.getSkill() <= this.maxSkill;
    }

    public FreeColGameObjectType getType() {
        return this;
    }

    public Modifier getProductionModifier() {
        return this.productionModifier;
    }

    public BuildingType getUpgradesFrom() {
        return this.upgradesFrom;
    }

    public BuildingType getUpgradesTo() {
        return this.upgradesTo;
    }

    public BuildingType getFirstLevel() {
        BuildingType buildingType = this;
        while (buildingType.getUpgradesFrom() != null) {
            buildingType = buildingType.getUpgradesFrom();
        }
        return buildingType;
    }

    public boolean isAutomaticBuild() {
        return !this.needsGoodsToBuild() && this.getUpgradesFrom() == null;
    }

    public GoodsType getConsumedGoodsType() {
        return this.consumes;
    }

    public GoodsType getProducedGoodsType() {
        return this.produces;
    }

    @Override
    public final int getModifierIndex(Modifier modifier) {
        if (this.produces != null && this.produces.getId().equals(modifier.getId())) {
            return Modifier.AUTO_PRODUCTION_INDEX;
        }
        return this.getModifierIndex();
    }

    @Override
    public int compareTo(BuildingType other) {
        return this.getIndex() - other.getIndex();
    }

    @Override
    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, BuildingType.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.upgradesFrom != null) {
            this.writeAttribute(out, UPGRADES_FROM_TAG, this.upgradesFrom);
        }
        this.writeAttribute(out, WORKPLACES_TAG, this.workPlaces);
        this.writeAttribute(out, BASIC_PRODUCTION_TAG, this.basicProduction);
        if (this.minSkill != Integer.MIN_VALUE) {
            this.writeAttribute(out, MIN_SKILL_TAG, this.minSkill);
        }
        if (this.maxSkill < Integer.MAX_VALUE) {
            this.writeAttribute(out, MAX_SKILL_TAG, this.maxSkill);
        }
        if (this.upkeep > 0) {
            this.writeAttribute(out, UPKEEP_TAG, this.upkeep);
        }
        if (this.priority != 800) {
            this.writeAttribute(out, PRIORITY_TAG, this.priority);
        }
        if (this.consumes != null) {
            this.writeAttribute(out, CONSUMES_TAG, this.consumes);
        }
        if (this.produces != null) {
            this.writeAttribute(out, PRODUCES_TAG, this.produces);
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(in);
        BuildingType parent = spec.getType(in, "extends", BuildingType.class, this);
        this.upgradesFrom = spec.getType(in, UPGRADES_FROM_TAG, BuildingType.class, null);
        if (this.upgradesFrom == null) {
            this.level = 1;
        } else {
            this.upgradesFrom.upgradesTo = this;
            this.level = this.upgradesFrom.level + 1;
        }
        this.workPlaces = this.getAttribute(in, WORKPLACES_TAG, parent.workPlaces);
        this.basicProduction = this.getAttribute(in, BASIC_PRODUCTION_TAG, parent.basicProduction);
        this.minSkill = this.getAttribute(in, MIN_SKILL_TAG, parent.minSkill);
        this.maxSkill = this.getAttribute(in, MAX_SKILL_TAG, parent.maxSkill);
        this.upkeep = this.getAttribute(in, UPKEEP_TAG, parent.upkeep);
        this.priority = this.getAttribute(in, PRIORITY_TAG, parent.priority);
        this.consumes = spec.getType(in, CONSUMES_TAG, GoodsType.class, parent.consumes);
        this.produces = spec.getType(in, PRODUCES_TAG, GoodsType.class, parent.produces);
        if (this.produces != null && this.basicProduction > 0) {
            this.productionModifier = new Modifier(this.produces.getId(), this, this.basicProduction, Modifier.Type.ADDITIVE);
        }
        if (parent != this) {
            if (!this.hasAttribute(in, "required-population")) {
                this.setRequiredPopulation(parent.getRequiredPopulation());
            }
            this.addFeatures(parent);
            if (parent.isAbstractType()) {
                this.getFeatureContainer().replaceSource(parent, this);
            }
        }
    }

    public void fixup09x() {
        try {
            if (this.hasAbility("model.ability.autoProduction")) {
                if (!this.hasAbility("model.ability.avoidExcessProduction")) {
                    Ability ability = new Ability("model.ability.avoidExcessProduction");
                    this.addAbility(ability);
                    this.removeModifiers("model.goods.horses");
                    float value = "model.building.country".equals(this.getId()) ? 50.0f : 25.0f;
                    Modifier modifier = new Modifier("model.modifier.breedingDivisor", this, value, Modifier.Type.ADDITIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                    modifier = new Modifier("model.modifier.breedingFactor", this, 2.0f, Modifier.Type.ADDITIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                }
                if (this.getModifierSet("model.modifier.consumeOnlySurplusProduction").isEmpty()) {
                    Modifier modifier = new Modifier("model.modifier.consumeOnlySurplusProduction", this, 0.5f, Modifier.Type.MULTIPLICATIVE);
                    this.addModifier(modifier);
                    this.getSpecification().addModifier(modifier);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getXMLElementTagName() {
        return "building-type";
    }
}

