/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Specification;

public final class Ability
extends Feature {
    public static final String ADD_TAX_TO_BELLS = "model.ability.addTaxToBells";
    public static final String AUTO_PRODUCTION = "model.ability.autoProduction";
    public static final String AVOID_EXCESS_PRODUCTION = "model.ability.avoidExcessProduction";
    public static final String BOMBARD = "model.ability.bombard";
    public static final String BORN_IN_COLONY = "model.ability.bornInColony";
    public static final String BORN_IN_INDIAN_SETTLEMENT = "model.ability.bornInIndianSettlement";
    public static final String BUILD = "model.ability.build";
    public static final String CAN_BE_CAPTURED = "model.ability.canBeCaptured";
    public static final String CAN_BE_EQUIPPED = "model.ability.canBeEquipped";
    public static final String CAN_TEACH = "model.ability.teach";
    public static final String CAPTURE_GOODS = "model.ability.captureGoods";
    public static final String CAPTURE_UNITS = "model.ability.captureUnits";
    public static final String CARRY_GOODS = "model.ability.carryGoods";
    public static final String CARRY_UNITS = "model.ability.carryUnits";
    public static final String CARRY_TREASURE = "model.ability.carryTreasure";
    public static final String CONSUME_ALL_OR_NOTHING = "model.ability.consumeAllOrNothing";
    public static final String EXPERT_MISSIONARY = "model.ability.expertMissionary";
    public static final String EXPERT_PIONEER = "model.ability.expertPioneer";
    public static final String EXPERT_SCOUT = "model.ability.expertScout";
    public static final String EXPERT_SOLDIER = "model.ability.expertSoldier";
    public static final String EXPERTS_USE_CONNECTIONS = "model.ability.expertsUseConnections";
    public static final String EXPORT = "model.ability.export";
    public static final String FOUND_COLONY = "model.ability.foundColony";
    public static final String NAVAL_UNIT = "model.ability.navalUnit";
    public static final String PIRACY = "model.ability.piracy";
    public static final String PRODUCE_IN_WATER = "model.ability.produceInWater";
    public static final String REPAIR_UNITS = "model.ability.repairUnits";
    private boolean value = true;

    public Ability(String id) {
        this(id, null, true);
    }

    public Ability(String id, boolean value) {
        this(id, null, value);
    }

    public Ability(String id, FreeColGameObjectType source, boolean value) {
        this.setId(id);
        this.setSource(source);
        this.value = value;
    }

    public Ability(Ability template) {
        super.copy(template);
        this.value = template.value;
    }

    public Ability(XMLStreamReader in, Specification specification) throws XMLStreamException {
        this.setSpecification(specification);
        this.readFromXML(in);
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean newValue) {
        this.value = newValue;
    }

    public int hashCode() {
        int hash = super.hashCode();
        return hash += this.value ? 1 : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ability) {
            return super.equals(o) && this.value == ((Ability)o).value;
        }
        return false;
    }

    public void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, Ability.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        this.writeAttribute(out, "value", this.value);
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.value = this.getAttribute(in, "value", true);
    }

    public String toString() {
        return "[ " + this.getId() + (this.getSource() == null ? " " : " (" + this.getSource().getId() + ")") + " = " + this.value + " ]";
    }

    public static String getXMLElementTagName() {
        return "ability";
    }
}

