/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.model.Specification;

public class FreeColModFile
extends FreeColDataFile {
    public static final String SPECIFICATION_FILE = "specification.xml";
    public static final String MOD_DESCRIPTOR_FILE = "mod.xml";
    public static final String[] FILE_ENDINGS = new String[]{".fmd", ".zip"};
    private String id;
    private String parent;

    public FreeColModFile(File file) throws IOException {
        super(file);
        this.readModDescriptor();
    }

    public InputStream getSpecificationInputStream() throws IOException {
        return this.getInputStream(SPECIFICATION_FILE);
    }

    public Specification getSpecification() throws IOException {
        InputStream si = this.getSpecificationInputStream();
        Specification specification = new Specification(si);
        si.close();
        return specification;
    }

    protected void readModDescriptor() throws IOException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader in = null;
        try {
            in = xif.createXMLStreamReader(this.getModDescriptorInputStream());
            in.nextTag();
            this.id = in.getAttributeValue(null, "id");
            this.parent = in.getAttributeValue(null, "parent");
        }
        catch (XMLStreamException e) {
            IOException e2 = new IOException("XMLStreamException.");
            e2.initCause(e);
            throw e2;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private InputStream getModDescriptorInputStream() throws IOException {
        return this.getInputStream(MOD_DESCRIPTOR_FILE);
    }

    protected String[] getFileEndings() {
        return FILE_ENDINGS;
    }

    public String getId() {
        return this.id;
    }

    public String getParent() {
        return this.parent;
    }
}

