/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.debug;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.server.FreeColServer;

public class FreeColDebugger {
    private static final Logger logger = Logger.getLogger(FreeColDebugger.class.getName());
    private static int debugMode = 0;
    private static int debugRunTurns = -1;
    private static String debugRunSave = null;

    public static boolean isInDebugMode() {
        return debugMode != 0;
    }

    public static boolean isInDebugMode(DebugMode mode) {
        return (1 << mode.ordinal() & debugMode) != 0;
    }

    private static void setDebugMode(int mode) {
        debugMode = mode;
    }

    public static void enableDebugMode(DebugMode mode) {
        debugMode |= 1 << mode.ordinal();
    }

    public static String getDebugModes() {
        String ret = "";
        for (DebugMode mode : DebugMode.values()) {
            if (!FreeColDebugger.isInDebugMode(mode)) continue;
            ret = ret + "," + mode.toString();
        }
        return ret.length() > 0 ? ret.substring(1, ret.length()) : ret;
    }

    public static void setDebugModes(String optionValue) {
        if (optionValue == null) {
            return;
        }
        try {
            int i = Integer.parseInt(optionValue);
            switch (i) {
                case 3: {
                    FreeColDebugger.enableDebugMode(DebugMode.COMMS);
                }
                case 2: {
                    FreeColDebugger.enableDebugMode(DebugMode.INIT);
                }
                case 1: {
                    FreeColDebugger.enableDebugMode(DebugMode.MENUS);
                    return;
                }
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        for (String s : optionValue.split(",")) {
            try {
                DebugMode mode = Enum.valueOf(DebugMode.class, s.toUpperCase(Locale.US));
                FreeColDebugger.enableDebugMode(mode);
            }
            catch (Exception e) {
                logger.warning("Unrecognized debug mode: " + optionValue);
            }
        }
    }

    public static void configureDebugRun(String option) {
        int comma = option.indexOf(",");
        String turns = option.substring(0, comma < 0 ? option.length() : comma);
        try {
            FreeColDebugger.setDebugRunTurns(Integer.parseInt(turns));
        }
        catch (NumberFormatException e) {
            FreeColDebugger.setDebugRunTurns(-1);
        }
        if (comma > 0) {
            FreeColDebugger.setDebugRunSave(option.substring(comma + 1));
        }
    }

    public static int getDebugRunTurns() {
        return debugRunTurns;
    }

    public static void setDebugRunTurns(int debugRunTurns) {
        FreeColDebugger.debugRunTurns = debugRunTurns;
    }

    public static String getDebugRunSave() {
        return debugRunSave;
    }

    public static void setDebugRunSave(String debugRunSave) {
        FreeColDebugger.debugRunSave = debugRunSave;
    }

    public static boolean finishDebugRun(FreeColClient freeColClient, boolean force) {
        if (FreeColDebugger.getDebugRunTurns() < 0) {
            return false;
        }
        if (FreeColDebugger.getDebugRunTurns() > 0 && !force) {
            return false;
        }
        FreeColDebugger.setDebugRunTurns(-1);
        if (FreeColDebugger.getDebugRunSave() != null) {
            FreeColServer fcs = freeColClient.getFreeColServer();
            if (fcs != null) {
                try {
                    fcs.saveGame(new File(".", FreeColDebugger.getDebugRunSave()), freeColClient.getMyPlayer().getName(), freeColClient.getClientOptions());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            freeColClient.quit();
        }
        return true;
    }

    public static void signalEndDebugRun() {
        if (debugRunTurns > 0) {
            FreeColDebugger.setDebugRunTurns(0);
        }
    }

    public static void handleCrash(LogRecord record) {
        if (debugRunSave != null) {
            FreeColDebugger.signalEndDebugRun();
        }
    }

    public static void debugLog(String msg) {
        try {
            new PrintStream(new FileOutputStream("/tmp/freecol.debug", true), true).println(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String stackTraceToString() {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            sb.append(s.toString());
            sb.append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DebugMode {
        COMMS,
        MENUS,
        INIT;

    }
}

