/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.sound;

import java.io.File;
import java.util.Arrays;

public final class Playlist {
    public static final int PLAY_ALL = 0;
    public static final int REPEAT_ALL = 1;
    public static final int PLAY_ONE = 2;
    public static final int REPEAT_ONE = 3;
    public static final int FORWARDS = 0;
    public static final int BACKWARDS = 1;
    public static final int SHUFFLE = 2;
    private final File[] soundFiles;
    private int num;
    private int repeatMode;
    private int pickMode;
    private final int[] playedSounds;

    public Playlist(File ... soundFiles) {
        if (soundFiles.length == 0) {
            throw new IllegalArgumentException("It's not possible to create an empty Playlist.");
        }
        this.soundFiles = soundFiles;
        this.repeatMode = 1;
        this.pickMode = 0;
        this.num = -1;
        this.playedSounds = null;
    }

    public Playlist(File[] soundFiles, int repeatMode, int pickMode) {
        if (soundFiles.length == 0) {
            throw new IllegalArgumentException("It's not possible to create an empty Playlist.");
        }
        this.soundFiles = soundFiles;
        this.repeatMode = repeatMode;
        this.pickMode = pickMode;
        this.num = -1;
        if (pickMode == 2) {
            this.playedSounds = new int[soundFiles.length];
            for (int i = 0; i < this.playedSounds.length; ++i) {
                this.playedSounds[i] = Integer.MAX_VALUE;
            }
        } else {
            this.playedSounds = null;
        }
    }

    public void setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
    }

    public void setPickMode(int pickMode) {
        this.pickMode = pickMode;
    }

    public File next() {
        if (this.num != -2) {
            if (this.num == -1) {
                if (this.pickMode == 0) {
                    this.num = 0;
                } else if (this.pickMode == 1) {
                    this.num = this.soundFiles.length - 1;
                } else {
                    this.playedSounds[0] = this.num = (int)(Math.random() * (double)this.soundFiles.length);
                }
            } else if (this.repeatMode == 2) {
                this.num = -2;
            } else if (this.repeatMode != 3) {
                if (this.pickMode == 2) {
                    if (this.playedSounds[this.playedSounds.length - 1] != Integer.MAX_VALUE) {
                        if (this.repeatMode == 0) {
                            this.num = -2;
                        } else {
                            for (int i = 1; i < this.playedSounds.length; ++i) {
                                this.playedSounds[i] = Integer.MAX_VALUE;
                            }
                            this.playedSounds[0] = this.num = (int)(Math.random() * (double)this.soundFiles.length);
                        }
                    } else {
                        int i;
                        for (i = 0; i < this.playedSounds.length && this.playedSounds[i] != Integer.MAX_VALUE; ++i) {
                        }
                        int tmp = (int)(Math.random() * (double)(this.soundFiles.length - i));
                        for (int j = 0; j < i; ++j) {
                            if (tmp < this.playedSounds[j]) {
                                this.num = tmp;
                                break;
                            }
                            ++tmp;
                        }
                        this.playedSounds[i] = this.num;
                        Arrays.sort(this.playedSounds);
                    }
                } else {
                    switch (this.repeatMode) {
                        case 0: {
                            if (this.pickMode == 0) {
                                ++this.num;
                                if (this.num != this.soundFiles.length) break;
                                this.num = -2;
                                break;
                            }
                            --this.num;
                            if (this.num != -1) break;
                            this.num = -2;
                            break;
                        }
                        case 1: {
                            if (this.pickMode == 0) {
                                ++this.num;
                                if (this.num != this.soundFiles.length) break;
                                this.num = 0;
                                break;
                            }
                            --this.num;
                            if (this.num != -1) break;
                            this.num = this.soundFiles.length - 1;
                        }
                    }
                }
            }
        }
        if (this.num >= 0 && this.num < this.soundFiles.length) {
            return this.soundFiles[this.num];
        }
        return null;
    }

    public boolean hasNext() {
        if (this.repeatMode == 0) {
            if (this.num == -1) {
                return true;
            }
            if (this.num == -2) {
                return false;
            }
            return !(this.pickMode == 0 && this.num == this.soundFiles.length - 1 || this.pickMode == 1 && this.num == 0) && (this.pickMode != 2 || this.playedSounds[this.playedSounds.length - 1] == Integer.MAX_VALUE);
        }
        if (this.repeatMode == 2) {
            return this.num == -1;
        }
        return true;
    }
}

