/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectDestinationDialog
extends FreeColDialog<Location>
implements ActionListener,
ChangeListener,
ItemListener {
    private static final Logger logger = Logger.getLogger(SelectDestinationDialog.class.getName());
    private static final int INFINITY = Integer.MAX_VALUE;
    private static boolean showOnlyMyColonies = true;
    private static Comparator<Destination> destinationComparator = null;
    private final JCheckBox onlyMyColoniesBox;
    private final JComboBox comparatorBox;
    private final JList destinationList;
    private final List<Destination> destinations = new ArrayList<Destination>();

    public SelectDestinationDialog(FreeColClient freeColClient, GUI gui, Unit unit) {
        super(freeColClient, gui);
        ArrayList<GoodsType> goodsTypes = new ArrayList<GoodsType>();
        for (Goods goods : unit.getGoodsList()) {
            if (goodsTypes.contains(goods.getType())) continue;
            goodsTypes.add(goods.getType());
        }
        this.destinations.clear();
        this.collectDestinations(unit, goodsTypes);
        MigLayout layout = new MigLayout("wrap 1, fill", "[align center]", "");
        this.setLayout((LayoutManager)layout);
        JLabel header = new JLabel(Messages.message("selectDestination.text"));
        header.setFont(smallHeaderFont);
        this.add(header);
        DefaultListModel model = new DefaultListModel();
        this.destinationList = new JList(model);
        this.filterDestinations();
        this.destinationList.setCellRenderer(new LocationRenderer());
        this.destinationList.setFixedCellHeight(48);
        AbstractAction selectAction = new AbstractAction(Messages.message("ok")){

            public void actionPerformed(ActionEvent e) {
                Destination d = (Destination)SelectDestinationDialog.this.destinationList.getSelectedValue();
                if (d != null) {
                    SelectDestinationDialog.this.setResponse(d.location);
                }
                SelectDestinationDialog.this.getGUI().removeFromCanvas(SelectDestinationDialog.this);
            }
        };
        AbstractAction quitAction = new AbstractAction(Messages.message("selectDestination.cancel")){

            public void actionPerformed(ActionEvent e) {
                SelectDestinationDialog.this.getGUI().removeFromCanvas(SelectDestinationDialog.this);
                SelectDestinationDialog.this.setResponse(null);
            }
        };
        this.destinationList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.destinationList.getActionMap().put("select", selectAction);
        this.destinationList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.destinationList.getActionMap().put("quit", quitAction);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Destination d = (Destination)SelectDestinationDialog.this.destinationList.getSelectedValue();
                    if (d != null) {
                        SelectDestinationDialog.this.setResponse(d.location);
                    }
                    SelectDestinationDialog.this.getGUI().removeFromCanvas(SelectDestinationDialog.this);
                }
            }
        };
        this.destinationList.addMouseListener(mouseListener);
        JScrollPane listScroller = new JScrollPane(this.destinationList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.add((Component)listScroller, "newline 30, growx, growy");
        this.onlyMyColoniesBox = new JCheckBox(Messages.message("selectDestination.onlyMyColonies"), showOnlyMyColonies);
        this.onlyMyColoniesBox.addChangeListener(this);
        this.add((Component)this.onlyMyColoniesBox, "left");
        this.comparatorBox = new JComboBox<String>(new String[]{Messages.message("selectDestination.sortByOwner"), Messages.message("selectDestination.sortByName"), Messages.message("selectDestination.sortByDistance")});
        this.comparatorBox.addItemListener(this);
        if (destinationComparator instanceof DestinationComparator) {
            this.comparatorBox.setSelectedIndex(0);
        } else if (destinationComparator instanceof NameComparator) {
            this.comparatorBox.setSelectedIndex(1);
        } else if (destinationComparator instanceof DistanceComparator) {
            this.comparatorBox.setSelectedIndex(2);
        }
        this.add((Component)this.comparatorBox, "left");
        this.cancelButton.setAction(quitAction);
        this.okButton.setAction(selectAction);
        this.add((Component)this.okButton, "newline 30, split 2, tag ok");
        this.add((Component)this.cancelButton, "tag cancel");
        this.setSize(this.getPreferredSize());
    }

    private void collectDestinations(Unit unit, List<GoodsType> goodsTypes) {
        int turns;
        Player player = unit.getOwner();
        Settlement inSettlement = unit.getSettlement();
        boolean canTrade = player.hasAbility("model.ability.tradeWithForeignColonies");
        Europe europe = player.getEurope();
        Game game = this.getGame();
        Map map = game.getMap();
        if (unit.isInEurope() && !unit.getType().canMoveToHighSeas()) {
            return;
        }
        for (Player p : game.getPlayers()) {
            if (p != player && (!p.hasContacted(player) || p.isEuropean() && !canTrade)) continue;
            for (Settlement s : p.getSettlements()) {
                if (s == inSettlement || unit.isNaval() && !s.isConnectedPort() || s instanceof IndianSettlement && !((IndianSettlement)s).hasContacted(player)) continue;
                if (p == player) {
                    turns = unit.getTurnsToReach(s);
                    if (turns == Integer.MAX_VALUE) {
                        continue;
                    }
                } else {
                    PathNode path = unit.search(unit.getLocation(), GoalDeciders.getAdjacentLocationGoalDecider(s), null, Integer.MAX_VALUE, null);
                    if (path == null) continue;
                    turns = path.getTotalTurns();
                    if (path.getLastNode().getMovesLeft() <= 0) {
                        ++turns;
                    }
                }
                this.destinations.add(new Destination(s, turns, s.getOwner() == unit.getOwner() ? "" : this.getExtras(unit, s, goodsTypes)));
            }
        }
        if (unit.isInEurope()) {
            this.destinations.add(new Destination(map, unit.getSailTurns(), ""));
        } else if (europe != null && player.canMoveToEurope() && unit.getType().canMoveToHighSeas() && (turns = unit.getTurnsToReach(europe)) != Integer.MAX_VALUE) {
            this.destinations.add(new Destination(europe, turns, this.getExtras(unit, europe, goodsTypes)));
        }
        Collections.sort(this.destinations, destinationComparator != null ? destinationComparator : new DestinationComparator(player));
    }

    @Override
    public void requestFocus() {
        this.destinationList.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        showOnlyMyColonies = this.onlyMyColoniesBox.isSelected();
        this.filterDestinations();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        switch (this.comparatorBox.getSelectedIndex()) {
            default: {
                destinationComparator = new DestinationComparator(this.getMyPlayer());
                break;
            }
            case 1: {
                destinationComparator = new NameComparator();
                break;
            }
            case 2: {
                destinationComparator = new DistanceComparator();
            }
        }
        Collections.sort(this.destinations, destinationComparator);
        this.filterDestinations();
    }

    private String getExtras(Unit unit, Location loc, List<GoodsType> goodsTypes) {
        Player owner = unit.getOwner();
        if (loc instanceof Europe && !goodsTypes.isEmpty()) {
            Market market = owner.getMarket();
            ArrayList<String> sales = new ArrayList<String>();
            for (GoodsType goodsType : goodsTypes) {
                sales.add(Messages.message(goodsType.getNameKey()) + " " + Integer.toString(market.getSalePrice(goodsType, 1)));
            }
            if (!sales.isEmpty()) {
                return "[" + Utils.join(", ", sales) + "]";
            }
        } else {
            IndianSettlement indianSettlement;
            UnitType skill;
            if (loc instanceof Settlement && ((Settlement)loc).getOwner().atWarWith(owner)) {
                return "[" + Messages.message("model.stance.war") + "]";
            }
            if (loc instanceof Settlement && !goodsTypes.isEmpty()) {
                ArrayList<String> sales = new ArrayList<String>();
                for (GoodsType goodsType : goodsTypes) {
                    String sale = owner.getLastSaleString((Settlement)loc, goodsType);
                    if (sale == null) continue;
                    sales.add(Messages.message(goodsType.getNameKey()) + " " + sale);
                }
                if (!sales.isEmpty()) {
                    return "[" + Utils.join(", ", sales) + "]";
                }
            } else if (loc instanceof IndianSettlement && (skill = (indianSettlement = (IndianSettlement)loc).getLearnableSkill()) != null && unit.getType().canBeUpgraded(skill, UnitTypeChange.ChangeType.NATIVES)) {
                return "[" + Messages.message(skill.getNameKey()) + "]";
            }
        }
        return "";
    }

    private void filterDestinations() {
        DefaultListModel model = (DefaultListModel)this.destinationList.getModel();
        Object selected = this.destinationList.getSelectedValue();
        model.clear();
        for (Destination d : this.destinations) {
            if (showOnlyMyColonies) {
                if (!(d.location instanceof Europe) && !(d.location instanceof Map) && (!(d.location instanceof Colony) || ((Colony)d.location).getOwner() != this.getMyPlayer())) continue;
                model.addElement(d);
                continue;
            }
            model.addElement(d);
        }
        this.destinationList.setSelectedValue(selected, true);
        if (this.destinationList.getSelectedIndex() == -1) {
            this.destinationList.setSelectedIndex(0);
        }
    }

    public int compareNames(Location dest1, Location dest2) {
        Player player = this.getMyPlayer();
        String name1 = "";
        if (dest1 instanceof Settlement) {
            name1 = Messages.message(((Settlement)dest1).getLocationNameFor(player));
        } else if (dest1 instanceof Europe || dest1 instanceof Map) {
            return -1;
        }
        String name2 = "";
        if (dest2 instanceof Settlement) {
            name2 = Messages.message(((Settlement)dest2).getLocationNameFor(player));
        } else if (dest2 instanceof Europe || dest2 instanceof Map) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DistanceComparator
    implements Comparator<Destination> {
        private DistanceComparator() {
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            int result = choice1.turns - choice2.turns;
            if (result == 0) {
                return SelectDestinationDialog.this.compareNames(choice1.location, choice2.location);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<Destination> {
        private NameComparator() {
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            return SelectDestinationDialog.this.compareNames(choice1.location, choice2.location);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DestinationComparator
    implements Comparator<Destination> {
        private Player owner;

        public DestinationComparator(Player player) {
            this.owner = player;
        }

        @Override
        public int compare(Destination choice1, Destination choice2) {
            Location dest1 = choice1.location;
            Location dest2 = choice2.location;
            int score1 = 100;
            if (dest1 instanceof Europe || dest1 instanceof Map) {
                score1 = 10;
            } else if (dest1 instanceof Colony) {
                score1 = ((Colony)dest1).getOwner() == this.owner ? 20 : 30;
            } else if (dest1 instanceof IndianSettlement) {
                score1 = 40;
            }
            int score2 = 100;
            if (dest2 instanceof Europe || dest2 instanceof Map) {
                score2 = 10;
            } else if (dest2 instanceof Colony) {
                score2 = ((Colony)dest2).getOwner() == this.owner ? 20 : 30;
            } else if (dest2 instanceof IndianSettlement) {
                score2 = 40;
            }
            if (score1 == score2) {
                return SelectDestinationDialog.this.compareNames(dest1, dest2);
            }
            return score1 - score2;
        }
    }

    private class LocationRenderer
    extends FreeColComboBoxRenderer {
        private LocationRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            Destination d = (Destination)value;
            Location location = d.location;
            Player player = SelectDestinationDialog.this.getMyPlayer();
            String name = "";
            ImageLibrary lib = SelectDestinationDialog.this.getLibrary();
            if (location instanceof Europe) {
                Europe europe = (Europe)location;
                name = Messages.message(europe.getNameKey());
                label.setIcon(new ImageIcon(lib.getCoatOfArmsImage(europe.getOwner().getNation()).getScaledInstance(-1, 48, 4)));
            } else if (location instanceof Map) {
                name = Messages.message(location.getLocationNameFor(player));
                label.setIcon(lib.getMiscImageIcon("lostCityRumour.image"));
            } else if (location instanceof Settlement) {
                Settlement settlement = (Settlement)location;
                name = Messages.message(settlement.getLocationNameFor(player));
                label.setIcon(new ImageIcon(lib.getSettlementImage(settlement).getScaledInstance(64, -1, 4)));
            }
            label.setText(Messages.message(StringTemplate.template("selectDestination.destinationTurns").addName("%location%", name).addAmount("%turns%", d.turns).addName("%extras%", d.extras)));
        }
    }

    private class Destination {
        public Location location;
        public int turns;
        public String extras;

        public Destination(Location location, int turns, String extras) {
            this.location = location;
            this.turns = turns;
            this.extras = extras;
        }
    }
}

