/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RiverStylePanel
extends FreeColDialog<String> {
    private static final Logger logger = Logger.getLogger(RiverStylePanel.class.getName());
    public static final String CANCEL = "CANCEL";
    public static final String DELETE = "DELETE";
    private static final String PREFIX = "model.tile.river";

    public RiverStylePanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        this.setLayout(new BorderLayout());
        JPanel stylesPanel = new JPanel(new GridLayout(9, 9));
        JButton deleteButton = new JButton(new ImageIcon(this.getLibrary().getMiscImage("delete.image", 0.5)));
        deleteButton.setActionCommand(DELETE);
        deleteButton.addActionListener(this);
        stylesPanel.add(deleteButton);
        for (String key : ResourceManager.getKeys(PREFIX)) {
            JButton riverButton = new JButton(new ImageIcon(ResourceManager.getImage(key, 0.5)));
            riverButton.setActionCommand(key);
            riverButton.addActionListener(this);
            stylesPanel.add(riverButton);
        }
        this.add((Component)stylesPanel, "Center");
        JButton cancelButton = new JButton(Messages.message("cancel"));
        cancelButton.setActionCommand(CANCEL);
        cancelButton.addActionListener(this);
        cancelButton.setMnemonic('C');
        this.add((Component)cancelButton, "South");
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String style = event.getActionCommand();
        if (style.startsWith(PREFIX)) {
            style = style.substring(PREFIX.length());
        }
        this.setResponse(style);
    }
}

