/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportLabourDetailPanel
extends ReportPanel
implements ActionListener {
    private Map<UnitType, Map<Location, Integer>> data;
    private TypeCountMap<UnitType> unitCount;
    private List<Colony> colonies;
    private UnitType unitType;

    public ReportLabourDetailPanel(FreeColClient freeColClient, GUI gui, UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        super(freeColClient, gui, Messages.message("report.labour.details"));
        this.unitType = unitType;
        this.data = data;
        this.unitCount = unitCount;
        this.colonies = colonies;
    }

    @Override
    public void initialize() {
        JLabel countLabel;
        JPanel detailPanel = new JPanel((LayoutManager)new MigLayout("wrap 7", "[]30[][]30[][]30[][]", ""));
        detailPanel.setOpaque(false);
        Unit.Role role = Unit.Role.DEFAULT;
        if (this.unitType.hasAbility("model.ability.expertPioneer")) {
            role = Unit.Role.PIONEER;
        } else if (this.unitType.hasAbility("model.ability.expertMissionary")) {
            role = Unit.Role.MISSIONARY;
        }
        detailPanel.add((Component)new JLabel(this.getLibrary().getUnitImageIcon(this.unitType, role)), "spany");
        detailPanel.add(this.localizedLabel(this.unitType.getNameKey()));
        detailPanel.add((Component)new JLabel(String.valueOf(this.unitCount.getCount(this.unitType))), "wrap 10");
        boolean canTrain = false;
        Map<Location, Integer> unitLocations = this.data.get(this.unitType);
        for (Colony colony : this.colonies) {
            if (unitLocations.get(colony) == null) continue;
            String colonyName = colony.getName();
            if (colony.canTrain(this.unitType)) {
                canTrain = true;
                colonyName = colonyName + "*";
            }
            JButton colonyButton = ReportLabourDetailPanel.getLinkButton(colonyName, null, colony.getId());
            colonyButton.addActionListener(this);
            detailPanel.add(colonyButton);
            countLabel = new JLabel(unitLocations.get(colony).toString());
            countLabel.setForeground(LINK_COLOR);
            detailPanel.add(countLabel);
        }
        for (Map.Entry entry : unitLocations.entrySet()) {
            if (entry.getKey() instanceof Colony) continue;
            String locationName = Messages.message(((Location)entry.getKey()).getLocationName());
            JButton linkButton = ReportLabourDetailPanel.getLinkButton(locationName, null, ((Location)entry.getKey()).getId());
            linkButton.addActionListener(this);
            detailPanel.add(linkButton);
            countLabel = new JLabel(((Integer)entry.getValue()).toString());
            countLabel.setForeground(LINK_COLOR);
            detailPanel.add(countLabel);
        }
        if (canTrain) {
            detailPanel.add((Component)new JLabel(Messages.message("report.labour.canTrain")), "newline 20, span");
        }
        this.reportPanel.add(detailPanel);
    }
}

