/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportIndianPanel
extends ReportPanel {
    private static final String[] headlines = new String[]{"Settlement", "mission", "report.indian.tension", "report.indian.skillTaught", "report.indian.mostHated", "report.indian.tradeInterests"};

    public ReportIndianPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportIndianAction.name"));
        Player player = this.getMyPlayer();
        this.reportPanel.setLayout((LayoutManager)new MigLayout("wrap 6, fillx, insets 0", "[]20px[center]", "[top]"));
        boolean needsSeperator = false;
        for (Player opponent : this.getGame().getPlayers()) {
            if (!opponent.isIndian() || opponent.isDead() || !player.hasContacted(opponent)) continue;
            if (needsSeperator) {
                this.reportPanel.add((Component)new JSeparator(0), "newline 20, span, growx, wrap 20");
            }
            this.buildIndianAdvisorPanel(player, opponent);
            needsSeperator = true;
        }
        this.scrollPane.getViewport().setOpaque(false);
        this.reportPanel.setOpaque(true);
        this.reportPanel.doLayout();
    }

    private void buildIndianAdvisorPanel(Player player, Player opponent) {
        NationSummary ns = this.getController().getNationSummary(opponent);
        List<IndianSettlement> nativeSettlements = opponent.getIndianSettlements();
        String numSettlements = "" + nativeSettlements.size() + " / " + ns.getNumberOfSettlements();
        JLabel villageLabel = new JLabel();
        villageLabel.setIcon(new ImageIcon(this.getLibrary().getSettlementImage(opponent.getNationType().getCapitalType(), 0.66)));
        this.reportPanel.add((Component)villageLabel, "span, split 2");
        JLabel headline = this.localizedLabel(opponent.getNationName());
        headline.setFont(smallHeaderFont);
        this.reportPanel.add((Component)headline, "wrap 20");
        JLabel label = this.localizedLabel("report.indian.chieftain");
        label.setFont(boldFont);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)new JLabel(Messages.message(opponent.getName())), "left, wrap");
        label = this.localizedLabel("report.indian.typeOfSettlements");
        label.setFont(boldFont);
        this.reportPanel.add(label);
        this.reportPanel.add((Component)this.localizedLabel(opponent.getNationType().getCapitalType().getId() + ".name"), "left, wrap");
        label = this.localizedLabel("report.indian.numberOfSettlements");
        this.reportPanel.add(label);
        label.setFont(boldFont);
        this.reportPanel.add((Component)new JLabel(numSettlements), "left, wrap");
        label = this.localizedLabel("report.indian.tribeTension");
        this.reportPanel.add(label);
        label.setFont(boldFont);
        this.reportPanel.add((Component)new JLabel(Messages.message(opponent.getTension(player).getKey()) + "/" + Messages.message(opponent.getStance(player).getKey())), "left, wrap 20");
        if (!nativeSettlements.isEmpty()) {
            for (String key : headlines) {
                JLabel head = this.localizedLabel(key);
                head.setFont(boldFont);
                this.reportPanel.add(head);
            }
            ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>(nativeSettlements.size());
            for (IndianSettlement settlement : nativeSettlements) {
                if (settlement.isCapital()) {
                    settlements.add(0, settlement);
                    continue;
                }
                settlements.add(settlement);
            }
            for (IndianSettlement settlement : settlements) {
                String skillString;
                boolean known = settlement.getTile().isExplored();
                boolean contacted = settlement.hasContacted(player);
                boolean visited = settlement.hasVisited(player);
                String locationName = Messages.message(settlement.getLocationNameFor(player));
                if (known && settlement.isCapital()) {
                    locationName = locationName + "*";
                }
                JButton settlementButton = ReportIndianPanel.getLinkButton(locationName, null, settlement.getTile().getId());
                settlementButton.addActionListener(this);
                this.reportPanel.add((Component)settlementButton, "newline 15");
                JLabel missionLabel = new JLabel();
                Unit missionary = settlement.getMissionary();
                if (missionary == null) {
                    missionLabel.setText("");
                } else {
                    missionLabel.setIcon(new ImageIcon(this.getLibrary().getMissionChip(settlement)));
                    String text = Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", missionary.getOwner().getNationName()).addStringTemplate("%unit%", Messages.getLabel(missionary)));
                    missionLabel.setToolTipText(text);
                }
                this.reportPanel.add(missionLabel);
                String messageId = settlement.getShortAlarmLevelMessageId(player);
                this.reportPanel.add(this.localizedLabel(messageId));
                JLabel skillLabel = new JLabel();
                skillLabel.setVerticalTextPosition(1);
                skillLabel.setHorizontalTextPosition(0);
                UnitType skillType = settlement.getLearnableSkill();
                if (visited) {
                    if (skillType == null) {
                        skillString = "indianSettlement.skillNone";
                    } else {
                        skillString = skillType.getNameKey();
                        ImageIcon skillImage = this.getLibrary().getUnitImageIcon(skillType, 0.66);
                        skillLabel.setIcon(skillImage);
                    }
                } else {
                    skillString = "indianSettlement.skillUnknown";
                }
                skillLabel.setText(Messages.message(skillString));
                this.reportPanel.add(skillLabel);
                Player mostHated = settlement.getMostHated();
                JLabel mostHatedLabel = contacted ? (mostHated == null ? this.localizedLabel("indianSettlement.mostHatedNone") : this.localizedLabel(mostHated.getNationName())) : this.localizedLabel("indianSettlement.mostHatedUnknown");
                this.reportPanel.add(mostHatedLabel);
                GoodsType[] wantedGoods = settlement.getWantedGoods();
                if (contacted) {
                    if (wantedGoods[0] == null) {
                        this.reportPanel.add(this.localizedLabel("indianSettlement.wantedGoodsNone"));
                        continue;
                    }
                    JLabel goodsLabel = this.localizedLabel(wantedGoods[0].getNameKey());
                    goodsLabel.setIcon(new ImageIcon(this.getLibrary().getGoodsImage(wantedGoods[0], 0.66)));
                    String split = "flowy, split " + String.valueOf(wantedGoods.length);
                    this.reportPanel.add((Component)goodsLabel, split);
                    for (int i = 1; i < wantedGoods.length; ++i) {
                        if (wantedGoods[i] == null) continue;
                        String sale = player.getLastSaleString(settlement, wantedGoods[i]);
                        goodsLabel = new JLabel(Messages.message(wantedGoods[i].getNameKey()) + (sale == null ? "" : " " + sale));
                        goodsLabel.setIcon(this.getLibrary().getScaledGoodsImageIcon(wantedGoods[i], 0.5));
                        this.reportPanel.add(goodsLabel);
                    }
                    continue;
                }
                this.reportPanel.add(this.localizedLabel("indianSettlement.wantedGoodsUnknown"));
            }
        } else {
            this.reportPanel.add(this.localizedLabel("report.indian.noKnownSettlements"));
        }
    }
}

