/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportColonyPanel
extends ReportPanel
implements ActionListener {
    private static final Comparator<GoodsType> goodsComparator = new Comparator<GoodsType>(){

        private int rank(GoodsType g) {
            return !g.isStorable() || g.isTradeGoods() ? -1 : (g.isFoodType() ? 1 : (g.isNewWorldGoodsType() ? 2 : (g.isFarmed() ? 3 : (g.isRawMaterial() ? 4 : (g.isNewWorldLuxuryType() ? 5 : (g.isRefined() ? 6 : -1))))));
        }

        @Override
        public int compare(GoodsType g1, GoodsType g2) {
            int r2;
            int r1 = this.rank(g1);
            return r1 != (r2 = this.rank(g2)) ? r1 - r2 : g1.getNameKey().compareTo(g2.getNameKey());
        }
    };
    private static final Comparator<AbstractGoods> abstractGoodsComparator = new Comparator<AbstractGoods>(){

        @Override
        public int compare(AbstractGoods a1, AbstractGoods a2) {
            int cmp = a2.getAmount() - a1.getAmount();
            return cmp != 0 ? cmp : goodsComparator.compare(a2.getType(), a1.getType());
        }
    };
    private static final Comparator<Unit> teacherComparator = new Comparator<Unit>(){

        @Override
        public int compare(Unit u1, Unit u2) {
            int l2;
            int l1 = u1.getNeededTurnsOfTraining() - u1.getTurnsOfTraining();
            int cmp = l1 - (l2 = u2.getNeededTurnsOfTraining() - u2.getTurnsOfTraining());
            return cmp != 0 ? cmp : u2.getType().getId().compareTo(u1.getType().getId());
        }
    };
    private static final String BUILDQUEUE = "buildQueue.";
    private boolean useCompact = false;
    private List<Colony> colonies = this.getSortedColonies();
    private List<GoodsType> goodsTypes;
    private Color cAlarm;
    private Color cWarn;
    private Color cPlain;
    private Color cExport;
    private Color cGood;

    public ReportColonyPanel(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, Messages.message("reportColonyAction.name"));
        try {
            this.useCompact = this.getClientOptions().getInteger("model.option.colonyReport") == 1;
        }
        catch (Exception e) {
            this.useCompact = false;
        }
        if (this.useCompact) {
            this.initializeCompactColonyPanel();
            this.updateCompactColonyPanel();
        } else {
            this.classicColonyPanel(this.colonies);
        }
    }

    private void classicColonyPanel(List<Colony> colonies) {
        int COLONISTS_PER_ROW = 20;
        int UNITS_PER_ROW = 14;
        int GOODS_PER_ROW = 10;
        int BUILDINGS_PER_ROW = 8;
        this.reportPanel.setLayout((LayoutManager)new MigLayout("fill"));
        for (Colony colony : colonies) {
            JButton button = ReportColonyPanel.getLinkButton(colony.getName(), null, colony.getId());
            button.addActionListener(this);
            this.reportPanel.add((Component)button, "newline 20, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            BuildableType currentType = colony.getCurrentlyBuilding();
            JLabel buildableLabel = null;
            if (currentType != null) {
                buildableLabel = new JLabel(new ImageIcon(ResourceManager.getImage(currentType.getId() + ".image", 0.66)));
                buildableLabel.setToolTipText(Messages.message(StringTemplate.template("colonyPanel.currentlyBuilding").add("%buildable%", currentType.getNameKey())));
                buildableLabel.setIcon(buildableLabel.getDisabledIcon());
            }
            JPanel colonistsPanel = new JPanel(new GridLayout(0, 20));
            colonistsPanel.setOpaque(false);
            List<Unit> unitList = colony.getUnitList();
            Collections.sort(unitList, ReportColonyPanel.getUnitTypeComparator());
            for (Unit unit : unitList) {
                UnitLabel unitLabel = new UnitLabel(this.getFreeColClient(), unit, this.getGUI(), true, true);
                colonistsPanel.add(unitLabel);
            }
            JPanel unitsPanel = new JPanel(new GridLayout(0, 14));
            unitsPanel.setOpaque(false);
            unitList = colony.getTile().getUnitList();
            Collections.sort(unitList, ReportColonyPanel.getUnitTypeComparator());
            for (Unit unit : unitList) {
                UnitLabel unitLabel = new UnitLabel(this.getFreeColClient(), unit, this.getGUI(), true, true);
                unitsPanel.add(unitLabel);
            }
            if (buildableLabel != null && currentType.getSpecification().getUnitTypeList().contains(currentType)) {
                unitsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)colonistsPanel, "newline, growx");
            this.reportPanel.add((Component)unitsPanel, "newline, growx");
            GoodsType horses = this.getSpecification().getGoodsType("model.goods.horses");
            int count = 0;
            for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
                int newValue = colony.getNetProductionOf(goodsType);
                int stockValue = colony.getGoodsCount(goodsType);
                if (newValue == 0 && stockValue <= 0) continue;
                int maxProduction = 0;
                for (Building building : colony.getBuildingsForProducing(goodsType)) {
                    maxProduction += building.getMaximumProductionOf(goodsType);
                }
                ProductionLabel productionLabel = new ProductionLabel(this.getFreeColClient(), this.getGUI(), goodsType, newValue);
                if (maxProduction > 0) {
                    productionLabel.setMaximumProduction(maxProduction);
                }
                if (goodsType == horses) {
                    productionLabel.setMaxGoodsIcons(1);
                }
                productionLabel.setStockNumber(stockValue);
                if (count % 10 == 0) {
                    this.reportPanel.add((Component)productionLabel, "newline, split 10");
                } else {
                    this.reportPanel.add(productionLabel);
                }
                ++count;
            }
            JPanel buildingsPanel = new JPanel(new GridLayout(0, 8));
            buildingsPanel.setOpaque(false);
            List<Building> buildingList = colony.getBuildings();
            Collections.sort(buildingList);
            for (Building building : buildingList) {
                if (building.getType().isAutomaticBuild()) continue;
                JLabel buildingLabel = new JLabel(new ImageIcon(ResourceManager.getImage(building.getType().getId() + ".image", 0.66)));
                buildingLabel.setToolTipText(Messages.message(building.getNameKey()));
                buildingsPanel.add(buildingLabel);
            }
            if (buildableLabel != null && currentType.getSpecification().getBuildingTypeList().contains(currentType)) {
                buildingsPanel.add(buildableLabel);
            }
            this.reportPanel.add((Component)buildingsPanel, "newline, growx");
        }
    }

    private void initializeCompactColonyPanel() {
        Specification spec = this.getSpecification();
        this.goodsTypes = new ArrayList<GoodsType>(spec.getGoodsTypeList());
        Collections.sort(this.goodsTypes, goodsComparator);
        while (!this.goodsTypes.get(0).isStorable() || this.goodsTypes.get(0).isTradeGoods()) {
            this.goodsTypes.remove(0);
        }
        String cols = "[l][c][c][c]";
        for (int i = 0; i < this.goodsTypes.size(); ++i) {
            cols = cols + "[c]";
        }
        cols = cols + "[c][c][l][l][l]";
        this.reportPanel.setLayout((LayoutManager)new MigLayout("fillx, insets 0, gap 0 0", cols, ""));
        this.cAlarm = ResourceManager.getColor("report.colony.alarmColor");
        this.cWarn = ResourceManager.getColor("report.colony.warningColor");
        this.cPlain = ResourceManager.getColor("report.colony.plainColor");
        this.cExport = ResourceManager.getColor("report.colony.exportColor");
        this.cGood = ResourceManager.getColor("report.colony.goodColor");
        if (this.cAlarm == null) {
            this.cAlarm = Color.RED;
        }
        if (this.cWarn == null) {
            this.cWarn = Color.MAGENTA;
        }
        if (this.cPlain == null) {
            this.cPlain = Color.DARK_GRAY;
        }
        if (this.cExport == null) {
            this.cExport = Color.GREEN;
        }
        if (this.cGood == null) {
            this.cGood = Color.BLUE;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.useCompact) {
            String command = event.getActionCommand();
            if (command.startsWith(BUILDQUEUE)) {
                command = command.substring(BUILDQUEUE.length());
                Colony colony = this.getGame().getFreeColGameObject(command, Colony.class);
                if (colony != null) {
                    this.getGUI().showBuildQueuePanel(colony, new Runnable(){

                        public void run() {
                            ReportColonyPanel.this.updateCompactColonyPanel();
                        }
                    });
                    return;
                }
            } else {
                Colony colony = this.getGame().getFreeColGameObject(command, Colony.class);
                if (colony != null) {
                    this.getGUI().showColonyPanel(colony, new Runnable(){

                        public void run() {
                            ReportColonyPanel.this.updateCompactColonyPanel();
                        }
                    });
                    return;
                }
            }
        }
        super.actionPerformed(event);
    }

    private void updateCompactColonyPanel() {
        this.reportPanel.removeAll();
        Market market = this.getMyPlayer().getMarket();
        this.conciseHeaders(this.goodsTypes, true, market);
        for (Colony colony : this.colonies) {
            if (colony.getUnitCount() <= 0) continue;
            this.updateColony(colony);
        }
        this.conciseHeaders(this.goodsTypes, false, market);
    }

    private void updateColony(Colony colony) {
        int newColonist;
        boolean famine;
        boolean plowMe;
        Specification spec = this.getSpecification();
        GoodsType foodType = spec.getPrimaryFoodType();
        UnitType colonistType = spec.getDefaultUnitType();
        ImageLibrary lib = this.getGUI().getImageLibrary();
        String cac = colony.getId();
        ArrayList<Tile> exploreTiles = new ArrayList<Tile>();
        ArrayList<Tile> clearTiles = new ArrayList<Tile>();
        ArrayList<Tile> plowTiles = new ArrayList<Tile>();
        ArrayList<Tile> roadTiles = new ArrayList<Tile>();
        colony.getColonyTileTodo(exploreTiles, clearTiles, plowTiles, roadTiles);
        boolean bl = plowMe = plowTiles.size() > 0 && plowTiles.get(0) == colony.getTile();
        if (colony.getGoodsCount(foodType) > 200) {
            famine = false;
            newColonist = 1;
        } else {
            int newFood = colony.getAdjustedNetProductionOf(foodType);
            boolean bl2 = famine = newFood < 0 && colony.getGoodsCount(foodType) / -newFood <= 3;
            newColonist = newFood == 0 ? 0 : (newFood < 0 ? colony.getGoodsCount(foodType) / newFood - 1 : (200 - colony.getGoodsCount(foodType)) / newFood + 1);
        }
        int grow = colony.getPreferredSizeChange();
        int bonus = colony.getProductionBonus();
        JButton b = this.colourButton(cac, colony.getName(), null, bonus <= -2 ? this.cAlarm : (bonus == -1 ? this.cWarn : (bonus == 0 ? this.cPlain : (bonus == 1 ? this.cExport : this.cGood))), null);
        if (famine) {
            b.setFont(b.getFont().deriveFont(1));
        }
        this.reportPanel.add((Component)b, "newline");
        if (grow < 0) {
            b = this.colourButton(cac, Integer.toString(-grow), null, this.cAlarm, this.stpl("report.colony.shrinking.description").addName("%colony%", colony.getName()).addAmount("%amount%", -grow));
            this.reportPanel.add(b);
        } else if (grow > 0) {
            b = this.colourButton(cac, Integer.toString(grow), null, this.cGood, this.stpl("report.colony.growing.description").addName("%colony%", colony.getName()).addAmount("%amount%", grow));
            this.reportPanel.add(b);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        if (exploreTiles.size() > 0) {
            b = this.colourButton(cac, Integer.toString(exploreTiles.size()), null, this.cAlarm, this.stpl("report.colony.exploring.description").addName("%colony%", colony.getName()).addAmount("%amount%", exploreTiles.size()));
            this.reportPanel.add(b);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        if (plowTiles.size() > 0) {
            b = this.colourButton(cac, Integer.toString(plowTiles.size()), null, this.cAlarm, this.stpl("report.colony.plowing.description").addName("%colony%", colony.getName()).addAmount("%amount%", plowTiles.size()));
            if (plowMe) {
                b.setFont(b.getFont().deriveFont(1));
            }
            this.reportPanel.add(b);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        if (roadTiles.size() > 0) {
            b = this.colourButton(cac, Integer.toString(roadTiles.size()), null, this.cAlarm, this.stpl("report.colony.roadBuilding.description").addName("%colony%", colony.getName()).addAmount("%amount%", roadTiles.size()));
            this.reportPanel.add(b);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        int adjustment = colony.getWarehouseCapacity() / 100;
        for (GoodsType g : this.goodsTypes) {
            StringTemplate tip;
            Color c;
            int turns;
            int p = colony.getAdjustedNetProductionOf(g);
            ExportData exportData = colony.getExportData(g);
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = colony.getGoodsCount(g);
            if (p < 0) {
                if (amount < low) {
                    turns = -amount / p + 1;
                    c = this.cAlarm;
                    tip = this.stpl("report.colony.production.low.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p).addAmount("%turns%", turns);
                } else {
                    c = this.cWarn;
                    tip = this.stpl("report.colony.production.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p);
                }
            } else if (p == 0) {
                if (colony.getTotalProductionOf(g) == 0) {
                    c = null;
                    tip = null;
                } else {
                    c = this.cPlain;
                    tip = this.stpl("report.colony.production.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p);
                }
            } else if (exportData.isExported()) {
                c = this.cExport;
                tip = this.stpl("report.colony.production.export.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p).addAmount("%export%", exportData.getExportLevel());
            } else if (g != foodType && amount + p > colony.getWarehouseCapacity()) {
                c = this.cAlarm;
                int waste = amount + p - colony.getWarehouseCapacity();
                tip = this.stpl("report.colony.production.waste.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p).addAmount("%waste%", waste);
            } else if (g != foodType && amount > high) {
                turns = (colony.getWarehouseCapacity() - amount) / p;
                c = this.cWarn;
                tip = this.stpl("report.colony.production.high.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p).addAmount("%turns%", turns);
            } else {
                c = this.cGood;
                tip = this.stpl("report.colony.production.description").addName("%colony%", colony.getName()).add("%goods%", g.getNameKey()).addAmount("%amount%", p);
            }
            if (c == null) {
                this.reportPanel.add(new JLabel(""));
                continue;
            }
            b = this.colourButton(cac, Integer.toString(p), null, c, tip);
            this.reportPanel.add(b);
        }
        HashMap<UnitType, Suggestion> improve = new HashMap<UnitType, Suggestion>();
        HashMap<UnitType, Suggestion> want = new HashMap<UnitType, Suggestion>();
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        ArrayList<Unit> notWorking = new ArrayList<Unit>();
        for (Unit u : colony.getTile().getUnitList()) {
            if (u.getState() == Unit.UnitState.FORTIFIED || u.getState() == Unit.UnitState.SENTRY) continue;
            notWorking.add(u);
        }
        for (WorkLocation wl : colony.getAvailableWorkLocations()) {
            int delta;
            UnitType expert;
            GoodsType work;
            if (!wl.canBeWorked()) continue;
            if (wl.canTeach()) {
                teachers.addAll(wl.getUnitList());
                continue;
            }
            boolean needsWorker = !wl.isFull();
            for (Unit u : wl.getUnitList()) {
                if (u.getTeacher() != null) continue;
                work = u.getWorkType();
                if (work == null) {
                    notWorking.add(u);
                    needsWorker = true;
                    continue;
                }
                expert = spec.getExpertForProducing(work);
                if (expert == null || expert == u.getType() || (delta = wl.getPotentialProduction(work, expert) - wl.getPotentialProduction(work, u.getType())) <= 0 || !this.wantGoods(wl, work, u, expert)) continue;
                this.addSuggestion(improve, u.getType(), expert, work, delta);
            }
            if (!needsWorker || (work = this.bestProduction(wl, colonistType)) == null || (expert = spec.getExpertForProducing(work)) == null || (delta = wl.getPotentialProduction(work, expert)) <= 0 || !this.wantGoods(wl, work, null, expert)) continue;
            this.addSuggestion(want, null, expert, work, delta);
        }
        ArrayList<UnitType> couldWork = new ArrayList<UnitType>();
        for (Unit u : notWorking) {
            GoodsType t = u.getWorkType();
            WorkLocation wl = u.getLocation() instanceof WorkLocation ? (WorkLocation)u.getLocation() : null;
            GoodsType w = this.bestProduction(wl, colonistType);
            if (w != null && w == t) continue;
            couldWork.add(u.getType());
        }
        if (newColonist > 0) {
            b = this.colourButton(cac, Integer.toString(newColonist), null, this.cGood, this.stpl("report.colony.arriving.description").addName("%colony%", colony.getName()).add("%unit%", colonistType.getNameKey()).addAmount("%turns%", newColonist));
            this.reportPanel.add(b);
        } else if (newColonist < 0) {
            b = this.colourButton(cac, Integer.toString(-newColonist), null, newColonist >= -3 ? this.cAlarm : this.cWarn, this.stpl("report.colony.starving.description").addName("%colony%", colony.getName()).addAmount("%turns%", -newColonist));
            this.reportPanel.add(b);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        BuildableType build = colony.getCurrentlyBuilding();
        int fields = 1 + teachers.size();
        String layout = fields > 1 ? "split " + fields : null;
        String qac = BUILDQUEUE + colony.getId();
        if (build == null) {
            b = this.colourButton(qac, Messages.message("nothing"), null, this.cAlarm, this.stpl("report.colony.making.noconstruction.description").addName("%colony%", colony.getName()));
            b.setFont(b.getFont().deriveFont(1));
        } else {
            AbstractGoods needed = new AbstractGoods();
            int turns = colony.getTurnsToComplete(build, needed);
            String name = Messages.message(build.getNameKey());
            if (turns == Integer.MIN_VALUE) {
                b = this.colourButton(qac, name, null, this.cAlarm, this.stpl("report.colony.making.noconstruction.description").addName("%colony%", colony.getName()));
            } else if (turns >= 0) {
                name = name + " " + Integer.toString(turns);
                b = this.colourButton(qac, name, null, this.cGood, this.stpl("report.colony.making.constructing.description").addName("%colony%", colony.getName()).add("%buildable%", build.getNameKey()).addAmount("%turns%", turns));
            } else if (turns < 0) {
                GoodsType goodsType = needed.getType();
                int goodsAmount = needed.getAmount() - colony.getGoodsCount(goodsType);
                turns = -turns;
                name = name + " " + Integer.toString(turns);
                b = this.colourButton(qac, name, null, this.cAlarm, this.stpl("report.colony.making.blocking.description").addName("%colony%", colony.getName()).addAmount("%amount%", goodsAmount).add("%goods%", goodsType.getNameKey()).add("%buildable%", build.getNameKey()).addAmount("%turns%", turns));
            }
        }
        this.reportPanel.add((Component)b, layout);
        layout = null;
        Collections.sort(teachers, teacherComparator);
        for (Unit u : teachers) {
            int left = u.getNeededTurnsOfTraining() - u.getTurnsOfTraining();
            b = left <= 0 ? this.colourButton(cac, Integer.toString(0), lib.getUnitImageIcon(u.getType(), Unit.Role.DEFAULT, true, 0.333), this.cAlarm, this.stpl("report.colony.making.noteach.description").addName("%colony%", colony.getName()).addStringTemplate("%teacher%", u.getLabel())) : this.colourButton(cac, Integer.toString(left), lib.getUnitImageIcon(u.getType(), Unit.Role.DEFAULT, true, 0.333), Color.BLACK, this.stpl("report.colony.making.educating.description").addName("%colony%", colony.getName()).addStringTemplate("%teacher%", u.getLabel()).addAmount("%turns%", left));
            this.reportPanel.add(b);
        }
        if (fields <= 0) {
            this.reportPanel.add(new JLabel(""));
        }
        if (!improve.isEmpty()) {
            this.addUnits(improve, couldWork, colony, grow);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
        if (!want.isEmpty()) {
            grow = Math.min(grow, colony.getNetProductionOf(foodType) / 200);
            this.addUnits(want, couldWork, colony, grow);
        } else {
            this.reportPanel.add(new JLabel(""));
        }
    }

    private StringTemplate stpl(String messageId) {
        return StringTemplate.template(messageId);
    }

    private void conciseHeaders(List<GoodsType> goodsTypes, boolean top, Market market) {
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
        this.reportPanel.add((Component)this.newLabel("report.colony.name.header", null, null, this.stpl("report.colony.name.description")), "newline");
        this.reportPanel.add(this.newLabel("report.colony.grow.header", null, null, this.stpl("report.colony.grow.description")));
        this.reportPanel.add(this.newLabel("report.colony.explore.header", null, null, this.stpl("report.colony.explore.description")));
        this.reportPanel.add(this.newLabel("report.colony.plow.header", null, null, this.stpl("report.colony.plow.description")));
        this.reportPanel.add(this.newLabel("report.colony.road.header", null, null, this.stpl("report.colony.road.description")));
        for (GoodsType g : goodsTypes) {
            ImageIcon ii = this.getGUI().getImageLibrary().getScaledGoodsImageIcon(g, 0.667);
            JLabel l = this.newLabel(null, ii, null, this.stpl("report.colony.production.header").add("%goods%", g.getNameKey()));
            l.setEnabled(market == null || market.getArrears(g) <= 0);
            this.reportPanel.add(l);
        }
        UnitType colonistType = this.getSpecification().getDefaultUnitType();
        ImageIcon colonistIcon = this.getGUI().getImageLibrary().getUnitImageIcon(colonistType, Unit.Role.DEFAULT, true, 0.333);
        this.reportPanel.add(this.newLabel(null, colonistIcon, null, this.stpl("report.colony.birth.description")));
        this.reportPanel.add(this.newLabel("report.colony.making.header", null, null, this.stpl("report.colony.making.description")));
        this.reportPanel.add(this.newLabel("report.colony.improve.header", null, null, this.stpl("report.colony.improve.description")));
        this.reportPanel.add(this.newLabel("report.colony.wanted.header", null, null, this.stpl("report.colony.wanted.description")));
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
    }

    private JLabel newLabel(String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null) {
            h = Messages.message(h);
        }
        JLabel l = new JLabel(h, i, 0);
        l.setForeground(c == null ? Color.BLACK : c);
        if (t != null) {
            l.setToolTipText(Messages.message(t));
        }
        return l;
    }

    private JButton colourButton(String action, String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null && Messages.containsKey(h)) {
            h = Messages.message(h);
        }
        JButton b = ReportColonyPanel.getLinkButton(h, i, action);
        b.setForeground(c == null ? Color.BLACK : c);
        if (t != null) {
            b.setToolTipText(Messages.message(t));
        }
        b.addActionListener(this);
        return b;
    }

    private void addSuggestion(HashMap<UnitType, Suggestion> suggestions, UnitType old, UnitType expert, GoodsType work, int amount) {
        Suggestion suggestion = suggestions.get(expert);
        if (suggestion == null || suggestion.amount < amount) {
            suggestions.put(expert, new Suggestion(old, expert, work, amount));
        }
    }

    private boolean wantGoods(WorkLocation wl, GoodsType goodsType, Unit unit, UnitType expert) {
        boolean ret = false;
        if (wl instanceof ColonyTile) {
            ret = true;
        } else if (wl instanceof Building) {
            Building bu = (Building)wl;
            Colony colony = wl.getColony();
            ret = bu.canAddType(expert) && (bu.getLevel() > 1 || "model.goods.hammers".equals(goodsType.getId()) && (colony.getTotalProductionOf(goodsType) == 0 || unit != null && unit.getType() != expert) || goodsType.isLibertyType() && colony.getSoL() < 100);
        }
        return ret;
    }

    private void addUnits(final HashMap<UnitType, Suggestion> suggestions, List<UnitType> have, Colony colony, int grow) {
        String action = colony.getId();
        ImageLibrary lib = this.getGUI().getImageLibrary();
        String layout = suggestions.size() <= 1 ? null : "split " + Integer.toString(suggestions.size());
        ArrayList<UnitType> types = new ArrayList<UnitType>();
        types.addAll(suggestions.keySet());
        Collections.sort(types, new Comparator<UnitType>(){

            @Override
            public int compare(UnitType t1, UnitType t2) {
                int cmp = ((Suggestion)suggestions.get((Object)t2)).amount - ((Suggestion)suggestions.get((Object)t1)).amount;
                return cmp != 0 ? cmp : t1.getId().compareTo(t2.getId());
            }
        });
        for (UnitType type : types) {
            boolean present = false;
            if (have.contains(type)) {
                have.remove(type);
                present = true;
            }
            Suggestion suggestion = suggestions.get(type);
            String label = Integer.toString(suggestion.amount);
            ImageIcon ii = lib.getUnitImageIcon(type, Unit.Role.DEFAULT, true, 0.333);
            StringTemplate tip = suggestion.oldType == null ? this.stpl("report.colony.wanting.description").addName("%colony%", colony.getName()).add("%unit%", type.getNameKey()).add("%goods%", suggestion.goodsType.getNameKey()).addAmount("%amount%", suggestion.amount) : this.stpl("report.colony.improving.description").addName("%colony%", colony.getName()).add("%oldUnit%", suggestion.oldType.getNameKey()).add("%unit%", type.getNameKey()).add("%goods%", suggestion.goodsType.getNameKey()).addAmount("%amount%", suggestion.amount);
            JButton b = this.colourButton(action, label, ii, present ? this.cGood : this.cPlain, tip);
            this.reportPanel.add((Component)b, layout);
            layout = null;
        }
    }

    private GoodsType bestProduction(WorkLocation wl, UnitType type) {
        if (wl == null) {
            return null;
        }
        if (wl instanceof Building) {
            return ((Building)wl).getGoodsOutputType();
        }
        Specification spec = this.getSpecification();
        ArrayList<AbstractGoods> prod = new ArrayList<AbstractGoods>();
        for (GoodsType g : spec.getGoodsTypeList()) {
            int amount = wl.getPotentialProduction(g, type);
            if (amount <= 0) continue;
            prod.add(new AbstractGoods(g, amount));
        }
        if (prod.isEmpty()) {
            return null;
        }
        Collections.sort(prod, abstractGoodsComparator);
        return ((AbstractGoods)prod.get(0)).getType();
    }

    private class Suggestion {
        public UnitType oldType;
        public UnitType newType;
        public GoodsType goodsType;
        public int amount;

        public Suggestion(UnitType oldType, UnitType newType, GoodsType goodsType, int amount) {
            this.oldType = oldType;
            this.newType = newType;
            this.goodsType = goodsType;
            this.amount = amount;
        }
    }
}

