/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.panel.InfoPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;

public abstract class MapControls {
    public static final int MAP_WIDTH = 220;
    public static final int MAP_HEIGHT = 128;
    public static final int GAP = 4;
    protected final FreeColClient freeColClient;
    protected final InfoPanel infoPanel;
    protected MiniMap miniMap;
    protected final UnitButton miniMapZoomOutButton;
    protected final UnitButton miniMapZoomInButton;
    protected final List<UnitButton> unitButtons;
    private GUI gui;
    public static final int CONTROLS_LAYER = JLayeredPane.MODAL_LAYER;

    public MapControls(FreeColClient freeColClient, GUI gui, boolean useSkin) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.infoPanel = new InfoPanel(freeColClient, gui, useSkin);
        this.miniMap = new MiniMap(freeColClient, gui);
        ActionManager am = freeColClient.getActionManager();
        this.unitButtons = new ArrayList<UnitButton>();
        this.unitButtons.add(new UnitButton(am, "waitAction"));
        this.unitButtons.add(new UnitButton(am, "skipUnitAction"));
        this.unitButtons.add(new UnitButton(am, "sentryAction"));
        this.unitButtons.add(new UnitButton(am, "fortifyAction"));
        for (TileImprovementType type : freeColClient.getGame().getSpecification().getTileImprovementTypeList()) {
            FreeColAction action = am.getFreeColAction(type.getShortId() + "Action");
            if (type.isNatural() || action == null || !action.hasOrderButtons()) continue;
            this.unitButtons.add(new UnitButton(am, type.getShortId() + "Action"));
        }
        this.unitButtons.add(new UnitButton(am, "buildColonyAction"));
        this.unitButtons.add(new UnitButton(am, "disbandUnitAction"));
        this.miniMapZoomOutButton = new UnitButton(am, "miniMapZoomOutAction");
        this.miniMapZoomInButton = new UnitButton(am, "miniMapZoomInAction");
        this.miniMapZoomOutButton.setFocusable(false);
        this.miniMapZoomInButton.setFocusable(false);
        this.infoPanel.setFocusable(false);
        for (UnitButton button : this.unitButtons) {
            button.setFocusable(false);
        }
    }

    public abstract void addToComponent(Canvas var1);

    public boolean canZoomInMapControls() {
        return this.miniMap != null && this.miniMap.canZoomIn();
    }

    public boolean canZoomOutMapControls() {
        return this.miniMap != null && this.miniMap.canZoomOut();
    }

    public abstract boolean isShowing();

    public abstract void removeFromComponent(Canvas var1);

    public abstract void repaint();

    public void update() {
        int viewMode = this.gui.getCurrentViewMode();
        switch (viewMode) {
            case 0: {
                this.infoPanel.update(this.gui.getActiveUnit());
                break;
            }
            case 1: {
                if (this.gui.getSelectedTile() == null) break;
                Tile selectedTile = this.gui.getSelectedTile();
                if (this.infoPanel.getTile() == selectedTile) break;
                this.infoPanel.update(selectedTile);
            }
        }
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        if (this.infoPanel != null) {
            this.infoPanel.update(mapTransform);
        }
    }

    public void zoomIn() {
        this.miniMap.zoomIn();
        this.repaint();
    }

    public void zoomOut() {
        this.miniMap.zoomOut();
        this.repaint();
    }
}

