/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindSettlementDialog<T>
extends FreeColDialog<T>
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(FindSettlementDialog.class.getName());
    private List<Settlement> knownSettlements = new ArrayList<Settlement>();
    private JList settlementList;
    private static Comparator<Settlement> settlementComparator = new Comparator<Settlement>(){

        @Override
        public int compare(Settlement s1, Settlement s2) {
            return s1.getName().compareTo(s2.getName());
        }
    };

    public FindSettlementDialog(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
        for (Player player : this.getGame().getPlayers()) {
            this.knownSettlements.addAll(player.getSettlements());
        }
        Collections.sort(this.knownSettlements, settlementComparator);
        MigLayout layout = new MigLayout("wrap 1", "[align center]", "[]30[]30[]");
        this.setLayout((LayoutManager)layout);
        JLabel header = new JLabel(Messages.message("findSettlementDialog.name"));
        header.setFont(smallHeaderFont);
        this.add(header);
        this.settlementList = new JList<Settlement>(this.knownSettlements.toArray(new Settlement[this.knownSettlements.size()]));
        this.settlementList.setCellRenderer(new SettlementRenderer());
        this.settlementList.setFixedCellHeight(48);
        JScrollPane listScroller = new JScrollPane(this.settlementList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.settlementList.addListSelectionListener(this);
        AbstractAction selectAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FindSettlementDialog.this.selectSettlement();
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FindSettlementDialog.this.getGUI().removeFromCanvas(FindSettlementDialog.this);
            }
        };
        this.settlementList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.settlementList.getActionMap().put("select", selectAction);
        this.settlementList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.settlementList.getActionMap().put("quit", quitAction);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FindSettlementDialog.this.selectSettlement();
                }
            }
        };
        this.settlementList.addMouseListener(mouseListener);
        this.add((Component)listScroller, "width max(300, 100%), height max(300, 100%)");
        this.add((Component)this.okButton, "tag ok");
        this.restoreSavedSize(this.getPreferredSize());
    }

    private void selectSettlement() {
        Settlement settlement = (Settlement)this.settlementList.getSelectedValue();
        if (settlement instanceof Colony && settlement.getOwner() == this.getMyPlayer()) {
            this.getGUI().removeFromCanvas(this);
            this.getGUI().showColonyPanel((Colony)settlement);
        } else if (settlement instanceof IndianSettlement) {
            this.getGUI().removeFromCanvas(this);
            this.getGUI().showIndianSettlementPanel((IndianSettlement)settlement);
        }
    }

    @Override
    public void requestFocus() {
        this.settlementList.requestFocus();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Settlement settlement = (Settlement)this.settlementList.getSelectedValue();
        this.getGUI().setFocus(settlement.getTile());
    }

    private class SettlementRenderer
    extends FreeColComboBoxRenderer {
        private SettlementRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            Settlement settlement = (Settlement)value;
            String messageId = settlement.isCapital() ? "indianCapitalOwner" : "indianSettlementOwner";
            label.setText(Messages.message(StringTemplate.template(messageId).addName("%name%", settlement.getName()).addStringTemplate("%nation%", settlement.getOwner().getNationName())));
            label.setIcon(new ImageIcon(FindSettlementDialog.this.getLibrary().getSettlementImage(settlement).getScaledInstance(64, -1, 4)));
        }
    }
}

