/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaDetailPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColopediaGameObjectTypePanel<T extends FreeColGameObjectType>
extends FreeColPanel
implements ColopediaDetailPanel<T> {
    private String id;
    private double scale = 1.0;
    private ColopediaPanel colopediaPanel;

    public ColopediaGameObjectTypePanel(FreeColClient freeColClient, GUI gui, ColopediaPanel colopediaPanel, String id, double scale) {
        super(freeColClient, gui);
        this.colopediaPanel = colopediaPanel;
        this.id = "colopediaAction." + id;
        this.scale = scale;
    }

    @Override
    public String getName() {
        return Messages.message(this.id + ".name");
    }

    protected String getId() {
        return this.id;
    }

    protected double getScale() {
        return this.scale;
    }

    public void addSubTrees(DefaultMutableTreeNode root, List<T> types) {
        this.addSubTrees(root, this.id, types);
    }

    public void addSubTrees(DefaultMutableTreeNode root, String id, List<T> types) {
        String name = Messages.message(id + ".name");
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, id, name, null));
        int width = 0;
        int height = 0;
        for (FreeColGameObjectType type : types) {
            Image image = this.getLibrary().getImage(type, this.scale);
            width = Math.max(image.getWidth(null), width);
            height = Math.max(image.getHeight(null), height);
        }
        for (FreeColGameObjectType type : types) {
            BufferedImage centeredImage = new BufferedImage(width, height, 2);
            Image image = this.getLibrary().getImage(type, this.scale);
            int x = (width - image.getWidth(null)) / 2;
            int y = (height - image.getHeight(null)) / 2;
            centeredImage.getGraphics().drawImage(image, x, y, null);
            node.add(this.buildItem(type, new ImageIcon(centeredImage)));
        }
        root.add(node);
    }

    protected DefaultMutableTreeNode buildItem(FreeColGameObjectType type, ImageIcon icon) {
        String name = Messages.getName(type);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(this, type.getId(), name, icon));
        return item;
    }

    protected JButton getButton(FreeColGameObjectType type, String text, ImageIcon icon) {
        JButton button = ColopediaGameObjectTypePanel.getLinkButton(text == null ? Messages.getName(type) : text, icon, type.getId());
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(ColopediaAction.PanelType panelType, String text, ImageIcon icon) {
        JButton button = ColopediaGameObjectTypePanel.getLinkButton(text, icon, "colopediaAction." + (Object)((Object)panelType));
        button.addActionListener(this.colopediaPanel);
        return button;
    }

    protected JButton getButton(FreeColGameObjectType type) {
        return this.getButton(type, null, null);
    }

    protected JButton getResourceButton(ResourceType resourceType) {
        return this.getButton(resourceType, null, this.getLibrary().getBonusImageIcon(resourceType));
    }

    protected JButton getGoodsButton(GoodsType goodsType) {
        return this.getGoodsButton(goodsType, null);
    }

    protected JButton getGoodsButton(GoodsType goodsType, int amount) {
        return this.getGoodsButton(goodsType, Integer.toString(amount));
    }

    protected JButton getGoodsButton(GoodsType goodsType, String text) {
        JButton result = this.getButton(goodsType, text, this.getLibrary().getGoodsImageIcon(goodsType));
        result.setToolTipText(Messages.getName(goodsType));
        return result;
    }

    protected JButton getUnitButton(AbstractUnit unit) {
        return this.getUnitButton(unit.getUnitType(this.getSpecification()), unit.getRole());
    }

    protected JButton getUnitButton(UnitType unitType, Unit.Role role) {
        ImageIcon unitIcon = this.getLibrary().getUnitImageIcon(unitType, role, 0.66);
        JButton unitButton = this.getButton(unitType, null, unitIcon);
        unitButton.setHorizontalAlignment(2);
        return unitButton;
    }

    protected JButton getUnitButton(UnitType unitType) {
        return this.getUnitButton(unitType, Unit.Role.DEFAULT);
    }

    private String getFeatureName(Feature feature) {
        return Messages.message(feature.getNameKey());
    }

    private String getFeatureAsString(Feature feature) {
        String label = Messages.message(this.getFeatureName(feature)) + ":";
        if (feature.hasScope()) {
            for (Scope scope : feature.getScopes()) {
                String key = null;
                if (scope.getType() != null) {
                    key = scope.getType();
                } else if (scope.getAbilityID() != null) {
                    key = scope.getAbilityID();
                } else if (scope.getMethodName() != null) {
                    key = "model.scope." + scope.getMethodName();
                }
                if (key == null) continue;
                label = label + (scope.isMatchNegated() ? " !" : " ") + Messages.message(key + ".name") + ",";
            }
        }
        return label.substring(0, label.length() - 1);
    }

    public String getModifierAsString(Modifier modifier) {
        String bonus = modifierFormat.format(modifier.getValue());
        switch (modifier.getType()) {
            case ADDITIVE: {
                if (!(modifier.getValue() > 0.0f)) break;
                bonus = "+" + bonus;
                break;
            }
            case PERCENTAGE: {
                if (modifier.getValue() > 0.0f) {
                    bonus = "+" + bonus;
                }
                bonus = bonus + "%";
                break;
            }
            case MULTIPLICATIVE: {
                bonus = "\u00d7" + bonus;
                break;
            }
        }
        return bonus;
    }

    public JComponent getModifierComponent(Modifier modifier) {
        try {
            GoodsType goodsType = this.getSpecification().getGoodsType(modifier.getId());
            String bonus = this.getModifierAsString(modifier);
            return this.getGoodsButton(goodsType, bonus);
        }
        catch (Exception e) {
            JLabel label = new JLabel(this.getFeatureAsString(modifier) + ": " + this.getModifierAsString(modifier));
            label.setToolTipText(Messages.message(modifier.getId() + ".shortDescription"));
            return label;
        }
    }

    public JLabel getAbilityComponent(Ability ability) {
        if (ability.getValue()) {
            JLabel label = new JLabel(this.getFeatureAsString(ability));
            label.setToolTipText(Messages.message(ability.getId() + ".shortDescription"));
            return label;
        }
        return null;
    }

    public void appendRequiredAbilities(StyledDocument doc, BuildableType buildableType) throws BadLocationException {
        for (Map.Entry<String, Boolean> entry : buildableType.getRequiredAbilities().entrySet()) {
            doc.insertString(doc.getLength(), Messages.message(entry.getKey() + ".name"), doc.getStyle("regular"));
            ArrayList<JButton> requiredTypes = new ArrayList<JButton>();
            for (FreeColGameObjectType type : this.getSpecification().getTypesProviding(entry.getKey(), entry.getValue())) {
                JButton typeButton = this.getButton(type);
                typeButton.addActionListener(this);
                requiredTypes.add(typeButton);
            }
            if (!requiredTypes.isEmpty()) {
                doc.insertString(doc.getLength(), " (", doc.getStyle("regular"));
                StyleConstants.setComponent(doc.getStyle("button"), (Component)requiredTypes.get(0));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                for (int index = 1; index < requiredTypes.size(); ++index) {
                    JButton button = (JButton)requiredTypes.get(index);
                    doc.insertString(doc.getLength(), " / ", doc.getStyle("regular"));
                    StyleConstants.setComponent(doc.getStyle("button"), button);
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                }
                doc.insertString(doc.getLength(), ")", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
        }
    }
}

