/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.BuildingToolTip;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingPanel
extends JPanel
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(BuildingPanel.class.getName());
    private final Building building;
    private ProductionLabel productionOutput = null;
    private List<UnitLabel> unitLabels = new ArrayList<UnitLabel>();
    private FreeColClient freeColClient;
    private GUI gui;

    public BuildingPanel(FreeColClient freeColClient, Building building, GUI gui) {
        this.freeColClient = freeColClient;
        this.gui = gui;
        this.building = building;
        this.setToolTipText(" ");
        this.setLayout((LayoutManager)new MigLayout("", "[32][32][32]", "[32][44]"));
        this.initialize();
    }

    public void initialize() {
        this.cleanup();
        this.addPropertyChangeListeners();
        this.update();
    }

    public void update() {
        this.removeAll();
        this.unitLabels.clear();
        ProductionInfo info = this.building.getProductionInfo();
        if (info == null || info.getProduction().isEmpty()) {
            this.productionOutput = null;
        } else {
            AbstractGoods output = info.getProduction().get(0);
            if (output.getAmount() > 0) {
                if (this.building.hasAbility("model.ability.avoidExcessProduction")) {
                    int stored = this.building.getColony().getGoodsCount(output.getType());
                    int capacity = this.building.getColony().getWarehouseCapacity();
                    if (output.getAmount() + stored > capacity) {
                        output = new AbstractGoods(output.getType(), capacity - stored);
                    }
                }
                AbstractGoods maximum = info.getMaximumProduction().isEmpty() ? output : info.getMaximumProduction().get(0);
                this.productionOutput = new ProductionLabel(this.freeColClient, this.gui, output, maximum);
            }
        }
        UpkeepLabel upkeep = null;
        if (this.building.getSpecification().getBoolean("model.option.enableUpkeep") && this.building.getType().getUpkeep() > 0) {
            upkeep = new UpkeepLabel(this.building.getType().getUpkeep());
        }
        if (this.productionOutput == null) {
            if (upkeep != null) {
                this.add(upkeep, "span, align center");
            }
        } else if (upkeep == null) {
            this.add((Component)this.productionOutput, "span, align center");
        } else {
            this.add((Component)this.productionOutput, "span, split 2, align center");
            this.add(upkeep);
        }
        for (Unit unit : this.building.getUnitList()) {
            UnitLabel unitLabel = new UnitLabel(this.freeColClient, unit, this.gui, true);
            this.unitLabels.add(unitLabel);
            this.add(unitLabel);
        }
        this.setSize(new Dimension(96, 76));
        this.revalidate();
        this.repaint();
    }

    public void cleanup() {
        this.removePropertyChangeListeners();
    }

    @Override
    public void paintComponent(Graphics g) {
        BufferedImage bgImage = this.fadeImage(ResourceManager.getImage(this.building.getType().getId() + ".image"), 0.6f, 192.0f);
        g.drawImage(bgImage, 0, 0, this);
    }

    public BufferedImage fadeImage(Image img, float fade, float target) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(img, 0, 0, null);
        float offset = target * (1.0f - fade);
        float[] scales = new float[]{fade, fade, fade, 1.0f};
        float[] offsets = new float[]{offset, offset, offset, 0.0f};
        RescaleOp rop = new RescaleOp(scales, offsets, null);
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(bi, rop, 0, 0);
        return bi;
    }

    public Building getBuilding() {
        return this.building;
    }

    public void updateProductionLabel() {
        this.update();
    }

    public List<UnitLabel> getUnitLabels() {
        return this.unitLabels;
    }

    @Override
    public JToolTip createToolTip() {
        return new BuildingToolTip(this.freeColClient, this.building, this.gui);
    }

    public void addPropertyChangeListeners() {
        this.building.addPropertyChangeListener(this);
    }

    public void removePropertyChangeListeners() {
        this.building.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        logger.finest(this.building.getId() + " change " + property + ": " + event.getOldValue() + " -> " + event.getNewValue());
        this.update();
    }

    public class UpkeepLabel
    extends JLabel {
        private final Image image;

        public UpkeepLabel(int number) {
            super(BuildingPanel.this.gui.getImageLibrary().getMiscImageIcon("coin"));
            this.image = BuildingPanel.this.gui.getImageLibrary().getStringImage(BuildingPanel.this.gui.getCanvas().getGraphics(), Integer.toString(number), this.getForeground(), ResourceManager.getFont("SimpleFont", 1, 12.0f));
        }

        public void paintComponent(Graphics g) {
            this.getIcon().paintIcon(null, g, 0, 0);
            g.drawImage(this.image, (this.getIcon().getIconWidth() - this.image.getWidth(null)) / 2, (this.getIcon().getIconHeight() - this.image.getHeight(null)) / 2, null);
        }
    }
}

