/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.option.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringOptionUI
extends OptionUI<StringOption> {
    private JComboBox box = new JComboBox();

    public StringOptionUI(GUI gui, StringOption option, boolean editable) {
        super(gui, option, editable);
        List<String> choices = option.getChoices();
        this.box.setModel(new DefaultComboBoxModel<String>(choices.toArray(new String[choices.size()])));
        this.box.setSelectedItem(option.getValue());
        this.box.setRenderer(new ChoiceRenderer());
        this.initialize();
    }

    @Override
    public JComboBox getComponent() {
        return this.box;
    }

    @Override
    public void updateOption() {
        ((StringOption)this.getOption()).setValue((String)this.box.getSelectedItem());
    }

    @Override
    public void reset() {
        this.box.setSelectedItem(((StringOption)this.getOption()).getValue());
    }

    private class ChoiceRenderer
    extends FreeColComboBoxRenderer {
        private ChoiceRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            String key = (String)value;
            label.setText(Messages.message(key + ".name"));
            if (Messages.containsKey(key + ".shortDescription")) {
                label.setToolTipText(Messages.message(key + ".shortDescription"));
            }
        }
    }
}

