/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.StringOptionUI;
import net.sf.freecol.client.gui.option.UnitTypeOptionUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractUnitOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbstractUnitOptionUI
extends OptionUI<AbstractUnitOption>
implements ItemListener {
    private JPanel panel = new JPanel();
    private IntegerOptionUI numberUI;
    private UnitTypeOptionUI typeUI;
    private StringOptionUI roleUI;
    private boolean roleEditable;

    public AbstractUnitOptionUI(GUI gui, AbstractUnitOption option, boolean editable) {
        super(gui, option, editable);
        this.panel.setLayout((LayoutManager)new MigLayout());
        IntegerOption numberOption = option.getNumber();
        UnitTypeOption typeOption = option.getUnitType();
        StringOption roleOption = option.getRole();
        boolean numberEditable = editable && numberOption.getMaximumValue() > numberOption.getMinimumValue();
        this.numberUI = new IntegerOptionUI(gui, numberOption, numberEditable);
        this.numberUI.getComponent().setToolTipText(Messages.message("report.numberOfUnits"));
        this.panel.add((Component)this.numberUI.getComponent(), "width 30%");
        boolean typeEditable = editable && typeOption.getChoices().size() > 1;
        this.typeUI = new UnitTypeOptionUI(gui, typeOption, typeEditable);
        this.typeUI.getComponent().setToolTipText(Messages.message("model.unit.type"));
        this.typeUI.getComponent().addItemListener(this);
        this.panel.add((Component)this.typeUI.getComponent(), "width 35%");
        this.roleEditable = editable && roleOption.getChoices().size() > 1;
        this.roleUI = new StringOptionUI(gui, roleOption, this.roleEditable);
        this.roleUI.getComponent().setToolTipText(Messages.message("model.unit.role.name"));
        this.roleUI.getComponent().setRenderer(new RoleRenderer());
        this.panel.add((Component)this.roleUI.getComponent(), "width 35%");
        this.initialize();
    }

    @Override
    public JPanel getComponent() {
        return this.panel;
    }

    @Override
    public void updateOption() {
        this.typeUI.updateOption();
        this.roleUI.updateOption();
        this.numberUI.updateOption();
        UnitType type = ((UnitTypeOption)this.typeUI.getOption()).getValue();
        Unit.Role role = Unit.Role.valueOf(((StringOption)this.roleUI.getOption()).getValue());
        int number = ((IntegerOption)this.numberUI.getOption()).getValue();
        ((AbstractUnitOption)this.getOption()).setValue(new AbstractUnit(type, role, number));
    }

    @Override
    public void reset() {
        this.typeUI.reset();
        this.roleUI.reset();
        this.numberUI.reset();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JComboBox box = this.roleUI.getComponent();
        UnitType type = (UnitType)this.typeUI.getComponent().getSelectedItem();
        if (type.hasAbility("model.ability.canBeEquipped")) {
            box.setModel(new DefaultComboBoxModel<String>(((StringOption)this.roleUI.getOption()).getChoices().toArray(new String[0])));
            box.setEnabled(this.roleEditable);
        } else {
            box.setModel(new DefaultComboBoxModel<String>(new String[]{Unit.Role.DEFAULT.toString()}));
            box.setEnabled(false);
        }
    }

    @Override
    public ListCellRenderer getListCellRenderer() {
        return new AbstractUnitRenderer();
    }

    private class AbstractUnitRenderer
    implements ListCellRenderer {
        private final JPanel normal = new JPanel();
        private final JPanel selected = new JPanel(){

            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                Composite oldComposite = g2d.getComposite();
                Color oldColor = g2d.getColor();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
                g2d.setColor(Color.BLACK);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setComposite(oldComposite);
                g2d.setColor(oldColor);
                super.paintComponent(g);
            }
        };

        public AbstractUnitRenderer() {
            this.normal.setOpaque(false);
            this.normal.setLayout((LayoutManager)new MigLayout("", "[40, align right][]"));
            this.selected.setOpaque(false);
            this.selected.setLayout((LayoutManager)new MigLayout("", "[40, align right][]"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            JPanel c = isSelected ? this.selected : this.normal;
            c.removeAll();
            c.setForeground(list.getForeground());
            c.setFont(list.getFont());
            AbstractUnit unit = ((AbstractUnitOption)value).getValue();
            String key = unit.getId();
            if (unit.getUnitType(((AbstractUnitOption)AbstractUnitOptionUI.this.getOption()).getSpecification()).hasAbility("model.ability.canBeEquipped") && unit.getRole() != Unit.Role.DEFAULT) {
                key = "model.unit." + unit.getRole().toString().toLowerCase(Locale.US);
            }
            StringTemplate template = StringTemplate.template(key + ".name").addAmount("%number%", unit.getNumber()).add("%unit%", unit.getId() + ".name");
            c.add(new JLabel(Integer.toString(unit.getNumber())));
            c.add(new JLabel(Messages.message(template)));
            return c;
        }
    }

    private class RoleRenderer
    extends FreeColComboBoxRenderer {
        private RoleRenderer() {
        }

        public void setLabelValues(JLabel label, Object value) {
            label.setText(Messages.message("model.unit.role." + ((String)value).toLowerCase(Locale.US)));
        }
    }
}

