/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceManager;

public class DebugMenu
extends JMenu {
    private static final Logger logger = Logger.getLogger(DebugMenu.class.getName());
    private FreeColClient freeColClient;
    private GUI gui;
    private static final String ERROR_MESSAGE = "This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred.";

    public DebugMenu(FreeColClient freeColClient) {
        super(Messages.message("menuBar.debug"));
        this.freeColClient = freeColClient;
        this.buildDebugMenu();
    }

    private void buildDebugMenu() {
        Game game = this.freeColClient.getGame();
        final GUI gui = this.freeColClient.getGUI();
        boolean hasServer = this.freeColClient.getFreeColServer() != null;
        Player player = this.freeColClient.getMyPlayer();
        this.setOpaque(false);
        this.setMnemonic(68);
        this.add(this);
        JCheckBoxMenuItem sc = new JCheckBoxMenuItem(Messages.message("menuBar.debug.showCoordinates"), gui.getMapViewer().displayCoordinates);
        sc.setOpaque(false);
        sc.setMnemonic(83);
        this.add(sc);
        sc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.getMapViewer().displayCoordinates = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                gui.refresh();
            }
        });
        sc.setEnabled(true);
        final JCheckBoxMenuItem reveal = new JCheckBoxMenuItem(Messages.message("menuBar.debug.revealEntireMap"));
        reveal.setOpaque(false);
        reveal.setMnemonic(82);
        this.add(reveal);
        reveal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.revealMap(DebugMenu.this.freeColClient, true);
                reveal.setEnabled(false);
            }
        });
        reveal.setEnabled(hasServer);
        final JCheckBoxMenuItem hide = new JCheckBoxMenuItem(Messages.message("menuBar.debug.hideEntireMap"));
        hide.setOpaque(false);
        this.add(hide);
        hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.revealMap(DebugMenu.this.freeColClient, false);
                hide.setEnabled(false);
            }
        });
        hide.setEnabled(hasServer);
        JMenu cvpMenu = new JMenu(Messages.message("menuBar.debug.showColonyValue"));
        cvpMenu.setOpaque(false);
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem cv1 = new JRadioButtonMenuItem("Do not display", !gui.getMapViewer().displayColonyValue);
        cv1.setOpaque(false);
        cv1.setMnemonic(67);
        cvpMenu.add(cv1);
        bg.add(cv1);
        cv1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.getMapViewer().displayColonyValue = false;
                gui.getMapViewer().displayColonyValuePlayer = null;
                gui.refresh();
            }
        });
        this.add(cvpMenu);
        JRadioButtonMenuItem cv3 = new JRadioButtonMenuItem(Messages.message("menuBar.debug.showCommonOutpostValue"), gui.getMapViewer().displayColonyValue && gui.getMapViewer().displayColonyValuePlayer == null);
        cv3.setOpaque(false);
        cvpMenu.add(cv3);
        bg.add(cv3);
        cv3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.getMapViewer().displayColonyValue = true;
                gui.getMapViewer().displayColonyValuePlayer = null;
                gui.refresh();
            }
        });
        this.add(cvpMenu);
        cvpMenu.addSeparator();
        for (Player p : game.getLiveEuropeanPlayers()) {
            JRadioButtonMenuItem cv2 = new JRadioButtonMenuItem(Messages.message(p.getNationName()), gui.getMapViewer().displayColonyValue && gui.getMapViewer().displayColonyValuePlayer == p);
            cv2.setOpaque(false);
            cvpMenu.add(cv2);
            bg.add(cv2);
            final Player fp = p;
            cv2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    gui.getMapViewer().displayColonyValue = true;
                    gui.getMapViewer().displayColonyValuePlayer = fp;
                    gui.refresh();
                }
            });
        }
        this.addSeparator();
        JMenuItem skipTurns = new JMenuItem(Messages.message("menuBar.debug.skipTurns"));
        skipTurns.setOpaque(false);
        skipTurns.setMnemonic(84);
        this.add(skipTurns);
        skipTurns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.skipTurns(DebugMenu.this.freeColClient);
            }
        });
        DebugUtils.addSkipChangeListener(this.freeColClient, this, skipTurns);
        skipTurns.setEnabled(hasServer);
        final String buildingTitle = Messages.message("menuBar.debug.addBuilding");
        JMenuItem addBuilding = new JMenuItem(buildingTitle);
        addBuilding.setOpaque(false);
        addBuilding.setMnemonic(66);
        this.add(addBuilding);
        addBuilding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.addBuildings(DebugMenu.this.freeColClient, buildingTitle);
            }
        });
        addBuilding.setEnabled(hasServer);
        final String fatherTitle = Messages.message("menuBar.debug.addFoundingFather");
        JMenuItem addFather = new JMenuItem(fatherTitle);
        addFather.setOpaque(false);
        addFather.setMnemonic(70);
        this.add(addFather);
        addFather.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.addFathers(DebugMenu.this.freeColClient, fatherTitle);
            }
        });
        addFather.setEnabled(hasServer);
        final String monarchTitle = Messages.message("menuBar.debug.runMonarch");
        JMenuItem runMonarch = new JMenuItem(monarchTitle);
        runMonarch.setOpaque(false);
        runMonarch.setMnemonic(77);
        this.add(runMonarch);
        runMonarch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.setMonarchAction(DebugMenu.this.freeColClient, monarchTitle);
            }
        });
        runMonarch.setEnabled(hasServer);
        String goldTitle = Messages.message("menuBar.debug.addGold");
        JMenuItem addGold = new JMenuItem(goldTitle);
        addGold.setOpaque(false);
        addGold.setMnemonic(71);
        this.add(addGold);
        addGold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.addGold(DebugMenu.this.freeColClient);
            }
        });
        addGold.setEnabled(hasServer);
        String immigrationTitle = Messages.message("menuBar.debug.addImmigration");
        JMenuItem addCrosses = new JMenuItem(immigrationTitle);
        addCrosses.setOpaque(false);
        addCrosses.setMnemonic(73);
        this.add(addCrosses);
        addCrosses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.addImmigration(DebugMenu.this.freeColClient);
            }
        });
        addCrosses.setEnabled(hasServer);
        JMenuItem giveBells = new JMenuItem(Messages.message("menuBar.debug.addLiberty"));
        giveBells.setOpaque(false);
        giveBells.setMnemonic(76);
        this.add(giveBells);
        giveBells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.addLiberty(DebugMenu.this.freeColClient);
            }
        });
        giveBells.setEnabled(hasServer);
        JMenuItem rng = new JMenuItem(Messages.message("menuBar.debug.stepRandomNumberGenerator"));
        rng.setOpaque(false);
        rng.setMnemonic(88);
        this.add(rng);
        rng.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.stepRNG(DebugMenu.this.freeColClient);
            }
        });
        rng.setEnabled(hasServer);
        JMenuItem du = new JMenuItem(Messages.message("menuBar.debug.displayUnits"));
        du.setOpaque(false);
        this.add(du);
        du.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.displayUnits(DebugMenu.this.freeColClient);
            }
        });
        du.setEnabled(true);
        this.addSeparator();
        JMenu panelMenu = new JMenu(Messages.message("menuBar.debug.displayPanels"));
        panelMenu.setOpaque(false);
        JMenuItem monarchPanel = new JMenuItem(Messages.message("menuBar.debug.displayMonarchPanel"));
        monarchPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.showMonarchPanelDialog(Monarch.MonarchAction.RAISE_TAX_WAR, null);
            }
        });
        panelMenu.add(monarchPanel);
        JMenuItem victoryPanel = new JMenuItem(Messages.message("menuBar.debug.displayVictoryPanel"));
        victoryPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.showVictoryPanel();
            }
        });
        panelMenu.add(victoryPanel);
        for (final Canvas.EventType eventType : Canvas.EventType.values()) {
            JMenuItem mItem = new JMenuItem("Display " + (Object)((Object)eventType) + " panel");
            mItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    gui.showEventPanel(eventType);
                }
            });
            panelMenu.add(mItem);
        }
        JMenuItem errorMessage = new JMenuItem(Messages.message("menuBar.debug.displayErrorMessage"));
        errorMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.errorMessage(DebugMenu.ERROR_MESSAGE);
            }
        });
        panelMenu.add(errorMessage);
        this.add(panelMenu);
        JMenuItem europeStatus = new JMenuItem(Messages.message("menuBar.debug.displayEuropeStatus"));
        europeStatus.setOpaque(false);
        europeStatus.setMnemonic(69);
        this.add(europeStatus);
        europeStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.displayEurope(DebugMenu.this.freeColClient);
            }
        });
        europeStatus.setEnabled(hasServer);
        JCheckBoxMenuItem dam = new JCheckBoxMenuItem("Display AI-missions", gui.getMapViewer().debugShowMission);
        final JCheckBoxMenuItem dami = new JCheckBoxMenuItem("Additional AI-mission info", gui.getMapViewer().debugShowMissionInfo);
        dam.setOpaque(false);
        dam.setMnemonic(65);
        this.add(dam);
        dam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.getMapViewer().debugShowMission = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                dami.setEnabled(gui.getMapViewer().debugShowMission);
                gui.refresh();
            }
        });
        dam.setEnabled(true);
        JMenuItem useAI = new JMenuItem(Messages.message("menuBar.debug.useAI"));
        useAI.setOpaque(false);
        useAI.setMnemonic(65);
        useAI.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(useAI);
        useAI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.useAI(DebugMenu.this.freeColClient);
            }
        });
        useAI.setEnabled(hasServer);
        dami.setOpaque(false);
        dami.setMnemonic(73);
        this.add(dami);
        dami.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.getMapViewer().debugShowMissionInfo = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                gui.refresh();
            }
        });
        dami.setEnabled(gui.getMapViewer().debugShowMission);
        this.addSeparator();
        JMenuItem compareMaps = new JMenuItem(Messages.message("menuBar.debug.compareMaps"));
        compareMaps.setOpaque(false);
        compareMaps.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(compareMaps);
        compareMaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugUtils.checkDesyncAction(DebugMenu.this.freeColClient);
            }
        });
        compareMaps.setEnabled(hasServer);
        JMenuItem showResourceKeys = new JMenuItem(Messages.message("menuBar.debug.showResourceKeys"));
        showResourceKeys.setOpaque(false);
        this.add(showResourceKeys);
        showResourceKeys.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Map<String, Resource> resources = ResourceManager.getResources();
                ArrayList<String> keys = new ArrayList<String>(resources.keySet());
                Collections.sort(keys);
                StringBuilder builder = new StringBuilder();
                for (String key : keys) {
                    builder.append(key);
                    Resource resource = resources.get(key);
                    if (resource instanceof ImageResource) {
                        ImageResource ir = (ImageResource)resource;
                        builder.append(" (");
                        builder.append(ir.getCount());
                        builder.append(")");
                    }
                    builder.append("\n");
                }
                gui.showInformationMessage(builder.toString());
            }
        });
        showResourceKeys.setEnabled(true);
        JMenuItem statistics = new JMenuItem(Messages.message("menuBar.debug.statistics"));
        statistics.setOpaque(false);
        this.add(statistics);
        statistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                gui.showStatisticsPanel();
            }
        });
        statistics.setEnabled(true);
        JMenuItem gc = new JMenuItem(Messages.message("menuBar.debug.memoryManager.gc"));
        gc.setOpaque(false);
        this.add(gc);
        gc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        gc.setEnabled(true);
        this.addSeparator();
    }
}

