/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Unit;

public class UnloadAction
extends MapboardAction {
    public static final String id = "unloadAction";
    private Unit unit = null;
    private final InGameController inGameController;

    public UnloadAction(FreeColClient freeColClient, InGameController inGameController, GUI gui) {
        this(freeColClient, inGameController, gui, null);
    }

    public UnloadAction(FreeColClient freeColClient, InGameController inGameController, GUI gui, Unit unit) {
        super(freeColClient, gui, id);
        this.inGameController = inGameController;
        this.unit = unit;
    }

    private Unit getUnit() {
        return this.unit != null ? this.unit : this.gui.getActiveUnit();
    }

    protected boolean shouldBeEnabled() {
        Unit carrier = this.getUnit();
        return super.shouldBeEnabled() && carrier != null && carrier.isCarrier() && carrier.getCargoSpaceTaken() > 0;
    }

    public void actionPerformed(ActionEvent e) {
        Unit carrier = this.getUnit();
        if (carrier != null) {
            this.inGameController.unload(carrier);
            this.gui.updateMapControls();
        }
    }
}

