/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public class ScaleMapAction
extends FreeColAction {
    public static final String id = "scaleMapAction";

    ScaleMapAction(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui, id);
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
    }

    public void actionPerformed(ActionEvent e) {
        Dimension ms = this.gui.showScaleMapSizeDialog();
        if (ms != null) {
            this.scaleMapTo(ms.width, ms.height);
        }
    }

    private void scaleMapTo(int width, int height) {
        Game game = this.freeColClient.getGame();
        Map oldMap = game.getMap();
        int oldWidth = oldMap.getWidth();
        int oldHeight = oldMap.getHeight();
        Tile[][] tiles = new Tile[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int oldX = x * oldWidth / width;
                int oldY = y * oldHeight / height;
                Tile importTile = oldMap.getTile(oldX, oldY);
                Tile t = new Tile(game, importTile.getType(), x, y);
                if (importTile.getMoveToEurope() != null) {
                    t.setMoveToEurope(importTile.getMoveToEurope());
                }
                if (t.getTileItemContainer() != null) {
                    t.getTileItemContainer().copyFrom(importTile.getTileItemContainer());
                }
                tiles[x][y] = t;
            }
        }
        Map map = new Map(game, tiles);
        game.setMap(map);
        this.gui.setSelectedTile(map.getTile(0, 0), false);
        this.gui.refresh();
    }
}

