/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public class LoadAction
extends MapboardAction {
    public static final String id = "loadAction";
    private final InGameController inGameController;

    public LoadAction(FreeColClient freeColClient, InGameController inGameController, GUI gui) {
        super(freeColClient, gui, id);
        this.inGameController = inGameController;
    }

    protected boolean shouldBeEnabled() {
        Unit carrier = this.gui.getActiveUnit();
        return super.shouldBeEnabled() && carrier != null && carrier.isCarrier() && carrier.hasSpaceLeft();
    }

    public void actionPerformed(ActionEvent e) {
        Colony colony;
        Unit unit = this.gui.getActiveUnit();
        if (unit != null && (colony = unit.getColony()) != null) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (goods.getAmount() >= 100 || colony.getGoodsCount(goods.getType()) <= 0) continue;
                int amount = Math.min(100 - goods.getAmount(), colony.getGoodsCount(goods.getType()));
                Goods newGoods = new Goods(goods.getGame(), colony, goods.getType(), amount);
                this.inGameController.loadCargo(newGoods, unit);
            }
        }
    }
}

