/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnitAction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;

public class ImprovementAction
extends UnitAction {
    private TileImprovementType improvement;
    private final InGameController inGameController;

    public ImprovementAction(FreeColClient freeColClient, InGameController inGameController, GUI gui, TileImprovementType improvement) {
        super(freeColClient, gui, improvement.getShortId() + "Action");
        this.inGameController = inGameController;
        this.improvement = improvement;
        this.addImageIcons(improvement.getShortId());
    }

    protected boolean shouldBeEnabled() {
        if (super.shouldBeEnabled()) {
            Unit selectedUnit = this.gui.getActiveUnit();
            Tile tile = selectedUnit.getTile();
            return selectedUnit.checkSetState(Unit.UnitState.IMPROVING) && this.improvement.isTileAllowed(tile) && this.improvement.isWorkerAllowed(selectedUnit);
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        this.inGameController.changeWorkImprovementType(this.gui.getActiveUnit(), this.improvement);
        this.inGameController.nextActiveUnit();
    }
}

