/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNIT_LINES_IN_FIRST_MENU = 9;
    public static final int UNIT_LINES_IN_OTHER_MENUS = 19;
    private final FreeColClient freeColClient;
    private final GUI gui;
    private boolean hasAnItem = false;

    public TilePopup(final FreeColClient freeColClient, final GUI gui, final Tile tile) {
        super(Messages.message(StringTemplate.template("tile").addAmount("%x%", tile.getX()).addAmount("%y%", tile.getY())));
        Component lastComponent;
        Settlement settlement;
        Tile unitTile;
        this.freeColClient = freeColClient;
        this.gui = gui;
        final Player player = freeColClient.getMyPlayer();
        final Unit activeUnit = gui.getActiveUnit();
        if (activeUnit != null && (unitTile = activeUnit.getTile()) != null) {
            JMenuItem gotoMenuItem = null;
            if (activeUnit.isOffensiveUnit() && unitTile.isAdjacent(tile) && activeUnit.getMoveType(tile).isAttack()) {
                CombatModel.CombatOdds combatOdds = activeUnit.getGame().getCombatModel().calculateCombatOdds(activeUnit, tile.getDefendingUnit(activeUnit));
                String victoryPercent = tile.getSettlement() != null || combatOdds.win == -1.0f ? "??" : Integer.toString((int)(combatOdds.win * 100.0f));
                gotoMenuItem = new JMenuItem(Messages.message(StringTemplate.template("attackTileOdds").addName("%chance%", victoryPercent)));
            } else if (activeUnit.getSimpleMoveType(unitTile, tile).isLegal()) {
                gotoMenuItem = new JMenuItem(Messages.message("gotoThisTile"));
            }
            if (gotoMenuItem != null) {
                gotoMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (!freeColClient.currentPlayerIsMyPlayer()) {
                            return;
                        }
                        Tile currTile = activeUnit.getTile();
                        if (currTile == tile) {
                            return;
                        }
                        freeColClient.getInGameController().goToTile(activeUnit, tile);
                        if (activeUnit.getTile() == currTile) {
                            gui.getMapViewer().updateGotoPathForActiveUnit();
                        }
                    }
                });
                this.add(gotoMenuItem);
            }
            if (unitTile == tile && activeUnit.hasHighSeasMove()) {
                JMenuItem europeMenuItem = new JMenuItem(Messages.message(StringTemplate.template("gotoEurope")));
                europeMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (!freeColClient.currentPlayerIsMyPlayer()) {
                            return;
                        }
                        freeColClient.getInGameController().moveTo(activeUnit, player.getEurope());
                    }
                });
                this.add(europeMenuItem);
                this.hasAnItem = true;
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == player) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        this.addTile(tile);
        this.addSeparator();
        int lineCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        boolean moreUnits = false;
        List<Unit> units = tile.getUnitList();
        Collections.sort(units, ReportPanel.unitTypeComparator);
        for (Unit currentUnit : units) {
            if (lineCount > maxUnits) {
                JMenu more = new JMenu(Messages.message("more"));
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                moreUnits = true;
                lineCount = 0;
                maxUnits = 19;
            }
            lineCount += this.addUnit(currentMenu, currentUnit, !currentUnit.isUnderRepair(), false);
        }
        if (tile.getUnitCount() > 1) {
            if (moreUnits) {
                this.addSeparator();
            }
            JMenuItem activateAllItem = new JMenuItem(Messages.message(StringTemplate.template("activateAllUnits")));
            activateAllItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Unit lastUnit = null;
                    for (Unit unit : tile.getUnitList()) {
                        freeColClient.getInGameController().clearOrders(unit);
                        lastUnit = unit;
                    }
                    gui.setActiveUnit(lastUnit);
                }
            });
            this.add(activateAllItem);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && freeColClient.getFreeColServer() != null) {
            this.addDebugItems(freeColClient, tile);
        }
        if ((lastComponent = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    public void addDebugItems(final FreeColClient freeColClient, final Tile tile) {
        boolean notEmpty = false;
        this.addSeparator();
        JMenu takeOwnership = new JMenu("Take ownership");
        takeOwnership.setOpaque(false);
        JMenu transportLists = new JMenu("Transport lists");
        transportLists.setOpaque(false);
        for (final Unit unit : tile.getUnitList()) {
            JMenuItem toMenuItem = new JMenuItem(unit.toString());
            toMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.takeOwnership(freeColClient, unit);
                }
            });
            takeOwnership.add(toMenuItem);
            notEmpty = true;
            if (!unit.isCarrier()) continue;
            JMenuItem menuItem = new JMenuItem(unit.toString());
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.displayMission(freeColClient, unit);
                }
            });
            transportLists.add(menuItem);
        }
        if (transportLists.getItemCount() > 0) {
            this.add(transportLists);
        }
        if (tile.getColony() != null) {
            if (!notEmpty) {
                takeOwnership.addSeparator();
            }
            JMenuItem toMenuItem = new JMenuItem(tile.getColony().toString());
            final Colony colony = tile.getColony();
            toMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.takeOwnership(freeColClient, colony);
                }
            });
            takeOwnership.add(toMenuItem);
            notEmpty = true;
            JMenuItem displayColonyPlan = new JMenuItem("Display Colony Plan");
            displayColonyPlan.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.displayColonyPlan(freeColClient, colony);
                }
            });
            this.add(displayColonyPlan);
        }
        if (tile.getIndianSettlement() != null) {
            JMenuItem displayGoods = new JMenuItem("Examine Settlement");
            final IndianSettlement is = tile.getIndianSettlement();
            displayGoods.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.summarizeSettlement(freeColClient, is);
                }
            });
            this.add(displayGoods);
        }
        if (notEmpty) {
            this.add(takeOwnership);
        }
        if (tile.hasLostCityRumour()) {
            JMenuItem rumourItem = new JMenuItem("Set Lost City Rumour type");
            rumourItem.setOpaque(false);
            rumourItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.setRumourType(freeColClient, tile);
                }
            });
            this.add(rumourItem);
        }
        JMenuItem addu = new JMenuItem("Add unit");
        addu.setOpaque(false);
        addu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DebugUtils.addNewUnitToTile(freeColClient, tile);
            }
        });
        this.add(addu);
        if (!tile.isEmpty()) {
            JMenuItem adda = new JMenuItem("Reset moves");
            adda.setOpaque(false);
            final List<Unit> tileUnits = tile.getUnitList();
            adda.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.resetMoves(freeColClient, tileUnits);
                }
            });
            this.add(adda);
        }
        for (Unit u : tile.getUnitList()) {
            if (!u.canCarryGoods() || !u.hasSpaceLeft()) continue;
            JMenuItem addg = new JMenuItem("Add goods");
            addg.setOpaque(false);
            final Unit unit = u;
            addg.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DebugUtils.addUnitGoods(freeColClient, unit);
                }
            });
            this.add(addg);
            break;
        }
        JMenuItem dumpItem = new JMenuItem("Dump tile");
        dumpItem.setOpaque(false);
        dumpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                DebugUtils.dumpTile(freeColClient, tile);
            }
        });
        this.add(dumpItem);
    }

    private int addUnit(Container menu, final Unit unit, boolean enabled, boolean indent) {
        TradeRoute tradeRoute = unit.getTradeRoute();
        StringTemplate occ = unit.getState() == Unit.UnitState.ACTIVE && unit.getMovesLeft() == 0 ? (unit.isUnderRepair() ? StringTemplate.label(": ").add("model.unit.occupation.underRepair").add(Integer.toString(unit.getTurnsForRepair())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").addName(tradeRoute.getName()) : StringTemplate.key("model.unit.occupation.activeNoMovesLeft"))) : (unit.getState() == Unit.UnitState.IMPROVING && unit.getWorkImprovement() != null ? StringTemplate.label(": ").add(unit.getWorkImprovement().getType() + ".occupationString").add(Integer.toString(unit.getWorkTurnsLeft())) : (tradeRoute != null ? StringTemplate.label(": ").add("model.unit.occupation.inTradeRoute").add(tradeRoute.getName()) : (unit.getDestination() != null ? StringTemplate.key("model.unit.occupation.goingSomewhere") : StringTemplate.key("model.unit.occupation." + unit.getState().toString().toLowerCase()))));
        String text = (indent ? "    " : "") + Messages.message(StringTemplate.template("model.unit.nationUnit").addStringTemplate("%nation%", unit.getOwner().getNationName()).addStringTemplate("%unit%", Messages.getLabel(unit))) + " (" + Messages.message(occ) + ")";
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.setActiveUnit(unit);
            }
        });
        int lineCount = 1;
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
        for (Unit passenger : unit.getUnitList()) {
            lineCount += this.addUnit(menu, passenger, true, true);
        }
        boolean hasGoods = false;
        for (Goods goods : unit.getGoodsList()) {
            text = (indent ? "         " : "     ") + Messages.message(goods.getLabel(true));
            menuItem = new JMenuItem(text);
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            ++lineCount;
            hasGoods = true;
        }
        if (hasGoods) {
            JMenuItem dumpItem = new JMenuItem(Messages.message("dumpCargo"));
            dumpItem.setAction(new UnloadAction(this.freeColClient, this.freeColClient.getInGameController(), this.gui, unit));
            menu.add(dumpItem);
            ++lineCount;
        }
        this.hasAnItem = true;
        return lineCount;
    }

    private void addColony(final Colony colony) {
        StringTemplate name = colony.getLocationNameFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = new JMenuItem(Messages.message(name));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showColonyPanel(colony);
            }
        });
        this.add(menuItem);
        menuItem = new JMenuItem(Messages.message("rename"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.freeColClient.getInGameController().rename(colony);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(final IndianSettlement settlement) {
        StringTemplate name = settlement.getLocationNameFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = new JMenuItem(Messages.message(name));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showIndianSettlementPanel(settlement);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(final Tile tile) {
        JMenuItem menuItem = new JMenuItem(Messages.message(tile.getNameKey()));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.showTilePanel(tile);
            }
        });
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.getComponentCount() > 0;
    }
}

