/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;

public final class ImageLibrary {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final String UNIT_SELECT = "unitSelect.image";
    public static final String DELETE = "delete.image";
    public static final String PLOWED = "model.improvement.plow.image";
    public static final String TILE_TAKEN = "tileTaken.image";
    public static final String TILE_OWNED_BY_INDIANS = "nativeLand.image";
    public static final String LOST_CITY_RUMOUR = "lostCityRumour.image";
    public static final String DARKNESS = "halo.dark.image";
    private final float scalingFactor;

    public ImageLibrary() {
        this(1.0f);
    }

    public ImageLibrary(float scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    private Image createChip(String text, Color border, Color background, Color foreground) {
        Font font = ResourceManager.getFont("SimpleFont", 1, (float)Math.rint(12.0f * this.getScalingFactor()));
        BufferedImage bi = new BufferedImage(100, 100, 2);
        Graphics2D g2 = bi.createGraphics();
        TextLayout label = new TextLayout(text, font, g2.getFontRenderContext());
        float padding = 6.0f * this.getScalingFactor();
        int width = (int)(label.getBounds().getWidth() + (double)padding);
        int height = (int)(label.getAscent() + label.getDescent() + padding);
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        g2.setColor(foreground);
        label.draw(g2, (float)((double)(padding / 2.0f) - label.getBounds().getX()), label.getAscent() + padding / 2.0f);
        g2.dispose();
        return bi.getSubimage(0, 0, width, height);
    }

    private Image createFilledChip(String text, Color border, Color background, double amount, Color fill, Color foreground) {
        Font font = ResourceManager.getFont("SimpleFont", 1, (float)Math.rint(12.0f * this.getScalingFactor()));
        BufferedImage bi = new BufferedImage(100, 100, 2);
        Graphics2D g2 = bi.createGraphics();
        TextLayout label = new TextLayout(text, font, g2.getFontRenderContext());
        float padding = 6.0f * this.getScalingFactor();
        int width = (int)(label.getBounds().getWidth() + (double)padding);
        int height = (int)(label.getAscent() + label.getDescent() + padding);
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        if (amount > 0.0 && amount <= 1.0) {
            g2.setColor(fill);
            g2.fillRect(1, 1, width - 2, (int)((double)(height - 2) * amount));
        }
        g2.setColor(foreground);
        label.draw(g2, (float)((double)(padding / 2.0f) - label.getBounds().getX()), label.getAscent() + padding / 2.0f);
        g2.dispose();
        return bi.getSubimage(0, 0, width, height);
    }

    public Color getForegroundColor(Color background) {
        return (double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 < 126.0 ? Color.WHITE : Color.BLACK;
    }

    public Color getStringBorderColor(Color color) {
        return (double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0 ? Color.WHITE : Color.BLACK;
    }

    public static void drawTiledImage(String resource, Graphics g, JComponent c, Insets insets) {
        int dy;
        int dx;
        int ymin;
        int xmin;
        int width = c.getWidth();
        int height = c.getHeight();
        Image image = ResourceManager.getImage(resource);
        if (insets == null) {
            xmin = 0;
            ymin = 0;
        } else {
            xmin = insets.left;
            ymin = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (image != null && (dx = image.getWidth(null)) > 0 && (dy = image.getHeight(null)) > 0) {
            int xmax = xmin + width;
            int ymax = ymin + height;
            for (int x = xmin; x < xmax; x += dx) {
                for (int y = ymin; y < ymax; y += dy) {
                    g.drawImage(image, x, y, null);
                }
            }
        } else {
            g.setColor(c.getBackground());
            g.fillRect(xmin, ymin, width, height);
        }
    }

    public Image getAlarmChip(IndianSettlement is, Player player, String text) {
        String key;
        Image img;
        Tension alarm;
        Color ownerColor = this.getColor(is.getOwner());
        Color foreground = this.getForegroundColor(ownerColor);
        Color enemyColor = null;
        int amount = 0;
        Player enemy = is.getMostHated();
        if (player != null && (alarm = is.getAlarm(player)) != null) {
            enemyColor = this.getColor(player);
            amount = alarm.getLevel().ordinal() - Tension.Level.HAPPY.ordinal();
            if (amount >= 2) {
                foreground = this.getForegroundColor(enemyColor);
            }
        }
        if ((img = ResourceManager.getImage(key = "dynamic.alarm." + text + "." + ownerColor.getRGB() + "." + Integer.toString(amount) + "." + enemyColor.getRGB())) == null) {
            img = this.createFilledChip(text, Color.BLACK, ownerColor, (double)amount / 4.0, enemyColor, foreground);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    private boolean isEven(int x, int y) {
        return y % 8 <= 2 || (x + y) % 2 == 0;
    }

    public Image getBeachCornerImage(int index, int x, int y) {
        return ResourceManager.getImage("model.tile.beach.corner" + index + (this.isEven(x, y) ? "_even" : "_odd"), this.scalingFactor);
    }

    public Image getBeachEdgeImage(int index, int x, int y) {
        return ResourceManager.getImage("model.tile.beach.edge" + index + (this.isEven(x, y) ? "_even" : "_odd"), this.scalingFactor);
    }

    public Image getBonusImage(ResourceType type) {
        return this.getBonusImage(type, this.scalingFactor);
    }

    public Image getBonusImage(ResourceType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public Image getBonusImage(Tile tile) {
        return tile.hasResource() ? this.getBonusImage(tile.getTileItemContainer().getResource().getType()) : null;
    }

    public ImageIcon getBonusImageIcon(ResourceType type) {
        return new ImageIcon(this.getBonusImage(type));
    }

    public Image getBorderImage(TileType type, Map.Direction direction, int x, int y) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage(key + ".border_" + (Object)((Object)direction) + (this.isEven(x, y) ? "_even" : "_odd") + ".image", this.scalingFactor);
    }

    public Image getCoatOfArmsImage(Nation nation) {
        return this.getCoatOfArmsImage(nation, this.scalingFactor);
    }

    public Image getCoatOfArmsImage(Nation nation, double scale) {
        return ResourceManager.getImage(nation.getId() + ".image", scale);
    }

    public ImageIcon getCoatOfArmsImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".image");
    }

    public Color getColor(Player player) {
        return ResourceManager.getColor(player.getNationID() + ".color");
    }

    public Image getCompoundTerrainImage(TileType type, double scale) {
        Image forestImage;
        Image terrainImage = this.getTerrainImage(type, 0, 0, scale);
        Image overlayImage = this.getOverlayImage(type, 0, 0, scale);
        Image image = forestImage = type.isForested() ? this.getForestImage(type, scale) : null;
        if (overlayImage == null && forestImage == null) {
            return terrainImage;
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int width = terrainImage.getWidth(null);
        int height = terrainImage.getHeight(null);
        if (overlayImage != null) {
            height = Math.max(height, overlayImage.getHeight(null));
        }
        if (forestImage != null) {
            height = Math.max(height, forestImage.getHeight(null));
        }
        BufferedImage compositeImage = gc.createCompatibleImage(width, height, 3);
        Graphics2D g = compositeImage.createGraphics();
        g.drawImage(terrainImage, 0, height - terrainImage.getHeight(null), null);
        if (overlayImage != null) {
            g.drawImage(overlayImage, 0, height - overlayImage.getHeight(null), null);
        }
        if (forestImage != null) {
            g.drawImage(forestImage, 0, height - forestImage.getHeight(null), null);
        }
        g.dispose();
        return compositeImage;
    }

    public int getCompoundTerrainImageHeight(TileType type) {
        Image terrain = this.getTerrainImage(type, 0, 0);
        int height = terrain.getHeight(null);
        if (type != null) {
            Image overlayImage = this.getOverlayImage(type, 0, 0);
            if (overlayImage != null) {
                height = Math.max(height, overlayImage.getHeight(null));
            }
            if (type.isForested()) {
                height = Math.max(height, this.getForestImage(type).getHeight(null));
            }
        }
        return height;
    }

    public Image getForestImage(TileType type) {
        return this.getForestImage(type, this.scalingFactor);
    }

    public Image getForestImage(TileType type, TileImprovementStyle riverStyle) {
        return this.getForestImage(type, riverStyle, this.scalingFactor);
    }

    public Image getForestImage(TileType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".forest", scale);
    }

    public Image getForestImage(TileType type, TileImprovementStyle riverStyle, double scale) {
        if (riverStyle == null) {
            return ResourceManager.getImage(type.getId() + ".forest", scale);
        }
        return ResourceManager.getImage(type.getId() + ".forest" + riverStyle.getMask(), scale);
    }

    public Image getFoundingFatherImage(FoundingFather father) {
        return ResourceManager.getImage(father.getId() + ".image");
    }

    public Image getGoodsImage(GoodsType goodsType) {
        return this.getGoodsImage(goodsType, this.scalingFactor);
    }

    public Image getGoodsImage(GoodsType goodsType, double scale) {
        return ResourceManager.getImage(goodsType.getId() + ".image", scale);
    }

    public Image getIndianSettlementChip(IndianSettlement is, String text) {
        Color background = this.getColor(is.getOwner());
        String key = "dynamic.indianSettlement." + text + "." + Integer.toHexString(background.getRGB());
        Image img = ResourceManager.getImage(key);
        if (img == null) {
            img = this.createChip(text, Color.BLACK, background, this.getForegroundColor(background));
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public ImageIcon getGoodsImageIcon(GoodsType goodsType) {
        return ResourceManager.getImageIcon(goodsType.getId() + ".image");
    }

    public Image getImage(FreeColGameObjectType type) {
        return ResourceManager.getImage(type.getId() + ".image", this.scalingFactor);
    }

    public Image getImage(FreeColGameObjectType type, double scale) {
        return ResourceManager.getImage(type.getId() + ".image", scale);
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        Image image = null;
        if (display == null) {
            return new ImageIcon();
        }
        if (display instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)display;
            try {
                image = this.getGoodsImage(goodsType);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for goods " + goodsType, e);
            }
        } else if (display instanceof Unit) {
            Unit unit = (Unit)display;
            try {
                image = this.getUnitImageIcon(unit).getImage();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for unit " + unit, e);
            }
        } else if (display instanceof UnitType) {
            UnitType unitType = (UnitType)display;
            try {
                image = this.getUnitImageIcon(unitType).getImage();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for unit " + unitType, e);
            }
        } else if (display instanceof Settlement) {
            Settlement settlement = (Settlement)display;
            try {
                image = this.getSettlementImage(settlement);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for settlement " + settlement.getId(), e);
            }
        } else if (display instanceof LostCityRumour) {
            try {
                image = this.getMiscImage(LOST_CITY_RUMOUR);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "could not find image for LCR", e);
            }
        } else if (display instanceof Player) {
            image = this.getCoatOfArmsImage(((Player)display).getNation());
        }
        if (image != null && small) {
            int width = image.getWidth(null) / 3 * 2;
            int height = image.getHeight(null) / 3 * 2;
            return new ImageIcon(image.getScaledInstance(width, height, 4));
        }
        return image == null ? null : new ImageIcon(image);
    }

    public Image getMiscImage(String id) {
        return this.getMiscImage(id, this.scalingFactor);
    }

    public Image getMiscImage(String id, double scale) {
        return ResourceManager.getImage(id, scale);
    }

    public ImageIcon getMiscImageIcon(String id) {
        return new ImageIcon(this.getMiscImage(id));
    }

    public Image getMissionChip(IndianSettlement is) {
        Unit missionary = is.getMissionary();
        if (missionary == null) {
            return null;
        }
        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
        Color background = this.getColor(missionary.getOwner());
        String key = "dynamic.mission." + (expert ? "expert" : "normal") + "." + Integer.toHexString(background.getRGB());
        Image img = ResourceManager.getImage(key, 1.0);
        if (img == null) {
            Color foreground = ResourceManager.getColor("mission." + (expert ? "expert" : "normal") + ".foreground.color");
            if (foreground == null) {
                foreground = expert ? Color.BLACK : Color.GRAY;
            }
            img = this.createChip("\u271d", Color.BLACK, background, foreground);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public Image getMonarchImage(Nation nation) {
        return ResourceManager.getImage(nation.getId() + ".monarch.image");
    }

    public ImageIcon getMonarchImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".monarch.image");
    }

    public Image getOccupationIndicatorChip(Unit unit, String text) {
        Color backgroundColor = this.getColor(unit.getOwner());
        Color foregroundColor = unit.getState() == Unit.UnitState.FORTIFIED ? Color.GRAY : this.getForegroundColor(backgroundColor);
        String key = "dynamic.occupationIndicator." + text + "." + Integer.toHexString(backgroundColor.getRGB());
        Image img = ResourceManager.getImage(key, this.getScalingFactor());
        if (img == null) {
            img = this.createChip(text, Color.BLACK, backgroundColor, foregroundColor);
            ResourceManager.addGameMapping(key, new ImageResource(img));
        }
        return img;
    }

    public Image getOverlayImage(TileType type, int x, int y) {
        return this.getOverlayImage(type, x, y, this.scalingFactor);
    }

    public Image getOverlayImage(TileType type, int x, int y, double scale) {
        String key = type.getId() + ".overlay" + (x + y) % 2 + ".image";
        if (ResourceManager.hasResource(key)) {
            return ResourceManager.getImage(key, scale);
        }
        return null;
    }

    private String getPathType(Unit unit) {
        if (unit.isNaval()) {
            return "naval";
        }
        if (unit.isMounted()) {
            return "horse";
        }
        if (unit.getType().hasSkill() || unit.isUndead()) {
            return "foot";
        }
        return "wagon";
    }

    public Image getPathImage(Unit u) {
        return u == null ? null : ResourceManager.getImage("path." + this.getPathType(u) + ".image");
    }

    public Image getPathNextTurnImage(Unit u) {
        return u == null ? null : ResourceManager.getImage("path." + this.getPathType(u) + ".nextTurn.image");
    }

    public Image getRiverImage(TileImprovementStyle style) {
        return this.getRiverImage(style, (double)this.scalingFactor);
    }

    public Image getRiverImage(TileImprovementStyle style, double scale) {
        return this.getRiverImage(style.getString(), scale);
    }

    public Image getRiverImage(String style, double scale) {
        return ResourceManager.getImage("model.tile.river" + style, scale);
    }

    public Image getRiverMouthImage(Map.Direction direction, int magnitude, int x, int y) {
        String key = "model.tile.delta_" + (Object)((Object)direction) + (magnitude == 1 ? "_small" : "_large");
        return ResourceManager.getImage(key, this.scalingFactor);
    }

    public ImageIcon getScaledBonusImageIcon(ResourceType type, float scale) {
        return new ImageIcon(this.getBonusImage(type, scale));
    }

    public ImageIcon getScaledGoodsImageIcon(GoodsType type, double scale) {
        return new ImageIcon(this.getGoodsImage(type, scale));
    }

    public ImageLibrary getScaledImageLibrary(float scalingFactor) throws FreeColException {
        return new ImageLibrary(scalingFactor);
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public Image getSettlementImage(Settlement settlement) {
        return this.getSettlementImage(settlement, (double)this.scalingFactor);
    }

    public Image getSettlementImage(Settlement settlement, double scale) {
        return ResourceManager.getImage(settlement.getImageKey(), scale);
    }

    public Image getSettlementImage(SettlementType settlementType) {
        return this.getSettlementImage(settlementType, (double)this.scalingFactor);
    }

    public Image getSettlementImage(SettlementType settlementType, double scale) {
        return ResourceManager.getImage(settlementType.getId() + ".image", scale);
    }

    public Image getStringImage(Graphics g, String text, Color color, Font font) {
        String key;
        Image img;
        if (color == null) {
            logger.warning("createStringImage called with color null");
            color = Color.WHITE;
        }
        if ((img = ResourceManager.getImage(key = "dynamic.stringImage." + text + "." + font.getFontName().replace(' ', '-') + "." + Integer.toString(font.getSize()) + "." + Integer.toHexString(color.getRGB()))) == null) {
            FontMetrics fm = g.getFontMetrics(font);
            BufferedImage bi = new BufferedImage(fm.stringWidth(text) + 4, fm.getMaxAscent() + fm.getMaxDescent(), 2);
            Graphics2D big = bi.createGraphics();
            big.setColor(color);
            big.setFont(font);
            big.drawString(text, 2, fm.getMaxAscent());
            int textColor = color.getRGB();
            int borderColor = this.getStringBorderColor(color).getRGB();
            for (int biX = 0; biX < bi.getWidth(); ++biX) {
                for (int biY = 0; biY < bi.getHeight(); ++biY) {
                    int r = bi.getRGB(biX, biY);
                    if (r == textColor) continue;
                    for (int cX = -1; cX <= 1; ++cX) {
                        for (int cY = -1; cY <= 1; ++cY) {
                            if (biX + cX < 0 || biY + cY < 0 || biX + cX >= bi.getWidth() || biY + cY >= bi.getHeight() || bi.getRGB(biX + cX, biY + cY) != textColor) continue;
                            bi.setRGB(biX, biY, borderColor);
                        }
                    }
                }
            }
            ResourceManager.addGameMapping(key, new ImageResource(bi));
            img = ResourceManager.getImage(key);
        }
        return img;
    }

    public Image getTerrainImage(TileType type, int x, int y) {
        return this.getTerrainImage(type, x, y, this.scalingFactor);
    }

    public Image getTerrainImage(TileType type, int x, int y, double scale) {
        String key = type == null ? "model.tile.unexplored" : type.getId();
        return ResourceManager.getImage(key + ".center" + (this.isEven(x, y) ? "0" : "1") + ".image", scale);
    }

    public ImageIcon getUnitImageIcon(Unit unit) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(Unit unit, double scale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), unit.hasNativeEthnicity(), false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, double scale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, false, false, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role) {
        return this.getUnitImageIcon(unitType, role, false, false, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean grayscale) {
        return this.getUnitImageIcon(unitType, role, false, grayscale, this.scalingFactor);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean nativeEthnicity, boolean grayscale, double scale) {
        Image image;
        if (unitType.getId().equals("model.unit.indianConvert") || unitType.getId().equals("model.unit.brave")) {
            nativeEthnicity = false;
        } else {
            for (Map.Entry<String, Boolean> entry : unitType.getRequiredAbilities().entrySet()) {
                if (!entry.getKey().equals("model.ability.native") || !entry.getValue().booleanValue()) continue;
                nativeEthnicity = false;
            }
        }
        String key = unitType.getId() + (role == Unit.Role.DEFAULT ? "" : "." + role.getId()) + (nativeEthnicity ? ".native" : "") + ".image";
        if (!ResourceManager.hasResource(key) && nativeEthnicity) {
            key = unitType.getId() + (role == Unit.Role.DEFAULT ? "" : "." + role.getId()) + ".image";
        }
        Image image2 = image = grayscale ? ResourceManager.getGrayscaleImage(key, scale) : ResourceManager.getImage(key, scale);
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean grayscale, double scale) {
        return this.getUnitImageIcon(unitType, role, false, grayscale, scale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, double scale) {
        return this.getUnitImageIcon(unitType, role, false, false, scale);
    }
}

