/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.CanvasMouseListener;
import net.sf.freecol.client.gui.CanvasMouseMotionListener;
import net.sf.freecol.client.gui.FreeColFrame;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.WindowedFrame;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.FreeColMenuBar;
import net.sf.freecol.client.gui.menu.InGameMenuBar;
import net.sf.freecol.client.gui.menu.MapEditorMenuBar;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.CornerMapControls;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MiniMap;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUI {
    private static final Logger logger = Logger.getLogger(GUI.class.getName());
    public static final String COPYRIGHT = "Copyright (C) 2002-2012   The FreeCol Team";
    public static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    public static final String REVISION = "$Revision: 10427 $";
    private static final int DEFAULT_WINDOW_SPACE = 50;
    public static final int MOVE_UNITS_MODE = 0;
    public static final int VIEW_TERRAIN_MODE = 1;
    private FreeColClient freeColClient;
    private GraphicsDevice gd;
    private FreeColFrame frame;
    private Canvas canvas;
    private MapViewer mapViewer;
    private MapControls mapControls;
    private MapViewer colonyTileGUI;
    private ImageLibrary imageLibrary;
    private SoundPlayer soundPlayer;
    private boolean windowed;
    private Rectangle windowBounds;
    private JWindow splash;

    public GUI(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.imageLibrary = new ImageLibrary();
    }

    public void activateGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (this.mapViewer.isGotoStarted()) {
            this.mapViewer.stopGoto();
        } else {
            Tile tile;
            this.mapViewer.startGoto();
            Point pt = this.canvas.getMousePosition();
            if (pt != null && (tile = this.mapViewer.convertToMapTile(pt.x, pt.y)) != null && unit.getTile() != tile) {
                this.mapViewer.setGotoPath(unit.findPath(tile));
            }
        }
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null;
    }

    public void centerActiveUnit() {
        this.mapViewer.centerActiveUnit();
    }

    public void changeWindowedMode(boolean windowed) {
        JMenuBar menuBar = null;
        if (this.frame != null) {
            menuBar = this.frame.getJMenuBar();
            if (this.frame instanceof WindowedFrame) {
                this.windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.setWindowed(windowed);
        this.frame = FreeColFrame.createFreeColFrame(this.freeColClient, this.canvas, this.gd, windowed);
        this.frame.setJMenuBar(menuBar);
        this.frame.setCanvas(this.canvas);
        this.frame.updateBounds(this.getWindowBounds());
        this.mapViewer.forceReposition();
        this.canvas.updateSizes();
        this.frame.setVisible(true);
    }

    public void closeMainPanel() {
        this.canvas.closeMainPanel();
    }

    public void closeMenus() {
        this.canvas.closeMenus();
    }

    public void closeStatusPanel() {
        this.canvas.closeStatusPanel();
    }

    public boolean containsInGameComponents() {
        return this.canvas.containsInGameComponents();
    }

    public Dimension determineWindowSize() {
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension size = new Dimension(bounds.width - 50, bounds.height - 50);
        return size;
    }

    public void displayChat(String senderNme, String message, boolean privateChat) {
        this.canvas.displayChat(senderNme, message, privateChat);
    }

    public void displayChatMessage(Player player, String message, boolean privateChat) {
        this.mapViewer.addMessage(new GUIMessage(player.getName() + ": " + message, this.imageLibrary.getColor(player)));
        this.canvas.repaint(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
    }

    public void displayColonyTile(Graphics2D g, Tile tile, Colony colony) {
        this.colonyTileGUI.displayColonyTile(g, tile, colony);
    }

    public void displaySplashScreen(String splashFilename) {
        this.splash = null;
        if (splashFilename != null) {
            try {
                Image im = Toolkit.getDefaultToolkit().getImage(splashFilename);
                this.splash = new JWindow();
                this.splash.getContentPane().add(new JLabel(new ImageIcon(im)));
                this.splash.pack();
                Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
                this.splash.setLocation(center.x - this.splash.getWidth() / 2, center.y - this.splash.getHeight() / 2);
                this.splash.setVisible(true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Splash fail", e);
                this.splash = null;
            }
        }
    }

    public void errorMessage(String messageId) {
        this.canvas.errorMessage(messageId);
    }

    public void errorMessage(String messageID, String message) {
        this.canvas.errorMessage(messageID, message);
    }

    public void executeWithUnitOutForAnimation(Unit unit, Tile sourceTile, OutForAnimationCallback r) {
        this.mapViewer.executeWithUnitOutForAnimation(unit, sourceTile, r);
    }

    public Unit getActiveUnit() {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getActiveUnit();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public MapViewer getColonyTileGUI() {
        return this.colonyTileGUI;
    }

    public int getCurrentViewMode() {
        return this.mapViewer.getView();
    }

    public Tile getFocus() {
        if (this.mapViewer == null) {
            return null;
        }
        return this.mapViewer.getFocus();
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        return this.imageLibrary.getImageIcon(display, small);
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.canvas.getLoadingSavegameDialog();
    }

    public float getMapScale() {
        return this.mapViewer.getMapScale();
    }

    public MapViewer getMapViewer() {
        return this.mapViewer;
    }

    public Tile getSelectedTile() {
        return this.mapViewer.getSelectedTile();
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public Rectangle getTileBounds(Tile tile) {
        return this.mapViewer.getTileBounds(tile);
    }

    public Point getTilePosition(Tile tile) {
        return this.mapViewer.getTilePosition(tile);
    }

    public Rectangle getWindowBounds() {
        return this.windowBounds;
    }

    public void hideSplashScreen() {
        if (this.splash != null) {
            this.splash.setVisible(false);
            this.splash.dispose();
        }
    }

    public boolean isClientOptionsDialogShowing() {
        return this.canvas != null && !this.canvas.isClientOptionsDialogShowing();
    }

    public boolean isMapboardActionsEnabled() {
        return this.canvas != null && this.canvas.isMapboardActionsEnabled();
    }

    public boolean isShowingSubPanel() {
        return this.canvas.isShowingSubPanel();
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public boolean onScreen(Tile tileToCheck) {
        return this.mapViewer.onScreen(tileToCheck);
    }

    public void paintImmediatelyCanvasIn(Rectangle rectangle) {
        this.canvas.paintImmediately(rectangle);
    }

    public void paintImmediatelyCanvasInItsBounds() {
        this.canvas.paintImmediately(this.canvas.getBounds());
    }

    public void playSound(String sound) {
        if (this.canPlaySound()) {
            if (sound == null) {
                this.soundPlayer.stop();
            } else {
                File file = ResourceManager.getAudio(sound);
                if (file != null) {
                    this.soundPlayer.playOnce(file);
                }
                logger.finest((file == null ? "Could not load" : "Playing") + " sound: " + sound);
            }
        }
    }

    public void quit() throws Exception {
        if (!this.isWindowed()) {
            this.gd.setFullScreenWindow(null);
        }
    }

    public void refresh() {
        this.mapViewer.forceReposition();
        this.canvas.refresh();
    }

    public void refreshPlayersTable() {
        this.canvas.refreshPlayersTable();
    }

    public void refreshTile(Tile t) {
        if (t.getX() >= 0 && t.getY() >= 0) {
            this.canvas.repaint(this.mapViewer.getTileBounds(t));
        }
    }

    public void removeFromCanvas(Component component) {
        this.canvas.remove(component);
    }

    public void removeInGameComponents() {
        this.canvas.removeInGameComponents();
    }

    public void requestFocusForSubPanel() {
        this.canvas.getShowingSubPanel().requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.canvas.requestFocusInWindow();
    }

    public void resetMenuBar() {
        JMenuBar menuBar = this.frame.getJMenuBar();
        if (menuBar != null) {
            ((FreeColMenuBar)menuBar).reset();
        }
    }

    public void returnToTitle() {
        this.canvas.returnToTitle();
    }

    public void scaleMap(float delta) {
        this.mapViewer.scaleMap(delta);
        this.refresh();
    }

    public void setActiveUnit(Unit unitToActivate) {
        this.mapViewer.setActiveUnit(unitToActivate);
        if (unitToActivate != null && !this.freeColClient.getMyPlayer().owns(unitToActivate)) {
            this.canvas.repaint(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        }
    }

    public void setFocus(Tile tileToFocus) {
        this.mapViewer.setFocus(tileToFocus);
    }

    public void setFocusImmediately(Tile tileToFocus) {
        this.mapViewer.setFocusImmediately(tileToFocus);
    }

    public boolean setSelectedTile(Tile newTileToSelect, boolean clearGoToOrders) {
        return this.mapViewer.setSelectedTile(newTileToSelect, clearGoToOrders);
    }

    public void setupInGameMenuBar() {
        this.frame.setJMenuBar(new InGameMenuBar(this.freeColClient, this));
        this.frame.paintAll(this.canvas.getGraphics());
    }

    public void setupMenuBarToNull() {
        this.frame.setJMenuBar(null);
    }

    public void setUpMouseListenersForCanvas() {
        this.canvas.addMouseListener(new CanvasMouseListener(this.freeColClient, this.canvas, this.mapViewer));
        this.canvas.addMouseMotionListener(new CanvasMouseMotionListener(this.freeColClient, this.mapViewer));
    }

    public void setWindowed(boolean windowed) {
        this.windowed = windowed;
    }

    public void showAboutPanel() {
        this.canvas.showAboutPanel();
    }

    public Canvas.ScoutIndianSettlementAction showArmedUnitIndianSettlementDialog(IndianSettlement settlement) {
        return this.canvas.showArmedUnitIndianSettlementDialog(settlement);
    }

    public Canvas.BoycottAction showBoycottedGoodsDialog(Goods goods, Europe europe) {
        return this.canvas.showBoycottedGoodsDialog(goods, europe);
    }

    public void showBuildQueuePanel(Colony colony) {
        this.canvas.showBuildQueuePanel(colony);
    }

    public void showBuildQueuePanel(Colony colony, Runnable callBack) {
        this.canvas.showBuildQueuePanel(colony, callBack);
    }

    public Canvas.BuyAction showBuyDialog(Unit unit, Settlement settlement, Goods goods, int gold, boolean canBuy) {
        return this.canvas.showBuyDialog(unit, settlement, goods, gold, canBuy);
    }

    public List<Goods> showCaptureGoodsDialog(Unit winner, List<Goods> loot) {
        return this.canvas.showCaptureGoodsDialog(winner, loot);
    }

    public void showChatPanel() {
        this.canvas.showChatPanel();
    }

    public <T> T showChoiceDialog(Tile tile, String text, String cancelText, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, text, cancelText, choices);
    }

    public Monarch.MonarchAction showChoiceMonarchActionDialog(String monarchTitle, List<ChoiceItem<Monarch.MonarchAction>> actions) {
        return this.canvas.showChoiceMonarchActionDialog(monarchTitle, actions);
    }

    public FoundingFather showChooseFoundingFatherDialog(List<ChoiceItem<FoundingFather>> fathers, String fatherTitle) {
        return this.canvas.showChooseFoundingFatherDialog(fathers, fatherTitle);
    }

    public FoundingFather showChooseFoundingFatherDialog(List<FoundingFather> ffs) {
        return this.canvas.showChooseFoundingFatherDialog(ffs);
    }

    public Canvas.ClaimAction showClaimDialog(Tile tile, Player player, int price, Player owner, boolean canAccept) {
        return this.canvas.showClaimDialog(tile, player, price, owner, canAccept);
    }

    public OptionGroup showClientOptionsDialog() {
        return this.canvas.showClientOptionsDialog();
    }

    public ColonyPanel showColonyPanel(Colony colony) {
        return this.canvas.showColonyPanel(colony);
    }

    public void showColonyPanel(Colony colony, Runnable callback) {
        this.canvas.showColonyPanel(colony, callback);
    }

    public void showColopediaPanel(String nodeId) {
        this.canvas.showColopediaPanel(nodeId);
    }

    public void showCompactLabourReport() {
        this.canvas.showCompactLabourReport();
    }

    public void showCompactLabourReport(LabourData.UnitData unitData) {
        this.canvas.showCompactLabourReport(unitData);
    }

    public List<String> showConfirmDeclarationDialog() {
        return this.canvas.showConfirmDeclarationDialog();
    }

    public boolean showConfirmDialog(String text, String okText, String cancelText) {
        return this.canvas.showConfirmDialog(text, okText, cancelText);
    }

    public boolean showConfirmDialog(Tile tile, ModelMessage[] messages, String okText, String cancelText) {
        return this.canvas.showConfirmDialog(tile, messages, okText, cancelText);
    }

    public boolean showConfirmDialog(Tile tile, StringTemplate text, String okText, String cancelText) {
        return this.canvas.showConfirmDialog(tile, text, okText, cancelText);
    }

    public void showDeclarationDialog() {
        this.canvas.showDeclarationDialog();
    }

    public void showDifficultyDialog(boolean editable) {
        this.canvas.showDifficultyDialog(editable);
    }

    public OptionGroup showDifficultyDialog(Specification specification) {
        return this.canvas.showDifficultyDialog(specification);
    }

    public List<Goods> showDumpCargoDialog(Unit unit) {
        return this.canvas.showDumpCargoDialog(unit);
    }

    public boolean showEditOptionDialog(Option option) {
        return this.canvas.showEditOptionDialog(option);
    }

    public int showEmigrationPanel(boolean fountainOfYouth) {
        return this.canvas.showEmigrationPanel(fountainOfYouth);
    }

    public boolean showEndTurnDialog(List<Unit> units) {
        return this.canvas.showEndTurnDialog(units);
    }

    public int showEuropeDialog(EuropePanel.EuropeAction europeAction) {
        return this.canvas.showEuropeDialog(europeAction);
    }

    public void showEuropePanel() {
        this.canvas.showEuropePanel();
    }

    public void showEventPanel(Canvas.EventType type) {
        this.canvas.showEventPanel(type);
    }

    public void showFindSettlementDialog() {
        this.canvas.showFindSettlementDialog();
    }

    public void showGameOptionsDialog(boolean editable, boolean loadCustomOptions) {
        this.canvas.showGameOptionsDialog(editable, loadCustomOptions);
    }

    public void showHighScoresPanel(String messageId) {
        this.canvas.showHighScoresPanel(messageId);
    }

    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        this.canvas.showIndianSettlementPanel(indianSettlement);
    }

    public Canvas.TradeAction showIndianSettlementTradeDialog(Settlement settlement, boolean canBuy, boolean canSell, boolean canGift) {
        return this.canvas.showIndianSettlementTradeDialog(settlement, canBuy, canSell, canGift);
    }

    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        this.canvas.showInformationMessage(displayObject, messageId);
    }

    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        this.canvas.showInformationMessage(displayObject, template);
    }

    public void showInformationMessage(ModelMessage message) {
        this.canvas.showInformationMessage(message);
    }

    public void showInformationMessage(String messageId) {
        this.canvas.showInformationMessage(messageId);
    }

    public void showInformationMessage(StringTemplate template) {
        this.canvas.showInformationMessage(template);
    }

    public String showInputDialog(Tile tile, StringTemplate text, String defaultValue, String okText, String cancelText, boolean rejectEmptyString) {
        return this.canvas.showInputDialog(tile, text, defaultValue, okText, cancelText, rejectEmptyString);
    }

    public File showLoadDialog(File directory) {
        return this.canvas.showLoadDialog(directory);
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        return this.canvas.showLoadDialog(directory, fileFilters);
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        return this.canvas.showLoadingSavegameDialog(publicServer, singlePlayer);
    }

    public void showLogFilePanel() {
        this.canvas.showLogFilePanel();
    }

    public void showMainPanel() {
        this.canvas.showMainPanel();
    }

    public OptionGroup showMapGeneratorOptionsDialog(OptionGroup mgo, boolean editable, boolean loadCustomOptions) {
        return this.canvas.showMapGeneratorOptionsDialog(mgo, editable, loadCustomOptions);
    }

    public Dimension showMapSizeDialog() {
        return this.canvas.showMapSizeDialog();
    }

    public void showModelMessages(ModelMessage ... modelMessages) {
        this.canvas.showModelMessages(modelMessages);
    }

    public boolean showMonarchPanelDialog(Monarch.MonarchAction action, StringTemplate replace) {
        return this.canvas.showMonarchPanelDialog(action, replace);
    }

    public DiplomaticTrade showNegotiationDialog(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        return this.canvas.showNegotiationDialog(unit, settlement, agreement);
    }

    public void showNewPanel() {
        this.canvas.showNewPanel();
    }

    public void showNewPanel(Specification specification) {
        this.canvas.showNewPanel(specification);
    }

    public boolean showPreCombatDialog(FreeColGameObject attacker, FreeColGameObject defender, Tile tile) {
        return this.canvas.showPreCombatDialog(attacker, defender, tile);
    }

    public void showReportCargoPanel() {
        this.canvas.showReportCargoPanel();
    }

    public void showReportColonyPanel() {
        this.canvas.showReportColonyPanel();
    }

    public void showReportContinentalCongressPanel() {
        this.canvas.showReportContinentalCongressPanel();
    }

    public void showReportEducationPanel() {
        this.canvas.showReportEducationPanel();
    }

    public void showReportExplorationPanel() {
        this.canvas.showReportExplorationPanel();
    }

    public void showReportForeignAffairPanel() {
        this.canvas.showReportForeignAffairPanel();
    }

    public void showReportHistoryPanel() {
        this.canvas.showReportHistoryPanel();
    }

    public void showReportIndianPanel() {
        this.canvas.showReportIndianPanel();
    }

    public void showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        this.canvas.showReportLabourDetailPanel(unitType, data, unitCount, colonies);
    }

    public void showReportLabourPanel() {
        this.canvas.showReportLabourPanel();
    }

    public void showReportMilitaryPanel() {
        this.canvas.showReportMilitaryPanel();
    }

    public void showReportNavalPanel() {
        this.canvas.showReportNavalPanel();
    }

    public void showReportProductionPanel() {
        this.canvas.showReportProductionPanel();
    }

    public void showReportReligiousPanel() {
        this.canvas.showReportReligiousPanel();
    }

    public void showReportRequirementsPanel() {
        this.canvas.showReportRequirementsPanel();
    }

    public void showReportTradePanel() {
        this.canvas.showReportTradePanel();
    }

    public void showReportTurnPanel(ModelMessage ... messages) {
        this.canvas.showReportTurnPanel(messages);
    }

    public File showSaveDialog(File directory, String defaultName) {
        return this.canvas.showSaveDialog(directory, defaultName);
    }

    public File showSaveDialog(File directory, String standardName, FileFilter[] fileFilters, String defaultName) {
        return this.canvas.showSaveDialog(directory, standardName, fileFilters, defaultName);
    }

    public Canvas.ScoutColonyAction showScoutForeignColonyDialog(Colony colony, Unit unit, boolean canNegotiate) {
        return this.canvas.showScoutForeignColonyDialog(colony, unit, canNegotiate);
    }

    public Canvas.ScoutIndianSettlementAction showScoutIndianSettlementDialog(IndianSettlement settlement, String number) {
        return this.canvas.showScoutIndianSettlementDialog(settlement, number);
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.canvas.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    public Location showSelectDestinationDialog(Unit unit) {
        return this.canvas.showSelectDestinationDialog(unit);
    }

    public Canvas.SellAction showSellDialog(Unit unit, Settlement settlement, Goods goods, int gold) {
        return this.canvas.showSellDialog(unit, settlement, goods, gold);
    }

    public void showServerListPanel(String username, List<ServerInfo> serverList) {
        this.canvas.showServerListPanel(username, serverList);
    }

    public <T> T showSimpleChoiceDialog(Tile tile, String text, String cancelText, List<T> objects) {
        return this.canvas.showSimpleChoiceDialog(tile, text, cancelText, objects);
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        this.canvas.showStartGamePanel(game, player, singlePlayerMode);
    }

    public void showStatisticsPanel() {
        this.canvas.showStatisticsPanel();
    }

    public void showStatusPanel(String message) {
        this.canvas.showStatusPanel(message);
    }

    public void showTilePanel(Tile tile) {
        this.canvas.showTilePanel(tile);
    }

    public void showTilePopUpAtSelectedTile() {
        this.canvas.showTilePopup(this.getSelectedTile(), this.mapViewer.getCursor().getCanvasX(), this.mapViewer.getCursor().getCanvasY());
    }

    public boolean showTradeRouteDialog(Unit unit) {
        return this.canvas.showTradeRouteDialog(unit);
    }

    public boolean showTradeRouteInputDialog(TradeRoute newRoute) {
        return this.canvas.showTradeRouteInputDialog(newRoute);
    }

    public Canvas.MissionaryAction showUseMissionaryDialog(Unit unit, IndianSettlement settlement, boolean canEstablish, boolean canDenounce) {
        return this.canvas.showUseMissionaryDialog(unit, settlement, canEstablish, canDenounce);
    }

    public void showVictoryPanel() {
        this.canvas.showVictoryPanel();
    }

    public boolean showWarehouseDialog(Colony colony) {
        return this.canvas.showWarehouseDialog(colony);
    }

    public void showWorkProductionPanel(Unit unit) {
        this.canvas.showWorkProductionPanel(unit);
    }

    public void startGUI(Dimension innerWindowSize, boolean sound, boolean showOpeningVideo, boolean loadGame) {
        ClientOptions opts = this.freeColClient.getClientOptions();
        if (sound) {
            AudioMixerOption amo = (AudioMixerOption)opts.getOption("model.option.audioMixer");
            PercentageOption volume = (PercentageOption)opts.getOption("model.option.audioVolume");
            try {
                this.soundPlayer = new SoundPlayer(amo, volume);
            }
            catch (Exception e) {
                this.soundPlayer = null;
                logger.log(Level.WARNING, "Sound disabled", e);
            }
        } else {
            this.soundPlayer = null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.info("It seems that the GraphicsEnvironment is headless!");
        }
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.isWindowed()) {
            if (!this.gd.isFullScreenSupported()) {
                String fullscreenNotSupported = "\nIt seems that full screen mode is not fully supported for this\nGraphicsDevice. Please try the \"--windowed\" option if you\nexperienceany graphical problems while running FreeCol.";
                logger.info(fullscreenNotSupported);
                System.out.println(fullscreenNotSupported);
            }
            Rectangle bounds = this.gd.getDefaultConfiguration().getBounds();
            innerWindowSize = new Dimension(bounds.width - bounds.x, bounds.height - bounds.y);
        }
        String pmoffscreen = "sun.java2d.pmoffscreen";
        BooleanOption usePixmaps = (BooleanOption)opts.getOption("model.option.usePixmaps");
        String pmoffscreenValue = System.getProperty("sun.java2d.pmoffscreen");
        if (pmoffscreenValue == null) {
            System.setProperty("sun.java2d.pmoffscreen", usePixmaps.getValue().toString());
            logger.info("sun.java2d.pmoffscreen using client option: " + usePixmaps.getValue().toString());
        } else {
            usePixmaps.setValue(new Boolean(pmoffscreenValue));
            logger.info("sun.java2d.pmoffscreen overrides client option: " + pmoffscreenValue);
        }
        usePixmaps.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String newValue = e.getNewValue().toString();
                System.setProperty("sun.java2d.pmoffscreen", newValue);
                logger.info("Set sun.java2d.pmoffscreen to: " + newValue);
            }
        });
        this.mapViewer = new MapViewer(this.freeColClient, this, innerWindowSize, this.imageLibrary);
        this.canvas = new Canvas(this.freeColClient, this, innerWindowSize, this.mapViewer);
        this.colonyTileGUI = new MapViewer(this.freeColClient, this, innerWindowSize, this.imageLibrary);
        this.changeWindowedMode(this.isWindowed());
        this.frame.setIconImage(ResourceManager.getImage("FrameIcon.image"));
        LanguageOption o = (LanguageOption)this.freeColClient.getClientOptions().getOption("model.option.languageOption");
        if (o != null) {
            o.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (((LanguageOption.Language)e.getNewValue()).getKey().equals("automatic")) {
                        GUI.this.showInformationMessage("autodetectLanguageSelected");
                    } else {
                        Locale l = ((LanguageOption.Language)e.getNewValue()).getLocale();
                        Messages.setMessageBundle(l);
                        Messages.setModMessageBundle(l);
                        GUI.this.showInformationMessage(StringTemplate.template("newLanguageSelected").addName("%language%", l.getDisplayName()));
                    }
                }
            });
        }
        if (showOpeningVideo && !loadGame) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUI.this.canvas.showOpeningVideoPanel();
                }
            });
        } else {
            if (!loadGame) {
                this.showMainPanel();
            }
            this.playSound("sound.intro.general");
        }
        this.mapViewer.startCursorBlinking();
    }

    public void startMapEditorGUI() {
        this.scaleMap(2.0f);
        this.setupMapEditorMenuBar();
        this.canvas.showMapEditorTransformPanel();
        this.setupMouseListenerForMapEditor();
    }

    public void toggleViewMode() {
        this.mapViewer.toggleViewMode();
    }

    public boolean tryLeaveColony(Unit unit) {
        Colony colony = unit.getColony();
        String message = colony.getReducePopulationMessage();
        if (message != null) {
            this.showInformationMessage(message);
            return false;
        }
        return this.confirmAbandonEducation(unit, true);
    }

    public boolean confirmAbandonEducation(Unit unit, boolean checkStudent) {
        StringTemplate message = unit.getAbandonEducationMessage(checkStudent);
        return message == null || this.showConfirmDialog(unit.getTile(), message, "abandonEducation.yes", "abandonEducation.no");
    }

    public void updateGameOptions() {
        this.canvas.updateGameOptions();
    }

    public void updateMapGeneratorOptions() {
        this.canvas.updateMapGeneratorOptions();
    }

    public void updateMenuBar() {
        if (this.frame != null && this.frame.getJMenuBar() != null) {
            ((FreeColMenuBar)this.frame.getJMenuBar()).update();
        }
    }

    private void setupMapEditorMenuBar() {
        this.frame.setJMenuBar(new MapEditorMenuBar(this.freeColClient, this));
    }

    private void setupMouseListenerForMapEditor() {
        CanvasMapEditorMouseListener listener = new CanvasMapEditorMouseListener(this.freeColClient, this, this.canvas);
        this.canvas.addMouseListener(listener);
        this.canvas.addMouseMotionListener(listener);
    }

    public Parameters showParametersDialog() {
        return this.canvas.showParametersDialog();
    }

    public Dimension showScaleMapSizeDialog() {
        return this.canvas.showScaleMapSizeDialog();
    }

    public void showMapControls(boolean value) {
        if (value && this.freeColClient.isInGame()) {
            if (this.mapControls == null) {
                try {
                    String className = this.freeColClient.getClientOptions().getString("model.option.mapControls");
                    Class<?> controls = Class.forName("net.sf.freecol.client.gui.panel." + className);
                    this.mapControls = (MapControls)controls.getConstructor(FreeColClient.class, GUI.class).newInstance(this.freeColClient, this);
                }
                catch (Exception e) {
                    this.mapControls = new CornerMapControls(this.freeColClient, this);
                }
            }
            this.mapControls.update();
        }
        if (this.mapControls != null) {
            if (value) {
                if (!this.mapControls.isShowing()) {
                    this.mapControls.addToComponent(this.canvas);
                }
                this.mapControls.update();
            } else if (this.mapControls.isShowing()) {
                this.mapControls.removeFromComponent(this.canvas);
            }
        }
    }

    public void updateMapControls() {
        if (this.mapControls != null) {
            this.mapControls.update();
        }
    }

    public void updateMapControlsInCanvas() {
        if (this.mapControls != null && this.mapControls.isShowing()) {
            this.mapControls.removeFromComponent(this.canvas);
            this.mapControls.addToComponent(this.canvas);
        }
    }

    public void zoomInMapControls() {
        this.mapControls.zoomIn();
    }

    public void zoomOutMapControls() {
        this.mapControls.zoomOut();
    }

    public boolean canZoomInMapControls() {
        return this.mapControls != null && this.mapControls.canZoomInMapControls();
    }

    public boolean canZoomOutMapControls() {
        return this.mapControls != null && this.mapControls.canZoomOutMapControls();
    }

    public int getAnimationSpeed(Unit unit) {
        String key = this.freeColClient.getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
        return this.freeColClient.getClientOptions().getInteger(key);
    }

    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        Animations.unitAttack(this, attacker, defender, attackerTile, defenderTile, success);
    }

    public void animateUnitMove(Unit unit, Tile sourceTile, Tile destinationTile) {
        Animations.unitMove(this, unit, sourceTile, destinationTile);
    }

    public BufferedImage createMiniMapThumbNail() {
        MiniMap miniMap = new MiniMap(this.freeColClient, this);
        miniMap.setTileSize(24);
        int width = this.freeColClient.getGame().getMap().getWidth() * 24 + 12;
        int height = this.freeColClient.getGame().getMap().getHeight() * 24 / 4;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        miniMap.paintMap(g2d);
        double scaledWidth = Math.min(64 * width / height, 128);
        BufferedImage scaledImage = new BufferedImage((int)scaledWidth, 64, 2);
        scaledImage.createGraphics().drawImage(image, 0, 0, (int)scaledWidth, 64, null);
        return scaledImage;
    }
}

