/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class InGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(InGameInputHandler.class.getName());
    private Unit lastAnimatedUnit = null;

    public InGameInputHandler(FreeColClient freeColClient, GUI gui) {
        super(freeColClient, gui);
    }

    public Element handle(Connection connection, Element element) {
        Element reply;
        if (element == null) {
            throw new RuntimeException("Received empty (null) message!");
        }
        String type = element.getTagName();
        logger.log(Level.FINEST, "Received message: " + type);
        if (type.equals("update")) {
            reply = this.update(element);
        } else if (type.equals("remove")) {
            reply = this.remove(element);
        } else if (type.equals("animateMove")) {
            reply = this.animateMove(element);
        } else if (type.equals("animateAttack")) {
            reply = this.animateAttack(element);
        } else if (type.equals("setCurrentPlayer")) {
            reply = this.setCurrentPlayer(element);
        } else if (type.equals("newTurn")) {
            reply = this.newTurn(element);
        } else if (type.equals("setDead")) {
            reply = this.setDead(element);
        } else if (type.equals("gameEnded")) {
            reply = this.gameEnded(element);
        } else if (type.equals("chat")) {
            reply = this.chat(element);
        } else if (type.equals("disconnect")) {
            reply = this.disconnect(element);
        } else if (type.equals("error")) {
            reply = this.error(element);
        } else if (type.equals("chooseFoundingFather")) {
            reply = this.chooseFoundingFather(element);
        } else if (type.equals("indianDemand")) {
            reply = this.indianDemand(element);
        } else if (type.equals("spyResult")) {
            reply = this.spyResult(element);
        } else if (type.equals("reconnect")) {
            reply = this.reconnect(element);
        } else if (type.equals("setAI")) {
            reply = this.setAI(element);
        } else if (type.equals("monarchAction")) {
            reply = this.monarchAction(element);
        } else if (type.equals("setStance")) {
            reply = this.setStance(element);
        } else if (type.equals("diplomacy")) {
            reply = this.diplomacy(element);
        } else if (type.equals("addPlayer")) {
            reply = this.addPlayer(element);
        } else if (type.equals("addObject")) {
            reply = this.addObject(element);
        } else if (type.equals("featureChange")) {
            reply = this.featureChange(element);
        } else if (type.equals("newLandName")) {
            reply = this.newLandName(element);
        } else if (type.equals("newRegionName")) {
            reply = this.newRegionName(element);
        } else if (type.equals("fountainOfYouth")) {
            reply = this.fountainOfYouth(element);
        } else if (type.equals("lootCargo")) {
            reply = this.lootCargo(element);
        } else if (type.equals("closeMenus")) {
            reply = this.closeMenus();
        } else if (type.equals("multiple")) {
            reply = this.multiple(connection, element);
        } else {
            logger.warning("Unsupported message type: " + type);
            return null;
        }
        logger.log(Level.FINEST, "Handled message: " + type + " replying with: " + (reply == null ? "null" : reply.getTagName()));
        final FreeColClient fcc = this.getFreeColClient();
        if (Boolean.TRUE.toString().equals(element.getAttribute("flush")) && fcc.currentPlayerIsMyPlayer()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    fcc.getInGameController().displayModelMessages(false);
                }
            });
        }
        return reply;
    }

    private Element reconnect(Element element) {
        logger.finest("Entered reconnect...");
        if (new ShowConfirmDialogSwingTask(null, StringTemplate.key("reconnect.text"), "reconnect.yes", "reconnect.no").confirm()) {
            logger.finest("User wants to reconnect, do it!");
            new ReconnectSwingTask().invokeLater();
        } else {
            logger.finest("No reconnect, quit.");
            this.getFreeColClient().quit();
        }
        return null;
    }

    public Element update(Element updateElement) {
        this.updateGameObjects(updateElement.getChildNodes());
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private void updateGameObjects(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String id = element.getAttribute("ID");
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            if (fcgo == null) {
                logger.warning("Update object not present in client: " + id);
                continue;
            }
            fcgo.readFromXMLElement(element);
        }
    }

    private Element remove(Element removeElement) {
        Game game = this.getGame();
        String ds = removeElement.getAttribute("divert");
        FreeColGameObject divert = game.getFreeColGameObject(ds);
        Player player = this.getFreeColClient().getMyPlayer();
        NodeList nodeList = removeElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String idString = element.getAttribute("ID");
            FreeColGameObject fcgo = game.getFreeColGameObject(idString);
            if (fcgo == null) {
                logger.warning("Could not find FreeColGameObject with ID: " + idString);
                continue;
            }
            if (divert != null) {
                player.divertModelMessages(fcgo, divert);
            }
            if (fcgo instanceof Unit) {
                Unit u = (Unit)fcgo;
                player.invalidateCanSeeTiles();
                if (u == this.gui.getActiveUnit()) {
                    this.gui.setActiveUnit(null);
                }
                player.removeUnit(u);
            }
            fcgo.fundamentalDispose();
        }
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private static Element selectElement(Element parent, String id) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            if (!id.equals(e.getAttribute("ID"))) continue;
            return e;
        }
        return null;
    }

    private static Unit selectUnitFromElement(Game game, Element element, String id) {
        Element e = InGameInputHandler.selectElement(element, id);
        Unit u = null;
        if (e != null && (u = new Unit(game, e)).getLocation() == null) {
            throw new IllegalStateException("NULL LOC: " + u);
        }
        return u;
    }

    private Element animateMove(Element element) {
        Tile newTile;
        Tile oldTile;
        Unit unit;
        FreeColClient client = this.getFreeColClient();
        if (client.isHeadless()) {
            return null;
        }
        Game game = this.getGame();
        String unitId = element.getAttribute("unit");
        if (unitId == null || (unit = game.getFreeColGameObject(unitId, Unit.class)) == null && (unit = InGameInputHandler.selectUnitFromElement(game, element, unitId)) == null) {
            throw new IllegalStateException("Animation for: " + client.getMyPlayer().getId() + " missing unit:" + unitId);
        }
        Player player = client.getMyPlayer();
        String oldTileId = element.getAttribute("oldTile");
        String newTileId = element.getAttribute("newTile");
        if (oldTileId == null || (oldTile = game.getFreeColGameObject(oldTileId, Tile.class)) == null) {
            throw new IllegalStateException("Animation for: " + player.getId() + " missing oldTile: " + oldTileId);
        }
        if (newTileId == null || (newTile = game.getFreeColGameObject(newTileId, Tile.class)) == null) {
            throw new IllegalStateException("Animation for: " + player.getId() + " missing newTile: " + newTileId);
        }
        if (this.gui.getAnimationSpeed(unit) > 0) {
            try {
                new UnitMoveAnimationCanvasSwingTask(unit, oldTile, newTile, unit != this.lastAnimatedUnit).invokeSpecial();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "UnitMoveAnimation", e);
            }
        } else if (!this.gui.onScreen(oldTile) && client.getClientOptions().getBoolean("model.option.alwaysCenter")) {
            this.gui.setFocus(oldTile);
        }
        this.lastAnimatedUnit = unit;
        return null;
    }

    private Element animateAttack(Element element) {
        FreeColClient client = this.getFreeColClient();
        if (client.isHeadless()) {
            return null;
        }
        Game game = this.getGame();
        String str = element.getAttribute("attacker");
        if (str == null) {
            logger.warning("animateAttack null attacker");
            return null;
        }
        Unit attacker = game.getFreeColGameObject(str, Unit.class);
        if (attacker == null && (attacker = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " incorrectly omitted attacker: " + str);
            return null;
        }
        str = element.getAttribute("defender");
        if (str == null) {
            logger.warning("animateAttack null defender");
            return null;
        }
        Unit defender = game.getFreeColGameObject(str, Unit.class);
        if (defender == null && (defender = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " incorrectly omitted defender: " + str);
            return null;
        }
        str = element.getAttribute("attackerTile");
        if (str == null) {
            logger.warning("animateAttack null attackerTile");
            return null;
        }
        Tile attackerTile = game.getFreeColGameObject(str, Tile.class);
        if (attackerTile == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " can not find attacker tile: " + str);
            return null;
        }
        str = element.getAttribute("defenderTile");
        if (str == null) {
            logger.warning("animateAttack null defenderTile");
            return null;
        }
        Tile defenderTile = game.getFreeColGameObject(str, Tile.class);
        if (defenderTile == null) {
            logger.warning("Attack animation for: " + client.getMyPlayer().getId() + " can not find defender tile: " + str);
            return null;
        }
        boolean success = Boolean.parseBoolean(element.getAttribute("success"));
        try {
            new UnitAttackAnimationCanvasSwingTask(attacker, defender, attackerTile, defenderTile, success, attacker != this.lastAnimatedUnit).invokeSpecial();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Attack animation fail", e);
        }
        this.lastAnimatedUnit = attacker;
        return null;
    }

    private void takeTurn(Player player, boolean newTurn) {
        FreeColClient fcc = this.getFreeColClient();
    }

    private Element setCurrentPlayer(Element element) {
        FreeColClient fcc = this.getFreeColClient();
        Player player = fcc.getMyPlayer();
        Player newPlayer = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && fcc.currentPlayerIsMyPlayer()) {
            this.closeMenus();
        }
        FreeColDebugger.finishDebugRun(fcc, false);
        fcc.getInGameController().setCurrentPlayer(newPlayer);
        if (player == newPlayer) {
            try {
                List<Settlement> settlements = player.getSettlements();
                Tile defTile = (settlements.size() > 0 ? settlements.get(0).getTile() : player.getEntryLocation().getTile()).getSafeTile(null, null);
                player.resetIterators();
                fcc.getInGameController().nextActiveUnit(defTile);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Client new turn failure for " + player, e);
            }
        }
        fcc.updateActions();
        new RefreshCanvasSwingTask(true).invokeLater();
        return null;
    }

    private Element newTurn(Element element) {
        Game game = this.getGame();
        String turnString = element.getAttribute("turn");
        try {
            int turnNumber = Integer.parseInt(turnString);
            game.setTurn(new Turn(turnNumber));
        }
        catch (NumberFormatException e) {
            logger.warning("Bad turn in newTurn: " + turnString);
        }
        Turn currTurn = game.getTurn();
        if (this.getFreeColClient().getClientOptions().getBoolean("model.option.audioAlerts")) {
            this.gui.playSound("sound.event.alertSound");
        }
        if (currTurn.isFirstSeasonTurn()) {
            new ShowInformationMessageSwingTask(StringTemplate.template("twoTurnsPerYear").addName("%year%", Integer.toString(currTurn.getYear()))).invokeLater();
        }
        new UpdateMenuBarSwingTask().invokeLater();
        return null;
    }

    private Element setDead(Element element) {
        Player myPlayer;
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        if (player == (myPlayer = freeColClient.getMyPlayer())) {
            FreeColDebugger.finishDebugRun(freeColClient, true);
            if (freeColClient.isSinglePlayer()) {
                if (myPlayer.getPlayerType() != Player.PlayerType.UNDEAD && new ShowConfirmDialogSwingTask(null, StringTemplate.key("defeatedSinglePlayer.text"), "defeatedSinglePlayer.yes", "defeatedSinglePlayer.no").confirm()) {
                    freeColClient.askServer().enterRevengeMode();
                } else {
                    freeColClient.quit();
                }
            } else if (!new ShowConfirmDialogSwingTask(null, StringTemplate.key("defeated.text"), "defeated.yes", "defeated.no").confirm()) {
                freeColClient.quit();
            }
        } else {
            myPlayer.setStance(player, null);
        }
        return null;
    }

    private Element gameEnded(Element element) {
        Player winner;
        FreeColClient freeColClient = this.getFreeColClient();
        FreeColDebugger.finishDebugRun(freeColClient, true);
        String str = element.getAttribute("winner");
        Player player = winner = str == null ? null : this.getGame().getFreeColGameObject(str, Player.class);
        if (winner == freeColClient.getMyPlayer()) {
            new ShowVictoryPanelSwingTask().invokeLater();
        }
        return null;
    }

    private Element chat(Element element) {
        final Game game = this.getGame();
        final ChatMessage chatMessage = new ChatMessage(game, element);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameInputHandler.this.gui.displayChatMessage(chatMessage.getPlayer(game), chatMessage.getMessage(), chatMessage.isPrivate());
            }
        });
        return null;
    }

    private Element error(Element element) {
        try {
            new ShowErrorMessageSwingTask(element.getAttribute("messageID"), element.getAttribute("message")).invokeSpecial();
        }
        catch (Exception exception) {
            logger.warning("error() raised " + exception.toString());
        }
        return null;
    }

    private Element setAI(Element element) {
        Player p = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        p.setAI(Boolean.valueOf(element.getAttribute("ai")));
        return null;
    }

    private Element chooseFoundingFather(Element element) {
        ChooseFoundingFatherMessage message = new ChooseFoundingFatherMessage(this.getGame(), element);
        List<FoundingFather> ffs = message.getFathers();
        FoundingFather ff = this.gui.showChooseFoundingFatherDialog(ffs);
        if (ff != null) {
            message.setResult(ff);
            this.getFreeColClient().getMyPlayer().setCurrentFather(ff);
        }
        return message.toXMLElement();
    }

    private Element diplomacy(Element element) {
        Player player = this.getFreeColClient().getMyPlayer();
        DiplomacyMessage message = new DiplomacyMessage(this.getGame(), element);
        Unit unit = message.getUnit();
        if (unit == null) {
            logger.warning("Unit omitted from diplomacy message.");
            return null;
        }
        Settlement settlement = message.getSettlement();
        if (settlement == null) {
            logger.warning("Settlement omitted from diplomacy message.");
            return null;
        }
        Player other = player.owns(unit) ? settlement.getOwner() : unit.getOwner();
        String nation = Messages.message(other.getNationName());
        DiplomaticTrade agreement = message.getAgreement();
        switch (agreement.getStatus()) {
            case ACCEPT_TRADE: {
                new ShowInformationMessageSwingTask(StringTemplate.template("negotiationDialog.offerAccepted").addName("%nation%", nation)).show();
                new UpdateMenuBarSwingTask().invokeLater();
                break;
            }
            case REJECT_TRADE: {
                new ShowInformationMessageSwingTask(StringTemplate.template("negotiationDialog.offerRejected").addName("%nation%", nation)).show();
                new UpdateMenuBarSwingTask().invokeLater();
                break;
            }
            case PROPOSE_TRADE: {
                DiplomaticTrade ourAgreement = this.gui.showNegotiationDialog(unit, settlement, agreement);
                if (ourAgreement == null) {
                    agreement.setStatus(DiplomaticTrade.TradeStatus.REJECT_TRADE);
                } else {
                    agreement = ourAgreement;
                }
                return new DiplomacyMessage(unit, settlement, agreement).toXMLElement();
            }
            default: {
                logger.warning("Bogus trade status: " + (Object)((Object)agreement.getStatus()));
            }
        }
        return null;
    }

    private Element indianDemand(Element element) {
        boolean accepted;
        ModelMessage m;
        IndianDemandMessage message;
        Player player;
        block16: {
            int opt;
            String nation;
            Goods goods;
            Colony colony;
            Unit unit;
            block15: {
                Game game = this.getGame();
                player = this.getFreeColClient().getMyPlayer();
                message = new IndianDemandMessage(game, element);
                unit = message.getUnit(game);
                if (unit == null) {
                    logger.warning("IndianDemand with null unit: " + element.getAttribute("unit"));
                    return null;
                }
                colony = message.getColony(game);
                if (colony == null) {
                    logger.warning("IndianDemand with null colony: " + element.getAttribute("colony"));
                    return null;
                }
                if (!player.owns(colony)) {
                    throw new IllegalArgumentException("Demand to anothers colony");
                }
                goods = message.getGoods();
                String goldStr = Integer.toString(message.getGold());
                m = null;
                nation = Messages.message(unit.getOwner().getNationName());
                opt = this.getFreeColClient().getClientOptions().getInteger("model.option.indianDemandResponse");
                if (goods != null) break block15;
                switch (opt) {
                    case 0: {
                        accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.gold.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", message.getGold()), "indianDemand.gold.yes", "indianDemand.gold.no").confirm();
                        break block16;
                    }
                    case 1: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", goldStr);
                        accepted = true;
                        break block16;
                    }
                    case 2: {
                        m = new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.gold.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", goldStr);
                        accepted = false;
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Impossible option value.");
                    }
                }
            }
            String amount = String.valueOf(goods.getAmount());
            switch (opt) {
                case 0: {
                    if (goods.getType().isFoodType()) {
                        accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.food.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", goods.getAmount()), "indianDemand.food.yes", "indianDemand.food.no").confirm();
                        break;
                    }
                    accepted = new ShowConfirmDialogSwingTask(colony.getTile(), StringTemplate.template("indianDemand.other.text").addName("%nation%", nation).addName("%colony%", colony.getName()).addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getType().getNameKey()), "indianDemand.other.yes", "indianDemand.other.no").confirm();
                    break;
                }
                case 1: {
                    m = goods.getType().isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount).add("%goods%", goods.getNameKey());
                    accepted = true;
                    break;
                }
                case 2: {
                    m = goods.getType().isFoodType() ? new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.food.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount) : new ModelMessage(ModelMessage.MessageType.DEMANDS, "indianDemand.other.text", colony, unit).addName("%nation%", nation).addName("%colony%", colony.getName()).addName("%amount%", amount).add("%goods%", goods.getNameKey());
                    accepted = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Impossible option value.");
                }
            }
        }
        if (m != null) {
            player.addModelMessage(m);
            this.getFreeColClient().getInGameController().nextModelMessage();
        }
        message.setResult(accepted);
        return message.toXMLElement();
    }

    private Element spyResult(Element element) {
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() != 2) {
            logger.warning("spyResult length = " + nodeList.getLength());
            return null;
        }
        Game game = this.getGame();
        Element fullTile = (Element)nodeList.item(0);
        Element normalTile = (Element)nodeList.item(1);
        String tileId = element.getAttribute("tile");
        Tile tile = game.getFreeColGameObject(tileId, Tile.class);
        if (tile == null) {
            logger.warning("spyResult bad tile = " + tileId);
            return null;
        }
        tile.readFromXMLElement(fullTile);
        Colony colony = tile.getColony();
        if (colony == null) {
            tile.readFromXMLElement(normalTile);
        } else {
            new SpyColonySwingTask(colony, normalTile).invokeLater();
        }
        return null;
    }

    private Element monarchAction(Element element) {
        Element reply;
        Game game = this.getGame();
        MonarchActionMessage message = new MonarchActionMessage(game, element);
        Monarch.MonarchAction action = message.getAction();
        boolean accept = new ShowMonarchPanelSwingTask(action, message.getTemplate()).confirm();
        message.setResult(accept);
        switch (action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: 
            case OFFER_MERCENARIES: {
                reply = message.toXMLElement();
                break;
            }
            default: {
                reply = null;
            }
        }
        new UpdateMenuBarSwingTask().invokeLater();
        return reply;
    }

    private Element setStance(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = freeColClient.getMyPlayer();
        Game game = this.getGame();
        Player.Stance stance = Enum.valueOf(Player.Stance.class, element.getAttribute("stance"));
        Player first = game.getFreeColGameObject(element.getAttribute("first"), Player.class);
        Player second = game.getFreeColGameObject(element.getAttribute("second"), Player.class);
        Player.Stance old = first.getStance(second);
        try {
            first.setStance(second, stance);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Illegal stance transition", e);
            return null;
        }
        logger.info("Stance transition: " + old.toString() + " -> " + stance.toString());
        if (player == first && old == Player.Stance.UNCONTACTED) {
            this.gui.playSound("sound.event.meet." + second.getNationID());
        }
        return null;
    }

    private Element addPlayer(Element element) {
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        if (this.getGame().getFreeColGameObject(playerElement.getAttribute("ID"), Player.class) == null) {
            Player newPlayer = new Player(this.getGame(), playerElement);
            this.getGame().addPlayer(newPlayer);
        } else {
            this.getGame().getFreeColGameObject(playerElement.getAttribute("ID")).readFromXMLElement(playerElement);
        }
        return null;
    }

    public Element disposeUnits(Element element) {
        Game game = this.getGame();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            Unit u = game.getFreeColGameObject(e.getAttribute("ID"), Unit.class);
            if (u == null) {
                logger.warning("Object is not a unit");
                continue;
            }
            u.dispose();
        }
        return null;
    }

    public Element addObject(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String owner = e.getAttribute("owner");
            Player player = game.getFreeColGameObject(owner, Player.class);
            if (player == null) {
                logger.warning("addObject with broken owner: " + (owner == null ? "(null)" : owner));
                continue;
            }
            String tag = e.getTagName();
            if (tag == null) {
                logger.warning("addObject null tag");
                continue;
            }
            if (tag == FoundingFather.getXMLElementTagName()) {
                String id = e.getAttribute("id");
                FoundingFather father = spec.getFoundingFather(id);
                if (father == null) continue;
                player.addFather(father);
                continue;
            }
            if (tag == HistoryEvent.getXMLElementTagName()) {
                HistoryEvent h = new HistoryEvent();
                h.readFromXMLElement(e);
                player.getHistory().add(h);
                continue;
            }
            if (tag == LastSale.getXMLElementTagName()) {
                LastSale s = new LastSale();
                s.readFromXMLElement(e);
                player.saveSale(s);
                continue;
            }
            if (tag == ModelMessage.getXMLElementTagName()) {
                ModelMessage m = new ModelMessage();
                m.readFromXMLElement(e);
                player.addModelMessage(m);
                continue;
            }
            if (tag == TradeRoute.getXMLElementTagName()) {
                TradeRoute t = new TradeRoute(game, e);
                player.getTradeRoutes().add(t);
                continue;
            }
            logger.warning("addObject unrecognized: " + tag);
        }
        return null;
    }

    public Element featureChange(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        boolean add = "add".equalsIgnoreCase(element.getAttribute("add"));
        FreeColGameObject object = game.getFreeColGameObject(element.getAttribute("id"));
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String tag = e.getTagName();
            if (tag == null) {
                logger.warning("featureChange null tag");
                continue;
            }
            if (tag == Modifier.getXMLElementTagName()) {
                Modifier m = new Modifier(spec);
                m.readFromXMLElement(e, spec);
                if (add) {
                    object.addModifier(m);
                    continue;
                }
                object.removeModifier(m);
                continue;
            }
            if (tag == Ability.getXMLElementTagName()) {
                Ability a = new Ability("");
                a.readFromXMLElement(e, spec);
                if (add) {
                    object.addAbility(a);
                    continue;
                }
                object.removeAbility(a);
                continue;
            }
            logger.warning("featureChange unrecognized: " + tag);
        }
        return null;
    }

    public Element newLandName(Element element) {
        Game game = this.getGame();
        NewLandNameMessage message = new NewLandNameMessage(game, element);
        Unit unit = message.getUnit(game);
        String defaultName = message.getNewLandName();
        if (unit == null || defaultName == null || unit.getTile() == null) {
            return null;
        }
        new NewLandNameSwingTask(unit, defaultName, message.getWelcomer(game), message.getCamps()).invokeLater();
        return null;
    }

    public Element newRegionName(Element element) {
        Game game = this.getGame();
        NewRegionNameMessage message = new NewRegionNameMessage(game, element);
        String name = message.getNewRegionName();
        Region region = message.getRegion(game);
        Tile tile = message.getTile(game);
        if (name == null || region == null) {
            return null;
        }
        new NewRegionNameSwingTask(tile, region, message.getNewRegionName()).invokeLater();
        return null;
    }

    public Element fountainOfYouth(Element element) {
        int n;
        String migrants = element.getAttribute("migrants");
        try {
            n = Integer.parseInt(migrants);
        }
        catch (NumberFormatException e) {
            n = -1;
        }
        if (n > 0) {
            final int m = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (int i = 0; i < m; ++i) {
                        int index = InGameInputHandler.this.gui.showEmigrationPanel(true);
                        InGameInputHandler.this.getFreeColClient().askServer().emigrate(index + 1);
                    }
                }
            });
        }
        return null;
    }

    public Element lootCargo(Element element) {
        Game game = this.getGame();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        List<Goods> goods = message.getGoods();
        if (unit == null || goods == null) {
            return null;
        }
        new LootCargoSwingTask(unit, message.getDefenderId(), goods).invokeLater();
        return null;
    }

    public Element closeMenus() {
        this.gui.closeMenus();
        return null;
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                Element reply = this.handle(connection, (Element)nodes.item(i));
                if (reply == null) continue;
                results.add(reply);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Caught crash in multiple item " + i + ", continuing.", e);
            }
        }
        return DOMMessage.collapseElements(results);
    }

    class ShowMonarchPanelSwingTask
    extends SwingTask {
        private Monarch.MonarchAction action;
        private StringTemplate replace;

        public ShowMonarchPanelSwingTask(Monarch.MonarchAction action, StringTemplate replace) {
            this.action = action;
            this.replace = replace;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeAndWait();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            boolean choice = InGameInputHandler.this.gui.showMonarchPanelDialog(this.action, this.replace);
            return choice;
        }
    }

    abstract class ShowSelectSwingTask
    extends SwingTask {
        ShowSelectSwingTask() {
        }

        public int select() {
            try {
                Object result = this.invokeAndWait();
                return (Integer)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowErrorMessageSwingTask
    extends ShowMessageSwingTask {
        private String _messageId;
        private String _message;

        public ShowErrorMessageSwingTask(String messageId, String message) {
            this._messageId = messageId;
            this._message = message;
        }

        protected Object doWork() {
            InGameInputHandler.this.gui.errorMessage(this._messageId, this._message);
            return null;
        }
    }

    class ShowInformationMessageSwingTask
    extends ShowMessageSwingTask {
        private StringTemplate message;

        public ShowInformationMessageSwingTask(StringTemplate message) {
            this.message = message;
        }

        protected Object doWork() {
            InGameInputHandler.this.gui.showInformationMessage(null, this.message);
            return null;
        }
    }

    class ShowModelMessageSwingTask
    extends ShowMessageSwingTask {
        private ModelMessage _modelMessage;

        public ShowModelMessageSwingTask(ModelMessage modelMessage) {
            this._modelMessage = modelMessage;
        }

        protected Object doWork() {
            InGameInputHandler.this.gui.showModelMessages(this._modelMessage);
            return null;
        }
    }

    abstract class ShowMessageSwingTask
    extends SwingTask {
        ShowMessageSwingTask() {
        }

        public void show() {
            try {
                this.invokeSpecial();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowInputDialogSwingTask
    extends SwingTask {
        private Tile tile;
        private StringTemplate text;
        private String defaultValue;
        private String okText;
        private String cancelText;
        private boolean rejectEmpty;

        public ShowInputDialogSwingTask(Tile tile, StringTemplate text, String defaultValue, String okText, String cancelText, boolean rejectEmpty) {
            this.tile = tile;
            this.text = text;
            this.defaultValue = defaultValue;
            this.okText = okText;
            this.cancelText = cancelText;
            this.rejectEmpty = rejectEmpty;
        }

        public String show() {
            try {
                Object result = this.invokeSpecial();
                return result instanceof String ? (String)result : null;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            String choice = InGameInputHandler.this.gui.showInputDialog(this.tile, this.text, this.defaultValue, this.okText, this.cancelText, this.rejectEmpty);
            return choice;
        }
    }

    class ShowConfirmDialogSwingTask
    extends SwingTask {
        private Tile tile;
        private StringTemplate text;
        private String okText;
        private String cancelText;

        public ShowConfirmDialogSwingTask(Tile tile, StringTemplate text, String okText, String cancelText) {
            this.tile = tile;
            this.text = text;
            this.okText = okText;
            this.cancelText = cancelText;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeSpecial();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            boolean choice = InGameInputHandler.this.gui.showConfirmDialog(this.tile, this.text, this.okText, this.cancelText);
            return choice;
        }
    }

    class ShowVictoryPanelSwingTask
    extends NoResultCanvasSwingTask {
        ShowVictoryPanelSwingTask() {
        }

        protected void doNoResultWork() {
            InGameInputHandler.this.gui.showVictoryPanel();
        }
    }

    class UpdateMenuBarSwingTask
    extends NoResultCanvasSwingTask {
        UpdateMenuBarSwingTask() {
        }

        protected void doNoResultWork() {
            InGameInputHandler.this.gui.updateMenuBar();
        }
    }

    class ReconnectSwingTask
    extends SwingTask {
        ReconnectSwingTask() {
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getConnectController().reconnect();
            return null;
        }
    }

    class SpyColonySwingTask
    extends NoResultCanvasSwingTask {
        private Colony colony;
        private Element normalTile;

        public SpyColonySwingTask(Colony colony, Element normalTile) {
            this.colony = colony;
            this.normalTile = normalTile;
        }

        protected void doNoResultWork() {
            final Tile tile = this.colony.getTile();
            InGameInputHandler.this.gui.showColonyPanel(this.colony).addClosingCallback(new Runnable(){

                public void run() {
                    tile.readFromXMLElement(SpyColonySwingTask.this.normalTile);
                }
            });
        }
    }

    class UnitAttackAnimationCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final Unit attacker;
        private final Unit defender;
        private final Tile attackerTile;
        private final Tile defenderTile;
        private final boolean success;
        private boolean focus;

        public UnitAttackAnimationCanvasSwingTask(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success, boolean focus) {
            this.attacker = attacker;
            this.defender = defender;
            this.attackerTile = attackerTile;
            this.defenderTile = defenderTile;
            this.success = success;
            this.focus = focus;
        }

        protected void doNoResultWork() {
            if (this.focus || !InGameInputHandler.this.gui.onScreen(this.attackerTile) || !InGameInputHandler.this.gui.onScreen(this.defenderTile)) {
                InGameInputHandler.this.gui.setFocusImmediately(this.attackerTile);
            }
            InGameInputHandler.this.gui.animateUnitAttack(this.attacker, this.defender, this.attackerTile, this.defenderTile, this.success);
            InGameInputHandler.this.gui.refresh();
        }
    }

    class UnitMoveAnimationCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final Unit unit;
        private final Tile destinationTile;
        private final Tile sourceTile;
        private boolean focus;

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Tile sourceTile, Tile destinationTile, boolean focus) {
            this.unit = unit;
            this.sourceTile = sourceTile;
            this.destinationTile = destinationTile;
            this.focus = focus;
        }

        protected void doNoResultWork() {
            if (this.focus || !InGameInputHandler.this.gui.onScreen(this.sourceTile)) {
                InGameInputHandler.this.gui.setFocusImmediately(this.sourceTile);
            }
            InGameInputHandler.this.gui.animateUnitMove(this.unit, this.sourceTile, this.destinationTile);
            InGameInputHandler.this.gui.refresh();
        }
    }

    class RefreshTilesSwingTask
    extends NoResultCanvasSwingTask {
        private final Tile _oldTile;
        private final Tile _newTile;

        public RefreshTilesSwingTask(Tile oldTile, Tile newTile) {
            this._oldTile = oldTile;
            this._newTile = newTile;
        }

        void doNoResultWork() {
            InGameInputHandler.this.gui.refreshTile(this._oldTile);
            InGameInputHandler.this.gui.refreshTile(this._newTile);
        }
    }

    class NewRegionNameSwingTask
    extends NoResultCanvasSwingTask {
        private Tile tile;
        private Region region;
        private String defaultName;

        public NewRegionNameSwingTask(Tile tile, Region region, String defaultName) {
            this.tile = tile;
            this.region = region;
            this.defaultName = defaultName;
        }

        protected void doNoResultWork() {
            String name = InGameInputHandler.this.gui.showInputDialog(this.tile, StringTemplate.template("nameRegion.text").addName("%type%", Messages.message(this.region.getLabel())), this.defaultName, "ok", null, false);
            if (name == null || "".equals(name)) {
                name = this.defaultName;
            }
            InGameInputHandler.this.getFreeColClient().askServer().newRegionName(this.region, this.tile, name);
        }
    }

    class NewLandNameSwingTask
    extends NoResultCanvasSwingTask {
        private Unit unit;
        private String defaultName;
        private Player welcomer;
        private String camps;

        public NewLandNameSwingTask(Unit unit, String defaultName, Player welcomer, String camps) {
            this.unit = unit;
            this.defaultName = defaultName;
            this.welcomer = welcomer;
            this.camps = camps;
        }

        protected void doNoResultWork() {
            Tile tile = this.unit.getTile();
            String name = InGameInputHandler.this.gui.showInputDialog(tile, StringTemplate.template("newLand.text"), this.defaultName, "newLand.yes", null, true);
            boolean accept = false;
            if (this.welcomer != null) {
                String messageId = this.welcomer.owns(tile) ? "welcomeOffer.text" : "welcomeSimple.text";
                String type = ((IndianNationType)this.welcomer.getNationType()).getSettlementTypeKey(true);
                accept = InGameInputHandler.this.gui.showConfirmDialog(tile, StringTemplate.template(messageId).addStringTemplate("%nation%", this.welcomer.getNationName()).addName("%camps%", this.camps).add("%settlementType%", type), "welcome.yes", "welcome.no");
            }
            FreeColClient fcc = InGameInputHandler.this.getFreeColClient();
            fcc.askServer().newLandName(this.unit, name, this.welcomer, accept);
            Player player = this.unit.getOwner();
            String key = FreeColActionUI.getHumanKeyStrokeText(fcc.getActionManager().getFreeColAction("buildColonyAction").getAccelerator());
            player.addModelMessage(new ModelMessage(ModelMessage.MessageType.TUTORIAL, "tutorial.buildColony", player).addName("%build_colony_key%", key).add("%build_colony_menu_item%", "buildColonyAction.name").add("%orders_menu_item%", "menuBar.orders"));
            fcc.getInGameController().nextModelMessage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LootCargoSwingTask
    extends NoResultCanvasSwingTask {
        private Unit unit;
        private String defenderId;
        private List<Goods> goods;

        public LootCargoSwingTask(Unit unit, String defenderId, List<Goods> goods) {
            this.unit = unit;
            this.defenderId = defenderId;
            this.goods = goods;
        }

        @Override
        protected void doNoResultWork() {
            this.goods = InGameInputHandler.this.gui.showCaptureGoodsDialog(this.unit, this.goods);
            if (!this.goods.isEmpty()) {
                InGameInputHandler.this.getFreeColClient().askServer().loot(this.unit, this.defenderId, this.goods);
            }
        }
    }

    class RefreshCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final boolean requestFocus;

        public RefreshCanvasSwingTask() {
            this(false);
        }

        public RefreshCanvasSwingTask(boolean requestFocus) {
            this.requestFocus = requestFocus;
        }

        protected void doNoResultWork() {
            InGameInputHandler.this.gui.refresh();
            if (this.requestFocus && !InGameInputHandler.this.gui.isShowingSubPanel()) {
                InGameInputHandler.this.gui.requestFocusInWindow();
            }
        }
    }

    abstract class NoResultCanvasSwingTask
    extends SwingTask {
        NoResultCanvasSwingTask() {
        }

        protected Object doWork() {
            this.doNoResultWork();
            return null;
        }

        abstract void doNoResultWork();
    }

    static abstract class SwingTask
    implements Runnable {
        private static final Logger taskLogger = Logger.getLogger(SwingTask.class.getName());
        private Object _result;
        private boolean _synchronous;
        private boolean _started;

        SwingTask() {
        }

        public Object invokeAndWait() throws InvocationTargetException {
            this.verifyNotStarted();
            this.markStarted(true);
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                throw new InvocationTargetException(e);
            }
            return this._result;
        }

        public void invokeLater() {
            this.verifyNotStarted();
            this.markStarted(false);
            SwingUtilities.invokeLater(this);
        }

        public Object invokeSpecial() throws InvocationTargetException {
            return SwingUtilities.isEventDispatchThread() ? this.doWork() : this.invokeAndWait();
        }

        private synchronized void markStarted(boolean synchronous) {
            this._synchronous = synchronous;
            this._started = true;
        }

        private synchronized void markDone() {
            this._started = false;
        }

        private synchronized void verifyNotStarted() {
            if (this._started) {
                throw new IllegalStateException("Swing task already started!");
            }
        }

        private synchronized boolean isSynchronous() {
            return this._synchronous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                taskLogger.log(Level.FINEST, "Running Swing task " + this.getClass().getName() + "...");
                this.setResult(this.doWork());
                taskLogger.log(Level.FINEST, "Swing task " + this.getClass().getName() + " returned " + this._result);
            }
            catch (RuntimeException e) {
                taskLogger.log(Level.WARNING, "Swing task " + this.getClass().getName() + " failed!", e);
                if (this.isSynchronous()) {
                    throw e;
                }
            }
            finally {
                this.markDone();
            }
        }

        public synchronized Object getResult() {
            return this._result;
        }

        private synchronized void setResult(Object r) {
            this._result = r;
        }

        protected abstract Object doWork();
    }
}

