/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.jar.Manifest;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.logging.DefaultHandler;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.server.FreeColServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class FreeCol {
    private static final Logger logger = Logger.getLogger(FreeCol.class.getName());
    public static final String META_SERVER_ADDRESS = "meta.freecol.org";
    public static final int META_SERVER_PORT = 3540;
    public static final int DEFAULT_PORT = 3541;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final int TIMEOUT_MIN = 10;
    public static final String CLIENT_THREAD = "FreeColClient:";
    public static final String SERVER_THREAD = "FreeColServer:";
    public static final String METASERVER_THREAD = "FreeColMetaServer:";
    private static final String FREECOL_VERSION = "0.10.7";
    private static String FREECOL_REVISION;
    private static final String MIN_JDK_VERSION = "1.5";
    private static final String DEFAULT_SPLASH_FILE = "splash.jpg";
    private static boolean sound;
    private static boolean javaCheck;
    private static boolean memoryCheck;
    private static boolean consoleLogging;
    private static boolean introVideo;
    private static String logFile;
    private static boolean standAloneServer;
    private static boolean publicServer;
    private static String fontName;
    private static int serverPort;
    private static String serverName;
    private static Level logLevel;
    private static boolean checkIntegrity;
    private static final Options options;
    private static String splashFilename;
    private static Dimension windowSize;
    private static int freeColTimeout;

    private FreeCol() {
    }

    private static String readVersion(Class c) throws IOException {
        String resourceName = "/" + c.getName().toString().replace('.', '/') + ".class";
        URL url = c.getResource(resourceName);
        Manifest mf = ((JarURLConnection)url.openConnection()).getManifest();
        return mf.getMainAttributes().getValue("Package-Version");
    }

    public static void main(String[] args) {
        FREECOL_REVISION = FREECOL_VERSION;
        try {
            String revision = FreeCol.readVersion(FreeCol.class);
            if (revision != null) {
                FREECOL_REVISION = FREECOL_REVISION + " (Revision: " + revision + ")";
            }
        }
        catch (Exception e) {
            System.err.println("Unable to load Manifest: " + e.getMessage());
        }
        FreeCol.handleArgs(args);
        FreeColDirectories.createAndSetDirectories();
        FreeCol.initLogging();
        Mods.loadMods();
        Locale locale = FreeCol.getLocale();
        Locale.setDefault(locale);
        Messages.setMessageBundle(locale);
        Messages.setModMessageBundle(locale);
        if (javaCheck && !FreeCol.checkJavaVersion()) {
            System.err.println("Java version 1.5 or better is recommended in order to run FreeCol. Use --no-java-check to skip this check.");
            System.exit(1);
        }
        int minMemory = 128;
        if (memoryCheck && Runtime.getRuntime().maxMemory() < (long)(minMemory * 1000000)) {
            System.out.println("You need to assign more memory to the JVM. Restart FreeCol with:");
            System.out.println("java -Xmx" + minMemory + "M -jar FreeCol.jar");
            System.exit(1);
        }
        if (standAloneServer) {
            FreeCol.startServer();
        } else {
            FreeColClient freeColClient = new FreeColClient(FreeColDirectories.getSavegameFile(), windowSize, sound, splashFilename, introVideo, fontName);
        }
    }

    private static void initLogging() {
        final Logger baseLogger = Logger.getLogger("");
        Handler[] handlers = baseLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            baseLogger.removeHandler(handlers[i]);
        }
        if (logFile == null) {
            logFile = FreeColDirectories.getMainUserDirectory().getPath() + File.separator + "FreeCol.log";
        }
        try {
            baseLogger.addHandler(new DefaultHandler(consoleLogging, logFile));
            Logger freecolLogger = Logger.getLogger("net.sf.freecol");
            freecolLogger.setLevel(logLevel);
        }
        catch (FreeColException e) {
            e.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable e) {
                baseLogger.log(Level.WARNING, "Uncaught exception from thread: " + thread, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale() {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader in = null;
        File options = FreeColDirectories.getClientOptionsFile();
        if (options.canRead()) {
            try {
                in = xif.createXMLStreamReader(new FileInputStream(options), "UTF-8");
                in.nextTag();
                int eventid = in.getEventType();
                while (eventid != 8) {
                    if (eventid == 1 && "model.option.languageOption".equals(in.getAttributeValue(null, "id"))) {
                        Locale locale = LanguageOption.getLocale(in.getAttributeValue(null, "value"));
                        return locale;
                    }
                    in.nextTag();
                    eventid = in.getEventType();
                }
                logger.log(Level.WARNING, "Language setting not found in client options file.  Using default.");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception while loading options.", e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception while closing stream.", e);
                }
            }
        }
        return Locale.getDefault();
    }

    public static int getDefaultPort() {
        return 3541;
    }

    private static void setSavegame(String name) {
        if (name == null) {
            System.out.println("No savegame given with --load-savegame parameter");
            System.exit(1);
        }
        FreeColDirectories.setSaveGameFile(name);
    }

    private static boolean checkJavaVersion() {
        String version = System.getProperty("java.version");
        boolean success = version.compareTo(MIN_JDK_VERSION) >= 0;
        return success;
    }

    private static void handleArgs(String[] args) {
        PosixParser parser = new PosixParser();
        String localeArg = null;
        String locationArg = null;
        for (int index = 0; index < args.length - 1; ++index) {
            if ("--default-locale".equals(args[index])) {
                localeArg = args[++index];
                continue;
            }
            if (!"--freecol-data".equals(args[index])) continue;
            locationArg = args[++index];
        }
        if (locationArg != null) {
            FreeColDirectories.setDataFolder(locationArg);
        }
        if (localeArg == null) {
            Messages.setMessageBundle(Locale.getDefault());
        } else {
            Locale locale = LanguageOption.getLocale(localeArg);
            Locale.setDefault(locale);
            Messages.setMessageBundle(locale);
        }
        OptionBuilder.withLongOpt((String)"freecol-data");
        OptionBuilder.withDescription((String)Messages.message("cli.freecol-data"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.directory"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"tc");
        OptionBuilder.withDescription((String)Messages.message("cli.tc"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"home-directory");
        OptionBuilder.withDescription((String)Messages.message("cli.home-directory"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.directory"));
        OptionBuilder.withType((Object)new File("dummy"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-console");
        OptionBuilder.withDescription((String)Messages.message("cli.log-console"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.withDescription((String)Messages.message("cli.log-file"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"log-level");
        OptionBuilder.withDescription((String)Messages.message("cli.log-level"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.loglevel"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-java-check");
        OptionBuilder.withDescription((String)Messages.message("cli.no-java-check"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"windowed");
        OptionBuilder.withDescription((String)Messages.message("cli.windowed"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.dimensions"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-locale");
        OptionBuilder.withDescription((String)Messages.message("cli.default-locale"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.locale"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-memory-check");
        OptionBuilder.withDescription((String)Messages.message("cli.no-memory-check"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-intro");
        OptionBuilder.withDescription((String)Messages.message("cli.no-intro"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-sound");
        OptionBuilder.withDescription((String)Messages.message("cli.no-sound"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"usage");
        OptionBuilder.withDescription((String)Messages.message("cli.help"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)Messages.message("cli.help"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)Messages.message("cli.version"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)Messages.message("cli.debug"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.debuglevel"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"debug-run");
        OptionBuilder.withDescription((String)Messages.message("cli.debug-run"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.debugRun"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"private");
        OptionBuilder.withDescription((String)Messages.message("cli.private"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"server");
        OptionBuilder.withDescription((String)Messages.message("cli.server"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.port"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"load-savegame");
        OptionBuilder.withDescription((String)Messages.message("cli.load-savegame"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.file"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"server-name");
        OptionBuilder.withDescription((String)Messages.message("cli.server-name"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.name"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"splash");
        OptionBuilder.withDescription((String)Messages.message("cli.splash"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.file"));
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"check-savegame");
        OptionBuilder.withDescription((String)Messages.message("cli.check-savegame"));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"font");
        OptionBuilder.withDescription((String)Messages.message("cli.font"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.font"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"seed");
        OptionBuilder.withDescription((String)Messages.message("cli.seed"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.seed"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.withDescription((String)Messages.message("cli.timeout"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.timeout"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"clientOptions");
        OptionBuilder.withDescription((String)Messages.message("cli.clientOptions"));
        OptionBuilder.withArgName((String)Messages.message("cli.arg.clientOptions"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create());
        try {
            String arg;
            String str;
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("default-locale")) {
                String languageID = line.getOptionValue("default-locale");
                int index = languageID.indexOf(46);
                if (index > 0) {
                    languageID = languageID.substring(0, index);
                }
                Locale newLocale = LanguageOption.getLocale(languageID);
                Locale.setDefault(newLocale);
                Messages.setMessageBundle(newLocale);
            }
            if (line.hasOption("splash") && (str = line.getOptionValue("splash")) != null) {
                splashFilename = str;
            }
            if (line.hasOption("freecol-data")) {
                FreeColDirectories.setDataFolder(line.getOptionValue("freecol-data"));
            }
            if (line.hasOption("tc")) {
                FreeColDirectories.setTc(line.getOptionValue("tc"));
            }
            if (line.hasOption("home-directory")) {
                arg = line.getOptionValue("home-directory");
                FreeColDirectories.setMainUserDirectory(new File(arg));
                String errMsg = null;
                if (!FreeColDirectories.getMainUserDirectory().exists()) {
                    errMsg = "cli.error.home.notExists";
                }
                if (!FreeColDirectories.getMainUserDirectory().canRead()) {
                    errMsg = "cli.error.home.noRead";
                }
                if (!FreeColDirectories.getMainUserDirectory().canWrite()) {
                    errMsg = "cli.error.home.noWrite";
                }
                if (errMsg != null) {
                    System.out.println(Messages.message(StringTemplate.template(errMsg).addName("%string%", arg)));
                    System.exit(1);
                }
            }
            if (line.hasOption("log-console")) {
                consoleLogging = true;
            }
            if (line.hasOption("log-file")) {
                logFile = line.getOptionValue("log-file");
            }
            if (line.hasOption("log-level")) {
                String logLevelString = line.getOptionValue("log-level").toUpperCase();
                try {
                    logLevel = Level.parse(logLevelString);
                }
                catch (IllegalArgumentException e) {
                    FreeCol.printUsage();
                    System.exit(1);
                }
            }
            if (line.hasOption("no-java-check")) {
                javaCheck = false;
            }
            if (line.hasOption("windowed")) {
                String dimensions = line.getOptionValue("windowed");
                if (dimensions == null) {
                    windowSize = new Dimension(-1, -1);
                } else {
                    String[] xy = dimensions.split("[^0-9]");
                    if (xy.length == 2) {
                        windowSize = new Dimension(Integer.parseInt(xy[0]), Integer.parseInt(xy[1]));
                    } else {
                        FreeCol.printUsage();
                        System.exit(1);
                    }
                }
            }
            if (line.hasOption("no-sound")) {
                sound = false;
            }
            if (line.hasOption("no-intro")) {
                introVideo = false;
            }
            if (line.hasOption("no-memory-check")) {
                memoryCheck = false;
            }
            if (line.hasOption("help") || line.hasOption("usage")) {
                FreeCol.printUsage();
                System.exit(0);
            }
            if (line.hasOption("version")) {
                System.out.println("FreeCol " + FreeCol.getVersion());
                System.exit(0);
            }
            if (line.hasOption("debug")) {
                arg = line.getOptionValue("debug");
                if (arg == null || "".equals(arg)) {
                    FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
                } else {
                    FreeColDebugger.setDebugModes(arg);
                }
                if (!line.hasOption("log-level")) {
                    logLevel = Level.FINEST;
                }
            }
            if (line.hasOption("debug-run")) {
                FreeColDebugger.enableDebugMode(FreeColDebugger.DebugMode.MENUS);
                FreeColDebugger.configureDebugRun(line.getOptionValue("debug-run"));
            }
            if (line.hasOption("server")) {
                standAloneServer = true;
                arg = line.getOptionValue("server");
                if (arg != null) {
                    try {
                        serverPort = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println(Messages.message(StringTemplate.template("cli.error.port").addName("%string%", arg)));
                        System.exit(1);
                    }
                }
            }
            if (line.hasOption("private")) {
                publicServer = false;
            }
            if (line.hasOption("check-savegame")) {
                FreeCol.setSavegame(line.getOptionValue("load-savegame"));
                checkIntegrity = true;
                standAloneServer = true;
            }
            if (line.hasOption("load-savegame")) {
                FreeCol.setSavegame(line.getOptionValue("load-savegame"));
            }
            if (line.hasOption("server-name")) {
                serverName = line.getOptionValue("server-name");
            }
            if (line.hasOption("font")) {
                fontName = line.getOptionValue("font");
            }
            if (line.hasOption("seed")) {
                String seedStr = line.getOptionValue("seed");
                try {
                    FreeColSeed.initialize(Long.parseLong(seedStr));
                }
                catch (NumberFormatException e) {
                    System.err.println("Ignoring bad seed: " + seedStr);
                }
            }
            if (line.hasOption("timeout")) {
                int result;
                String timeoutStr = line.getOptionValue("timeout");
                try {
                    result = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException nfe) {
                    result = -1;
                }
                if (result < 10) {
                    System.err.println("Ignoring bad timeout: " + timeoutStr);
                } else {
                    freeColTimeout = result;
                }
            }
            if (line.hasOption("clientOptions")) {
                String fileName = line.getOptionValue("clientOptions");
                File file = new File(fileName);
                if (file.exists() && file.isFile() && file.canRead()) {
                    FreeColDirectories.setClientOptionsFile(file);
                } else {
                    String err = Messages.message(StringTemplate.template("cli.error.clientOptions").addName("%string%", fileName));
                    System.err.println(err);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage() + "\n");
            FreeCol.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -Xmx 128M -jar freecol.jar [OPTIONS]", options);
    }

    public static String getVersion() {
        return FREECOL_VERSION;
    }

    public static String getRevision() {
        return FREECOL_REVISION;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static int getFreeColTimeout(boolean singlePlayer) {
        return freeColTimeout >= 10 ? freeColTimeout : (singlePlayer ? Integer.MAX_VALUE : 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void startServer() {
        FreeCol.logger.info("Starting stand-alone server.");
        try {
            if (FreeColDirectories.getSavegameFile() != null) {
                xs = null;
                try {
                    fis = new FreeColSavegameFile(FreeColDirectories.getSavegameFile());
                    xs = FreeColServer.createXMLStreamReader(fis);
                    in = xs.getXMLStreamReader();
                    in.nextTag();
                    xs.close();
                    freeColServer = new FreeColServer(fis, FreeCol.serverPort, FreeCol.serverName);
                    if (!FreeCol.checkIntegrity) ** GOTO lbl36
                    integrityOK = freeColServer.getIntegrity();
                    System.out.println(Messages.message(integrityOK != false ? "cli.check-savegame.success" : "cli.check-savegame.failure"));
                    System.exit(integrityOK != false ? 0 : 1);
                }
                catch (Exception e) {
                    if (FreeCol.checkIntegrity) {
                        System.out.println(Messages.message("cli.check-savegame.failure"));
                    }
                    System.out.println("Could not load savegame.");
                    System.exit(1);
                    return;
                }
                finally {
                    xs.close();
                }
            } else {
                try {
                    tcData = new FreeColTcFile(FreeColDirectories.getTc());
                    specification = tcData.getSpecification();
                    freeColServer = new FreeColServer(specification, FreeCol.publicServer, false, FreeCol.serverPort, FreeCol.serverName);
                }
                catch (NoRouteToServerException e) {
                    System.out.println(Messages.message("server.noRouteToServer"));
                    System.exit(1);
                    return;
                }
            }
lbl36:
            // 3 sources

            runtime = Runtime.getRuntime();
            runtime.addShutdownHook(new Thread(){

                public void run() {
                    freeColServer.getController().shutdown();
                }
            });
        }
        catch (IOException e) {
            System.err.println("Error while loading server: " + e);
            System.exit(1);
        }
    }

    static {
        sound = true;
        javaCheck = true;
        memoryCheck = true;
        consoleLogging = false;
        introVideo = true;
        logFile = null;
        standAloneServer = false;
        publicServer = true;
        fontName = null;
        serverPort = -1;
        serverName = null;
        logLevel = Level.INFO;
        checkIntegrity = false;
        options = new Options();
        splashFilename = DEFAULT_SPLASH_FILE;
        freeColTimeout = -1;
    }
}

