/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.server.generator.River;
import net.sf.freecol.server.generator.RiverSection;
import net.sf.freecol.server.model.ServerRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerrainGenerator {
    private static final Logger logger = Logger.getLogger(TerrainGenerator.class.getName());
    public static final int LAND_REGIONS_SCORE_VALUE = 1000;
    public static final int LAND_REGION_MIN_SCORE = 5;
    public static final int PACIFIC_SCORE_VALUE = 100;
    public static final int LAND_REGION_MAX_SIZE = 75;
    private final OptionGroup mapGeneratorOptions;
    private final Random random;
    private TileType lake;
    private TileImprovementType riverType;
    private TileImprovementType fishBonusLandType;
    private TileImprovementType fishBonusRiverType;
    private ArrayList<TileType> terrainTileTypes;
    private ArrayList<TileType> oceanTileTypes;

    public TerrainGenerator(OptionGroup mapGeneratorOptions, Random random) {
        this.mapGeneratorOptions = mapGeneratorOptions;
        this.random = random;
    }

    private int limitToRange(int value, int lower, int upper) {
        return Math.max(lower, Math.min(value, upper));
    }

    public Map.Position getRandomLandPosition(Map map, Random random) {
        int x = map.getWidth() < 10 ? random.nextInt(map.getWidth()) : random.nextInt(map.getWidth() - 10) + 5;
        int y = map.getHeight() < 10 ? random.nextInt(map.getHeight()) : random.nextInt(map.getHeight() - 10) + 5;
        Map.Position centerPosition = new Map.Position(x, y);
        Iterator<Map.Position> it = map.getFloodFillIterator(centerPosition);
        while (it.hasNext()) {
            Map.Position p = it.next();
            if (!map.getTile(p).isLand()) continue;
            return p;
        }
        return null;
    }

    public void createMap(Game game, boolean[][] landMap) {
        this.createMap(game, null, landMap);
    }

    public void createMap(Game game, Game importGame, boolean[][] landMap) {
        Specification spec = game.getSpecification();
        this.lake = spec.getTileType("model.tile.lake");
        this.riverType = spec.getTileImprovementType("model.improvement.river");
        this.fishBonusLandType = spec.getTileImprovementType("model.improvement.fishBonusLand");
        this.fishBonusRiverType = spec.getTileImprovementType("model.improvement.fishBonusRiver");
        int width = landMap.length;
        int height = landMap[0].length;
        boolean importTerrain = importGame != null && this.getMapGeneratorOptions().getBoolean("model.option.importTerrain");
        boolean importBonuses = importGame != null && this.getMapGeneratorOptions().getBoolean("model.option.importBonuses");
        boolean mapHasLand = false;
        Tile[][] tiles = new Tile[width][height];
        Map map = new Map(game, tiles);
        int minimumLatitude = this.getMapGeneratorOptions().getInteger("model.option.minimumLatitude");
        int maximumLatitude = this.getMapGeneratorOptions().getInteger("model.option.maximumLatitude");
        minimumLatitude = this.limitToRange(minimumLatitude, -90, 90);
        maximumLatitude = this.limitToRange(maximumLatitude, -90, 90);
        map.setMinimumLatitude(Math.min(minimumLatitude, maximumLatitude));
        map.setMaximumLatitude(Math.max(minimumLatitude, maximumLatitude));
        for (int y = 0; y < height; ++y) {
            int latitude = map.getLatitude(y);
            for (int x = 0; x < width; ++x) {
                Tile t;
                if (landMap[x][y]) {
                    mapHasLand = true;
                }
                if (importTerrain && importGame.getMap().isValid(x, y)) {
                    Tile importTile = importGame.getMap().getTile(x, y);
                    if (importTile.isLand() == landMap[x][y]) {
                        t = new Tile(game, spec.getTileType(importTile.getType().getId()), x, y);
                        if (importTile.getMoveToEurope() != null) {
                            t.setMoveToEurope(importTile.getMoveToEurope());
                        }
                        if (importTile.getTileItemContainer() != null) {
                            TileItemContainer container = new TileItemContainer(game, t);
                            container.copyFrom(importTile.getTileItemContainer(), importBonuses, true);
                            t.setTileItemContainer(container);
                        }
                    } else {
                        t = this.createTile(game, x, y, landMap, latitude);
                    }
                } else {
                    t = this.createTile(game, x, y, landMap, latitude);
                }
                tiles[x][y] = t;
            }
        }
        game.setMap(map);
        if (!importTerrain) {
            this.createOceanRegions(map);
            this.createHighSeas(map);
            if (mapHasLand) {
                this.createMountains(map);
                this.findLakes(map);
                this.createLandRegions(map);
                this.createRivers(map);
            }
        }
        for (Tile tile : map.getAllTiles()) {
            this.perhapsAddBonus(tile, !importBonuses);
            if (tile.isLand()) continue;
            TerrainGenerator.encodeStyle(tile);
        }
    }

    public static void encodeStyle(Tile ocean) {
        Tile tile;
        EnumMap<Map.Direction, Boolean> connections = new EnumMap<Map.Direction, Boolean>(Map.Direction.class);
        Map.Direction[] arr$ = Map.Direction.corners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Map.Direction d;
            tile = ocean.getNeighbourOrNull(d = arr$[i$]);
            connections.put(d, tile != null && tile.isLand());
        }
        for (Map.Direction d : Map.Direction.longSides) {
            tile = ocean.getNeighbourOrNull(d);
            if (tile != null && tile.isLand()) {
                connections.put(d, true);
                connections.put(d.getNextDirection(), false);
                connections.put(d.getPreviousDirection(), false);
                continue;
            }
            connections.put(d, false);
        }
        int result = 0;
        int index = 0;
        for (Map.Direction d : Map.Direction.corners) {
            if (((Boolean)connections.get((Object)d)).booleanValue()) {
                result += (int)Math.pow(2.0, index);
            }
            ++index;
        }
        for (Map.Direction d : Map.Direction.longSides) {
            if (((Boolean)connections.get((Object)d)).booleanValue()) {
                result += (int)Math.pow(2.0, index);
            }
            ++index;
        }
        ocean.setStyle(result);
    }

    private Tile createTile(Game game, int x, int y, boolean[][] landMap, int latitude) {
        Tile t = landMap[x][y] ? new Tile(game, this.getRandomLandTileType(game, latitude), x, y) : new Tile(game, this.getRandomOceanTileType(game, latitude), x, y);
        return t;
    }

    private void perhapsAddBonus(Tile t, boolean generateBonus) {
        if (t.isLand()) {
            if (generateBonus && this.random.nextInt(100) < this.getMapGeneratorOptions().getInteger("model.option.bonusNumber")) {
                t.addResource(this.createResource(t));
            }
        } else {
            int adjacentLand = 0;
            boolean adjacentRiver = false;
            for (Map.Direction direction : Map.Direction.values()) {
                Tile otherTile = t.getNeighbourOrNull(direction);
                if (otherTile == null || !otherTile.isLand()) continue;
                ++adjacentLand;
                if (!otherTile.hasRiver()) continue;
                adjacentRiver = true;
            }
            if (adjacentLand > 2) {
                t.add(new TileImprovement(t.getGame(), t, this.fishBonusLandType));
            }
            if (!t.hasRiver() && adjacentRiver) {
                t.add(new TileImprovement(t.getGame(), t, this.fishBonusRiverType));
            }
            if (t.getType().isConnected()) {
                if (generateBonus && adjacentLand > 1 && this.random.nextInt(10 - adjacentLand) == 0) {
                    t.addResource(this.createResource(t));
                }
            } else if (this.random.nextInt(100) < this.getMapGeneratorOptions().getInteger("model.option.bonusNumber")) {
                t.addResource(this.createResource(t));
            }
        }
    }

    public Resource createResource(Tile tile) {
        int maxValue;
        if (tile == null) {
            return null;
        }
        ResourceType resourceType = (ResourceType)RandomChoice.getWeightedRandom(null, null, this.random, tile.getType().getWeightedResources());
        if (resourceType == null) {
            return null;
        }
        int minValue = resourceType.getMinValue();
        int quantity = minValue == (maxValue = resourceType.getMaxValue()) ? maxValue : minValue + this.random.nextInt(maxValue - minValue + 1);
        return new Resource(tile.getGame(), tile, resourceType, quantity);
    }

    private OptionGroup getMapGeneratorOptions() {
        return this.mapGeneratorOptions;
    }

    private TileType getRandomOceanTileType(Game game, int latitude) {
        if (this.oceanTileTypes == null) {
            this.oceanTileTypes = new ArrayList();
            for (TileType tileType : game.getSpecification().getTileTypeList()) {
                if (!tileType.isWater() || !tileType.isConnected() || tileType.hasAbility("model.ability.moveToEurope")) continue;
                this.oceanTileTypes.add(tileType);
            }
        }
        return this.getRandomTileType(game, this.oceanTileTypes, latitude);
    }

    private TileType getRandomLandTileType(Game game, int latitude) {
        if (this.terrainTileTypes == null) {
            this.terrainTileTypes = new ArrayList();
            for (TileType tileType : game.getSpecification().getTileTypeList()) {
                if (tileType.isElevation() || tileType.isWater()) continue;
                this.terrainTileTypes.add(tileType);
            }
        }
        return this.getRandomTileType(game, this.terrainTileTypes, latitude);
    }

    private TileType getRandomTileType(Game game, List<TileType> candidates, int latitude) {
        TileType t;
        int forestChance = this.getMapGeneratorOptions().getInteger("model.option.forestNumber");
        int temperaturePreference = this.getMapGeneratorOptions().getInteger("model.option.temperature");
        int poleTemperature = -20;
        int equatorTemperature = 40;
        switch (temperaturePreference) {
            case 0: {
                poleTemperature = -20;
                equatorTemperature = 25;
                break;
            }
            case 1: {
                poleTemperature = -20;
                equatorTemperature = 30;
                break;
            }
            case 2: {
                poleTemperature = -10;
                equatorTemperature = 35;
                break;
            }
            case 3: {
                poleTemperature = -5;
                equatorTemperature = 40;
                break;
            }
            case 4: {
                poleTemperature = 0;
                equatorTemperature = 40;
            }
        }
        int temperatureRange = equatorTemperature - poleTemperature;
        int localeTemperature = poleTemperature + (90 - Math.abs(latitude)) * temperatureRange / 90;
        int temperatureDeviation = 7;
        localeTemperature += this.random.nextInt(temperatureDeviation * 2) - temperatureDeviation;
        localeTemperature = this.limitToRange(localeTemperature, -20, 40);
        int localeHumidity = game.getSpecification().getRangeOption("model.option.humidity").getValue();
        int humidityDeviation = 20;
        localeHumidity += this.random.nextInt(humidityDeviation * 2) - humidityDeviation;
        localeHumidity = this.limitToRange(localeHumidity, 0, 100);
        ArrayList<TileType> candidateTileTypes = new ArrayList<TileType>(candidates);
        Collections.shuffle(candidateTileTypes, this.random);
        Iterator it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            t = (TileType)it.next();
            if (t.withinRange(TileType.RangeType.TEMPERATURE, localeTemperature)) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature);
        }
        it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            t = (TileType)it.next();
            if (t.withinRange(TileType.RangeType.HUMIDITY, localeHumidity)) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature + " and humidity==" + localeHumidity);
        }
        boolean forested = this.random.nextInt(100) < forestChance;
        it = candidateTileTypes.iterator();
        while (it.hasNext()) {
            TileType t2 = (TileType)it.next();
            if (t2.isForested() == forested || !it.hasNext()) continue;
            it.remove();
        }
        if (candidateTileTypes.size() == 1) {
            return (TileType)candidateTileTypes.get(0);
        }
        if (candidateTileTypes.size() == 0) {
            throw new RuntimeException("No TileType for temperature==" + localeTemperature + " and humidity==" + localeHumidity + " and forested==" + forested);
        }
        return (TileType)candidateTileTypes.get(0);
    }

    void createOceanRegions(Map map) {
        Game game = map.getGame();
        ServerRegion pacific = new ServerRegion(game, "model.region.pacific", Region.RegionType.OCEAN);
        ServerRegion northPacific = new ServerRegion(game, "model.region.northPacific", Region.RegionType.OCEAN, pacific);
        ServerRegion southPacific = new ServerRegion(game, "model.region.southPacific", Region.RegionType.OCEAN, pacific);
        ServerRegion atlantic = new ServerRegion(game, "model.region.atlantic", Region.RegionType.OCEAN);
        ServerRegion northAtlantic = new ServerRegion(game, "model.region.northAtlantic", Region.RegionType.OCEAN, atlantic);
        ServerRegion southAtlantic = new ServerRegion(game, "model.region.southAtlantic", Region.RegionType.OCEAN, atlantic);
        for (ServerRegion region : new ServerRegion[]{northPacific, southPacific, atlantic, northAtlantic, southAtlantic}) {
            region.setPrediscovered(true);
            map.setRegion(region);
        }
        map.setRegion(pacific);
        pacific.setDiscoverable(true);
        pacific.setScoreValue(100);
        int maxx = map.getWidth();
        int midx = maxx / 2;
        int maxy = map.getHeight();
        int midy = maxy / 2;
        Map.Position pNP = new Map.Position(0, midy - 1);
        Map.Position pSP = new Map.Position(0, midy + 1);
        Map.Position pNA = new Map.Position(maxx - 1, midy - 1);
        Map.Position pSA = new Map.Position(maxx - 1, midy + 1);
        Rectangle rNP = new Rectangle(0, 0, midx, midy);
        Rectangle rSP = new Rectangle(0, midy, midx, maxy);
        Rectangle rNA = new Rectangle(midx, 0, maxx, midy);
        Rectangle rSA = new Rectangle(midx, midy, maxx, maxy);
        this.fillOcean(map, pNP, northPacific, rNP);
        this.fillOcean(map, pSP, southPacific, rSP);
        this.fillOcean(map, pNA, northAtlantic, rNA);
        this.fillOcean(map, pSA, southAtlantic, rSA);
        Rectangle rN = new Rectangle(0, 0, maxx, midy);
        Rectangle rS = new Rectangle(0, midy, maxx, maxy);
        this.fillOcean(map, pNP, northPacific, rN);
        this.fillOcean(map, pSP, southPacific, rS);
        this.fillOcean(map, pNA, northAtlantic, rN);
        this.fillOcean(map, pSA, southAtlantic, rS);
        Rectangle rAll = new Rectangle(0, 0, maxx, maxy);
        this.fillOcean(map, pNP, northPacific, rAll);
        this.fillOcean(map, pSP, southPacific, rAll);
        this.fillOcean(map, pNA, northAtlantic, rAll);
        this.fillOcean(map, pSA, southAtlantic, rAll);
    }

    private void fillOcean(Map map, Map.Position p, Region region, Rectangle bounds) {
        LinkedList<Map.Position> q = new LinkedList<Map.Position>();
        boolean[][] visited = new boolean[map.getWidth()][map.getHeight()];
        visited[p.getX()][p.getY()] = true;
        q.add(p);
        while ((p = (Map.Position)q.poll()) != null) {
            Tile tile = map.getTile(p);
            tile.setRegion(region);
            for (Map.Direction direction : Map.Direction.values()) {
                Map.Position n = p.getAdjacent(direction);
                if (!map.isValid(n) || visited[n.getX()][n.getY()] || !bounds.contains(n.getX(), n.getY())) continue;
                visited[n.getX()][n.getY()] = true;
                Tile next = map.getTile(n);
                if (next.getRegion() != null && next.getRegion() != region || next.isLand()) continue;
                q.add(n);
            }
        }
    }

    void createLandRegions(Map map) {
        int c;
        ServerRegion[] geographicRegions;
        Game game = map.getGame();
        ServerRegion arctic = new ServerRegion(game, "model.region.arctic", Region.RegionType.LAND);
        ServerRegion antarctic = new ServerRegion(game, "model.region.antarctic", Region.RegionType.LAND);
        map.setRegion(arctic);
        arctic.setPrediscovered(true);
        map.setRegion(antarctic);
        antarctic.setPrediscovered(true);
        int arcticHeight = 2;
        int antarcticHeight = map.getHeight() - 2 - 1;
        for (int x = 0; x < map.getWidth(); ++x) {
            Tile tile;
            int y;
            for (y = 0; y < arcticHeight; ++y) {
                if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                arctic.addTile(tile);
            }
            for (y = antarcticHeight; y < map.getHeight(); ++y) {
                if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                antarctic.addTile(tile);
            }
        }
        int thirdWidth = map.getWidth() / 3;
        int twoThirdWidth = 2 * thirdWidth;
        int thirdHeight = map.getHeight() / 3;
        int twoThirdHeight = 2 * thirdHeight;
        ServerRegion northWest = new ServerRegion(game, "model.region.northWest", Region.RegionType.LAND);
        northWest.setBounds(new Rectangle(0, 0, thirdWidth, thirdHeight));
        ServerRegion north = new ServerRegion(game, "model.region.north", Region.RegionType.LAND);
        north.setBounds(new Rectangle(thirdWidth, 0, thirdWidth, thirdHeight));
        ServerRegion northEast = new ServerRegion(game, "model.region.northEast", Region.RegionType.LAND);
        northEast.setBounds(new Rectangle(twoThirdWidth, 0, map.getWidth() - twoThirdWidth, thirdHeight));
        ServerRegion west = new ServerRegion(game, "model.region.west", Region.RegionType.LAND);
        west.setBounds(new Rectangle(0, thirdHeight, thirdWidth, thirdHeight));
        ServerRegion center = new ServerRegion(game, "model.region.center", Region.RegionType.LAND);
        center.setBounds(new Rectangle(thirdWidth, thirdHeight, thirdWidth, thirdHeight));
        ServerRegion east = new ServerRegion(game, "model.region.east", Region.RegionType.LAND);
        east.setBounds(new Rectangle(twoThirdWidth, thirdHeight, map.getWidth() - twoThirdWidth, thirdHeight));
        ServerRegion southWest = new ServerRegion(game, "model.region.southWest", Region.RegionType.LAND);
        southWest.setBounds(new Rectangle(0, twoThirdHeight, thirdWidth, map.getHeight() - twoThirdHeight));
        ServerRegion south = new ServerRegion(game, "model.region.south", Region.RegionType.LAND);
        south.setBounds(new Rectangle(thirdWidth, twoThirdHeight, thirdWidth, map.getHeight() - twoThirdHeight));
        ServerRegion southEast = new ServerRegion(game, "model.region.southEast", Region.RegionType.LAND);
        southEast.setBounds(new Rectangle(twoThirdWidth, twoThirdHeight, map.getWidth() - twoThirdWidth, map.getHeight() - twoThirdHeight));
        for (ServerRegion region : geographicRegions = new ServerRegion[]{northWest, north, northEast, west, center, east, southWest, south, southEast}) {
            region.setDiscoverable(false);
            map.setRegion(region);
        }
        int continents = 0;
        boolean[][] landmap = new boolean[map.getWidth()][map.getHeight()];
        int[][] continentmap = new int[map.getWidth()][map.getHeight()];
        for (int x = 0; x < map.getWidth(); ++x) {
            for (int y = 0; y < map.getHeight(); ++y) {
                continentmap[x][y] = 0;
                if (!map.isValid(x, y)) continue;
                Tile tile = map.getTile(x, y);
                boolean isMountainRange = false;
                if (tile.getRegion() != null) {
                    boolean bl = isMountainRange = tile.getRegion().getType() == Region.RegionType.MOUNTAIN;
                }
                if (tile.isLand()) {
                    if (y < arcticHeight || y >= antarcticHeight || isMountainRange) {
                        landmap[x][y] = false;
                        continue;
                    }
                    landmap[x][y] = true;
                    continue;
                }
                landmap[x][y] = false;
            }
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                if (!landmap[x][y]) continue;
                ++continents;
                boolean[][] continent = this.floodFill(landmap, new Map.Position(x, y));
                for (int yy = 0; yy < map.getHeight(); ++yy) {
                    for (int xx = 0; xx < map.getWidth(); ++xx) {
                        if (!continent[xx][yy]) continue;
                        continentmap[xx][yy] = continents;
                        landmap[xx][yy] = false;
                    }
                }
            }
        }
        logger.info("Number of individual landmasses is " + continents);
        int[] continentsize = new int[continents + 1];
        int landsize = 0;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                int n = continentmap[x][y];
                continentsize[n] = continentsize[n] + 1;
                if (continentmap[x][y] <= 0) continue;
                ++landsize;
            }
        }
        int oldcontinents = continents;
        for (int c2 = 1; c2 <= oldcontinents; ++c2) {
            if (continentsize[c2] <= 75) continue;
            boolean[][] splitcontinent = new boolean[map.getWidth()][map.getHeight()];
            Map.Position splitposition = new Map.Position(0, 0);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = 0; y < map.getHeight(); ++y) {
                    if (continentmap[x][y] == c2) {
                        splitcontinent[x][y] = true;
                        splitposition = new Map.Position(x, y);
                        continue;
                    }
                    splitcontinent[x][y] = false;
                }
            }
            while (continentsize[c2] > 75) {
                int targetsize = 75;
                if (continentsize[c2] < 150) {
                    targetsize = continentsize[c2] / 2;
                }
                ++continents;
                boolean[][] newregion = this.floodFill(splitcontinent, splitposition, targetsize);
                for (int x = 0; x < map.getWidth(); ++x) {
                    for (int y = 0; y < map.getHeight(); ++y) {
                        if (newregion[x][y]) {
                            continentmap[x][y] = continents;
                            splitcontinent[x][y] = false;
                            int n = c2;
                            continentsize[n] = continentsize[n] - 1;
                        }
                        if (!splitcontinent[x][y]) continue;
                        splitposition = new Map.Position(x, y);
                    }
                }
            }
        }
        logger.info("Number of land regions being created: " + continents);
        ServerRegion[] landregions = new ServerRegion[continents + 1];
        for (c = 1; c <= continents; ++c) {
            landregions[c] = new ServerRegion(map.getGame(), "model.region.land" + c, Region.RegionType.LAND);
            landregions[c].setDiscoverable(true);
            map.setRegion(landregions[c]);
        }
        landsize = 0;
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                if (continentmap[x][y] <= 0) continue;
                Tile tile = map.getTile(x, y);
                landregions[continentmap[x][y]].addTile(tile);
                ++landsize;
            }
        }
        for (c = 1; c <= continents; ++c) {
            ServerRegion sr = landregions[c];
            int score = Math.max((int)((float)sr.getSize() / (float)landsize * 1000.0f), 5);
            sr.setScoreValue(score);
            for (ServerRegion gr : geographicRegions) {
                Map.Position cen = sr.getCenter();
                if (!gr.getBounds().contains(cen.getX(), cen.getY())) continue;
                sr.setParent(gr);
                gr.addChild(sr);
                gr.setSize(gr.getSize() + sr.getSize());
                break;
            }
            logger.fine("Created land region " + sr.getNameKey() + " (size " + sr.getSize() + ", score " + sr.getScoreValue() + ", parent " + (sr.getParent() == null ? "(null)" : sr.getParent().getNameKey()) + ")");
        }
        for (ServerRegion gr : geographicRegions) {
            logger.fine("Geographic region " + gr.getNameKey() + " (size " + gr.getSize() + ", children " + gr.getChildren().size() + ")");
        }
    }

    private void createHighSeas(Map map) {
        TerrainGenerator.createHighSeas(map, this.getMapGeneratorOptions().getInteger("model.option.distanceToHighSea"), this.getMapGeneratorOptions().getInteger("model.option.maximumDistanceToEdge"));
    }

    public static void determineHighSeas(Map map, int distToLandFromHighSeas, int maxDistanceToEdge) {
        TileType ocean = null;
        TileType highSeas = null;
        for (TileType tileType : map.getSpecification().getTileTypeList()) {
            if (!tileType.isWater()) continue;
            if (tileType.hasAbility("model.ability.moveToEurope")) {
                if (highSeas != null) continue;
                highSeas = tileType;
                if (ocean == null) continue;
                break;
            }
            if (ocean != null) continue;
            ocean = tileType;
            if (highSeas == null) continue;
            break;
        }
        if (highSeas == null || ocean == null) {
            throw new RuntimeException("Both Ocean and HighSeas TileTypes must be defined");
        }
        for (Tile tile : map.getAllTiles()) {
            tile.setRegion(null);
            if (tile.getType() != highSeas) continue;
            tile.setType(ocean);
        }
        TerrainGenerator.createHighSeas(map, distToLandFromHighSeas, maxDistanceToEdge);
    }

    private static void createHighSeas(Map map, int distToLandFromHighSeas, int maxDistanceToEdge) {
        if (distToLandFromHighSeas < 0 || maxDistanceToEdge < 0) {
            throw new IllegalArgumentException("The integer arguments cannot be negative.");
        }
        TileType highSeas = null;
        for (TileType t : map.getSpecification().getTileTypeList()) {
            if (!t.isWater() || !t.hasAbility("model.ability.moveToEurope")) continue;
            highSeas = t;
            break;
        }
        if (highSeas == null) {
            throw new RuntimeException("HighSeas TileType is defined by the 'sail-to-europe' attribute");
        }
        for (int y = 0; y < map.getHeight(); ++y) {
            int x;
            for (x = 0; x < maxDistanceToEdge && x < map.getWidth() && !map.isLandWithinDistance(x, y, distToLandFromHighSeas); ++x) {
                if (!map.isValid(x, y)) continue;
                map.getTile(x, y).setType(highSeas);
            }
            for (x = 1; x <= maxDistanceToEdge && x <= map.getWidth() - 1 && !map.isLandWithinDistance(map.getWidth() - x, y, distToLandFromHighSeas); ++x) {
                if (!map.isValid(map.getWidth() - x, y)) continue;
                map.getTile(map.getWidth() - x, y).setType(highSeas);
            }
        }
    }

    private int getLand() {
        return this.mapGeneratorOptions.getInteger("model.option.mapWidth") * this.mapGeneratorOptions.getInteger("model.option.mapHeight") * this.mapGeneratorOptions.getInteger("model.option.landMass") / 100;
    }

    private void createMountains(Map map) {
        Map.Position p;
        int tries;
        float randomHillsRatio = 0.5f;
        int maximumLength = Math.max(this.getMapGeneratorOptions().getInteger("model.option.mapWidth"), this.getMapGeneratorOptions().getInteger("model.option.mapHeight")) / 10;
        int number = (int)((float)(this.getLand() / this.getMapGeneratorOptions().getInteger("model.option.mountainNumber")) * (1.0f - randomHillsRatio));
        logger.info("Number of mountain tiles is " + number);
        logger.fine("Maximum length of mountain ranges is " + maximumLength);
        TileType hills = map.getSpecification().getTileType("model.tile.hills");
        TileType mountains = map.getSpecification().getTileType("model.tile.mountains");
        if (hills == null || mountains == null) {
            throw new RuntimeException("Both Hills and Mountains TileTypes must be defined");
        }
        int counter = 0;
        block0: for (tries = 0; tries < 100; ++tries) {
            if (counter >= number) continue;
            p = this.getRandomLandPosition(map, this.random);
            if (p == null) {
                return;
            }
            Tile startTile = map.getTile(p);
            if (startTile.getType() == hills || startTile.getType() == mountains) continue;
            for (Tile t : startTile.getSurroundingTiles(3)) {
                if (t.getType() != mountains) continue;
                continue block0;
            }
            for (Tile t : startTile.getSurroundingTiles(2)) {
                if (t.isLand()) continue;
                continue block0;
            }
            ServerRegion mountainRegion = new ServerRegion(map.getGame(), "model.region.mountain" + tries, Region.RegionType.MOUNTAIN, startTile.getRegion());
            mountainRegion.setDiscoverable(true);
            mountainRegion.setClaimable(true);
            map.setRegion(mountainRegion);
            Map.Direction direction = Map.Direction.getRandomDirection("getLand", this.random);
            int length = maximumLength - this.random.nextInt(maximumLength / 2);
            for (int index = 0; index < length; ++index) {
                Tile nextTile = map.getTile(p = p.getAdjacent(direction));
                if (nextTile == null || !nextTile.isLand()) continue;
                nextTile.setType(mountains);
                mountainRegion.addTile(nextTile);
                ++counter;
                Map.CircleIterator it = map.getCircleIterator(p, false, 1);
                while (it.hasNext()) {
                    Tile neighborTile = map.getTile((Map.Position)it.next());
                    if (neighborTile == null || !neighborTile.isLand() || neighborTile.getType() == mountains) continue;
                    int r = this.random.nextInt(8);
                    if (r == 0) {
                        neighborTile.setType(mountains);
                        mountainRegion.addTile(neighborTile);
                        ++counter;
                        continue;
                    }
                    if (r <= 2) continue;
                    neighborTile.setType(hills);
                    mountainRegion.addTile(neighborTile);
                }
            }
            int scoreValue = 2 * mountainRegion.getSize();
            mountainRegion.setScoreValue(scoreValue);
            logger.fine("Created mountain region (direction " + (Object)((Object)direction) + ", length " + length + ", size " + mountainRegion.getSize() + ", score value " + scoreValue + ").");
        }
        logger.info("Added " + counter + " mountain range tiles.");
        number = (int)((float)this.getLand() * randomHillsRatio) / this.getMapGeneratorOptions().getInteger("model.option.mountainNumber");
        counter = 0;
        block5: for (tries = 0; tries < 1000; ++tries) {
            Tile t;
            if (counter >= number || (t = map.getTile(p = this.getRandomLandPosition(map, this.random))).getType() == hills || t.getType() == mountains) continue;
            for (Tile tile : t.getSurroundingTiles(3)) {
                if (tile.getType() != mountains) continue;
                continue block5;
            }
            for (Tile tile : t.getSurroundingTiles(1)) {
                if (tile.isLand()) continue;
                continue block5;
            }
            int k = this.random.nextInt(4);
            if (k == 0) {
                t.setType(mountains);
            } else {
                t.setType(hills);
            }
            ++counter;
        }
        logger.info("Added " + counter + " random hills tiles.");
    }

    private void createRivers(Map map) {
        int number = this.getLand() / this.getMapGeneratorOptions().getInteger("model.option.riverNumber");
        int counter = 0;
        HashMap<Map.Position, River> riverMap = new HashMap<Map.Position, River>();
        ArrayList<River> rivers = new ArrayList<River>();
        block0: for (int i = 0; i < number; ++i) {
            block1: for (int tries = 0; tries < 100; ++tries) {
                Map.Position position = this.getRandomLandPosition(map, this.random);
                if (!map.getTile(position).getType().canHaveImprovement(this.riverType)) continue;
                for (Tile neighborTile : map.getTile(position).getSurroundingTiles(2)) {
                    if (neighborTile.isLand()) continue;
                    continue block1;
                }
                if (riverMap.get(position) != null) continue;
                ServerRegion riverRegion = new ServerRegion(map.getGame(), "model.region.river" + i, Region.RegionType.RIVER, map.getTile(position).getRegion());
                riverRegion.setDiscoverable(true);
                riverRegion.setClaimable(true);
                River river = new River(map, riverMap, riverRegion, this.random);
                if (river.flowFromSource(position)) {
                    logger.fine("Created new river with length " + river.getLength());
                    map.setRegion(riverRegion);
                    rivers.add(river);
                    ++counter;
                    continue block0;
                }
                logger.fine("Failed to generate river.");
            }
        }
        logger.info("Created " + counter + " rivers of maximum " + number + ".");
        for (River river : rivers) {
            ServerRegion region = river.getRegion();
            int scoreValue = 0;
            for (RiverSection section : river.getSections()) {
                scoreValue += section.getSize();
            }
            region.setScoreValue(scoreValue *= 2);
            logger.fine("Created river region (length " + river.getLength() + ", score value " + scoreValue + ").");
        }
    }

    private void findLakes(Map map) {
        Game game = map.getGame();
        ServerRegion inlandlakes = new ServerRegion(game, "model.region.inlandlakes", Region.RegionType.LAKE);
        map.setRegion(inlandlakes);
        inlandlakes.setPrediscovered(true);
        Map.Position p = null;
        block0: for (int x : new int[]{0, map.getWidth() - 1}) {
            for (int y = 0; y < map.getHeight(); ++y) {
                Tile tile = map.getTile(x, y);
                if (tile == null || tile.getType() == null || tile.isLand()) continue;
                p = new Map.Position(x, y);
                continue block0;
            }
        }
        if (p == null) {
            logger.warning("Find lakes: unable to find entry point.");
            return;
        }
        boolean[][] watermap = new boolean[map.getWidth()][map.getHeight()];
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                watermap[x][y] = !map.getTile(x, y).isLand();
            }
        }
        boolean[][] visited = this.floodFill(watermap, p);
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                Tile tile;
                if (!watermap[x][y] || visited[x][y] || (tile = map.getTile(x, y)) == null) continue;
                tile.setType(this.lake);
                inlandlakes.addTile(tile);
            }
        }
    }

    private boolean[][] floodFill(boolean[][] boolmap, Map.Position p, int limit) {
        LinkedList<Map.Position> q = new LinkedList<Map.Position>();
        boolean[][] visited = new boolean[boolmap.length][boolmap[0].length];
        visited[p.getX()][p.getY()] = true;
        --limit;
        do {
            for (Map.Direction direction : Map.Direction.values()) {
                Map.Position n = p.getAdjacent(direction);
                if (!Map.isValid(n, boolmap.length, boolmap[0].length) || !boolmap[n.getX()][n.getY()] || visited[n.getX()][n.getY()] || limit <= 0) continue;
                visited[n.getX()][n.getY()] = true;
                --limit;
                q.add(n);
            }
        } while ((p = (Map.Position)q.poll()) != null && limit > 0);
        return visited;
    }

    private boolean[][] floodFill(boolean[][] boolmap, Map.Position p) {
        return this.floodFill(boolmap, p, Integer.MAX_VALUE);
    }
}

