/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;
import org.w3c.dom.Element;

public class WishRealizationMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WishRealizationMission.class.getName());
    private Wish wish;

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, Wish wish) {
        super(aiMain, aiUnit);
        this.wish = wish;
        if (wish == null) {
            throw new NullPointerException("wish == null");
        }
    }

    public WishRealizationMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public WishRealizationMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void dispose() {
        if (this.wish != null) {
            this.wish.setTransportable(null);
            this.wish = null;
        }
        super.dispose();
    }

    public void doMission(Connection connection) {
        if (!this.isValid()) {
            return;
        }
        if (this.getUnit().getTile() != null) {
            Map.Direction r;
            if (!(this.wish.getDestination().getTile() == this.getUnit().getTile() || (r = this.moveTowards(this.wish.getDestination().getTile())) != null && this.moveButDontAttack(r))) {
                return;
            }
            if (this.wish.getDestination().getTile() == this.getUnit().getTile()) {
                if (this.wish.getDestination() instanceof Colony) {
                    Colony colony = (Colony)this.wish.getDestination();
                    WorkLocation loc = colony.getVacantWorkLocationFor(this.getUnit());
                    if (this.getUnit().getLocation() == loc) {
                        this.wish = null;
                    } else if (AIMessage.askWork(this.getAIUnit(), loc)) {
                        this.getAIUnit().setMission(new WorkInsideColonyMission(this.getAIMain(), this.getAIUnit(), this.getAIMain().getAIColony(colony)));
                    } else {
                        logger.warning("AIunit " + this.getAIUnit().getId() + " could not work in " + colony.getId());
                    }
                } else {
                    logger.warning("Unknown type of destination for: " + this.wish);
                }
            }
        }
    }

    public Tile getTransportDestination() {
        if (this.getUnit().isOnCarrier()) {
            return this.wish.getDestination().getTile();
        }
        if (this.getUnit().getTile() == this.wish.getDestination().getTile()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.wish.getDestination().getTile()) == null) {
            return this.wish.getDestination().getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getUnit().isOnCarrier()) {
            return 100;
        }
        if (this.getUnit().getLocation().getTile() == this.wish.getDestination().getTile()) {
            return 0;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.wish.getDestination().getTile()) == null) {
            return 100;
        }
        return 0;
    }

    public boolean isValid() {
        Location loc;
        return !(!super.isValid() || this.wish == null || (loc = this.wish.getDestination()) == null || ((FreeColGameObject)((Object)loc)).isDisposed() || loc instanceof Ownable && ((Ownable)((Object)loc)).getOwner() != this.getUnit().getOwner() || loc instanceof Colony && ((Colony)loc).getVacantWorkLocationFor(this.getUnit()) == null);
    }

    public String getDebuggingInfo() {
        if (this.wish == null) {
            return "No wish";
        }
        return this.wish.getDestination().getTile().getPosition() + " " + this.wish.getValue();
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.wish.shouldBeStored()) {
            this.toXML(out, WishRealizationMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("wish", this.wish.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.wish = (Wish)this.getAIMain().getAIObject(in.getAttributeValue(null, "wish"));
        if (this.wish == null) {
            String wid = in.getAttributeValue(null, "wish");
            if (wid.startsWith(GoodsWish.getXMLElementTagName()) || wid.startsWith("GoodsWish")) {
                this.wish = new GoodsWish(this.getAIMain(), wid);
            } else if (wid.startsWith(WorkerWish.getXMLElementTagName())) {
                this.wish = new WorkerWish(this.getAIMain(), wid);
            } else {
                logger.warning("Unknown type of Wish.");
            }
        }
    }

    public static String getXMLElementTagName() {
        return "wishRealizationMission";
    }
}

