/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class DefendSettlementMission
extends Mission {
    private static final Logger logger = Logger.getLogger(DefendSettlementMission.class.getName());
    private Settlement settlement;

    public DefendSettlementMission(AIMain aiMain, AIUnit aiUnit, Settlement settlement) {
        super(aiMain, aiUnit);
        this.settlement = settlement;
    }

    public DefendSettlementMission(AIMain aiMain, Element element) {
        super(aiMain);
        this.readFromXMLElement(element);
    }

    public DefendSettlementMission(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain);
        this.readFromXML(in);
    }

    public void doMission(Connection connection) {
        Map.Direction r;
        Unit unit = this.getUnit();
        if (!this.isValid() || unit.getTile() == null) {
            return;
        }
        Tile settlementTile = this.settlement.getTile();
        if (!(unit.getTile() == settlementTile || (r = this.moveTowards(settlementTile)) != null && this.moveButDontAttack(r))) {
            return;
        }
        int defenderCount = 0;
        int fortifiedCount = 0;
        List<Unit> units = this.settlement.getUnitList();
        units.addAll(settlementTile.getUnitList());
        for (Unit u : units) {
            if (!unit.isOffensiveUnit()) continue;
            ++defenderCount;
            if (unit.getState() != Unit.UnitState.FORTIFIED) continue;
            ++fortifiedCount;
        }
        if (defenderCount <= 2 || fortifiedCount <= 1) {
            if (unit.getTile() == settlementTile && unit.getState() != Unit.UnitState.FORTIFIED && unit.getState() != Unit.UnitState.FORTIFYING && unit.checkSetState(Unit.UnitState.FORTIFYING)) {
                AIMessage.askChangeState(this.getAIUnit(), Unit.UnitState.FORTIFYING);
            }
            return;
        }
        if (!unit.isOffensiveUnit()) {
            return;
        }
        CombatModel combatModel = unit.getGame().getCombatModel();
        Unit bestTarget = null;
        float bestDifference = Float.MIN_VALUE;
        Map.Direction bestDirection = null;
        for (Map.Direction direction : Map.Direction.getRandomDirections("defendSettlements", this.getAIRandom())) {
            float weDefend;
            float enemyDefend;
            Unit defender;
            Tile t = unit.getTile().getNeighbourOrNull(direction);
            if (t == null || (defender = t.getFirstUnit()) == null || !defender.getOwner().atWarWith(unit.getOwner()) || !unit.getMoveType(direction).isAttack()) continue;
            Unit enemyUnit = t.getDefendingUnit(unit);
            float enemyAttack = combatModel.getOffencePower(enemyUnit, unit);
            float weAttack = combatModel.getOffencePower(unit, enemyUnit);
            float difference = weAttack / (weAttack + (enemyDefend = combatModel.getDefencePower(unit, enemyUnit))) - enemyAttack / (enemyAttack + (weDefend = combatModel.getDefencePower(enemyUnit, unit)));
            if (!(difference > bestDifference) || !(difference > 0.0f) && !(weAttack > enemyDefend)) continue;
            bestDifference = difference;
            bestTarget = enemyUnit;
            bestDirection = direction;
        }
        if (bestTarget != null) {
            AIMessage.askAttack(this.getAIUnit(), bestDirection);
        }
    }

    public Tile getTransportDestination() {
        if (this.settlement == null) {
            return null;
        }
        if (this.getUnit().isOnCarrier()) {
            return this.settlement.getTile();
        }
        if (this.getUnit().getLocation().getTile() == this.settlement.getTile()) {
            return null;
        }
        if (this.getUnit().getTile() == null || this.getUnit().findPath(this.settlement.getTile()) == null) {
            return this.settlement.getTile();
        }
        return null;
    }

    public int getTransportPriority() {
        if (this.getTransportDestination() != null) {
            return 105;
        }
        return 0;
    }

    public Settlement getSettlement() {
        return this.settlement;
    }

    public boolean isValid() {
        return super.isValid() && this.settlement != null && !this.settlement.isDisposed() && this.settlement.getOwner() == this.getUnit().getOwner() && this.getUnit().isDefensiveUnit();
    }

    public String getDebuggingInfo() {
        String name = this.settlement instanceof Colony ? ((Colony)this.settlement).getName() : "";
        return this.settlement.getTile().getPosition().toString() + " " + name;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXML(out, DefendSettlementMission.getXMLElementTagName());
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.settlement != null) {
            out.writeAttribute("settlement", this.settlement.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.settlement = (Settlement)this.getGame().getFreeColGameObject(in.getAttributeValue(null, "settlement"));
    }

    public static String getXMLElementTagName() {
        return "defendSettlementMission";
    }
}

