/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.WorkLocationPlan;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColonyPlan {
    private static final Logger logger = Logger.getLogger(ColonyPlan.class.getName());
    private static final int LOW_PRODUCTION_THRESHOLD = 1;
    private static final int PRODUCTION_TURNOVER_TURNS = 5;
    private ProfileType profileType;
    private AIMain aiMain;
    private Colony colony;
    private final List<BuildPlan> buildPlans = new ArrayList<BuildPlan>();
    private static final Comparator<BuildPlan> buildPlanComparator = new Comparator<BuildPlan>(){

        @Override
        public int compare(BuildPlan b1, BuildPlan b2) {
            double d = b1.getValue() - b2.getValue();
            return d > 0.0 ? -1 : (d < 0.0 ? 1 : 0);
        }
    };
    private final List<WorkLocationPlan> workPlans = new ArrayList<WorkLocationPlan>();
    private final List<GoodsType> produce = new ArrayList<GoodsType>();
    private final List<GoodsType> foodGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> libertyGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> immigrationGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> militaryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> rawBuildingGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> buildingGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> rawLuxuryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> luxuryGoodsTypes = new ArrayList<GoodsType>();
    private final List<GoodsType> otherRawGoodsTypes = new ArrayList<GoodsType>();
    private static final double BREEDING_WEIGHT = 0.1;
    private static final double BUILDING_WEIGHT = 0.9;
    private static final double DEFENCE_WEIGHT = 0.1;
    private static final double EXPORT_WEIGHT = 0.6;
    private static final double FISH_WEIGHT = 0.25;
    private static final double FORTIFY_WEIGHT = 0.3;
    private static final double IMMIGRATION_WEIGHT = 0.05;
    private static final double LIBERTY_WEIGHT = 0.75;
    private static final double MILITARY_WEIGHT = 0.4;
    private static final double PRODUCTION_WEIGHT = 0.25;
    private static final double REPAIR_WEIGHT = 0.1;
    private static final double STORAGE_WEIGHT = 0.85;
    private static final double TEACH_WEIGHT = 0.2;
    private static final double TRANSPORT_WEIGHT = 0.15;

    public ColonyPlan(AIMain aiMain, Colony colony) {
        if (aiMain == null) {
            throw new IllegalArgumentException("Null AIMain");
        }
        if (colony == null) {
            throw new IllegalArgumentException("Null colony");
        }
        this.aiMain = aiMain;
        this.colony = colony;
        this.profileType = ProfileType.getProfileTypeFromSize(colony.getUnitCount());
    }

    public ColonyPlan(AIMain aiMain, Element element) {
        this.aiMain = aiMain;
        this.readFromXMLElement(element);
    }

    private AIMain getAIMain() {
        return this.aiMain;
    }

    private Colony getColony() {
        return this.colony;
    }

    private Specification spec() {
        return this.aiMain.getGame().getSpecification();
    }

    private int getWorkLocationProduction(WorkLocation wl, GoodsType goodsType) {
        return wl.getPotentialProduction(this.spec().getDefaultUnitType(), goodsType);
    }

    public List<GoodsType> getPreferredProduction() {
        return new ArrayList<GoodsType>(this.produce);
    }

    public List<BuildableType> getBuildableTypes() {
        ArrayList<BuildableType> build = new ArrayList<BuildableType>();
        for (BuildPlan b : this.buildPlans) {
            build.add(b.type);
        }
        return build;
    }

    public BuildableType getBestBuildableType() {
        for (BuildPlan b : this.buildPlans) {
            if (!this.colony.canBuild(b.type)) continue;
            return b.type;
        }
        return null;
    }

    public List<WorkLocationPlan> getFoodPlans() {
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>();
        for (WorkLocationPlan wlp : this.workPlans) {
            if (!wlp.getGoodsType().isFoodType() || wlp.getWorkLocation().canAutoProduce()) continue;
            plans.add(wlp);
        }
        return plans;
    }

    public List<WorkLocationPlan> getWorkPlans() {
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>();
        for (WorkLocationPlan wlp : this.workPlans) {
            if (wlp.getGoodsType().isFoodType() || wlp.getWorkLocation().canAutoProduce()) continue;
            plans.add(wlp);
        }
        return plans;
    }

    public void update() {
        UnitType defaultUnitType = this.spec().getDefaultUnitType();
        this.profileType = ProfileType.getProfileTypeFromSize(this.colony.getUnitCount());
        Map<GoodsType, Map<WorkLocation, Integer>> production = this.createProductionMap();
        this.updateGoodsTypeLists(production);
        this.updateRawMaterials(production);
        this.updateBuildableTypes();
        this.updatePlans(production);
    }

    public List<AbstractGoods> getRequiredGoods(BuildableType buildable) {
        ArrayList<AbstractGoods> required = new ArrayList<AbstractGoods>();
        if (buildable != null && buildable.getGoodsRequired() != null) {
            for (AbstractGoods ag : buildable.getGoodsRequired()) {
                int amount = ag.getAmount();
                for (GoodsType type = ag.getType(); type != null && amount > this.colony.getGoodsCount(type); type = type.getRawMaterial()) {
                    required.add(0, new AbstractGoods(type, amount - this.colony.getGoodsCount(type)));
                }
            }
        }
        return required;
    }

    public void refine(BuildableType build) {
        ArrayList<GoodsType> required = new ArrayList<GoodsType>();
        for (AbstractGoods ag : this.getRequiredGoods(build)) {
            required.add(ag.getType());
        }
        HashMap<GoodsType, ArrayList<WorkLocationPlan>> suppressed = new HashMap<GoodsType, ArrayList<WorkLocationPlan>>();
        ArrayList<WorkLocationPlan> plans = new ArrayList<WorkLocationPlan>(this.workPlans);
        int offset = 0;
        for (int i = 0; i < plans.size(); ++i) {
            List wls;
            WorkLocationPlan wlp = (WorkLocationPlan)plans.get(i);
            GoodsType g = wlp.getGoodsType();
            if (this.rawBuildingGoodsTypes.contains(g) && !required.contains(g.getProducedMaterial()) || this.buildingGoodsTypes.contains(g) && !required.contains(g)) {
                this.workPlans.remove(i - offset);
                ++offset;
                wls = (ArrayList<WorkLocationPlan>)suppressed.get(g);
                if (wls == null) {
                    wls = new ArrayList<WorkLocationPlan>();
                }
                wls.add(0, wlp);
                suppressed.put(g, (ArrayList<WorkLocationPlan>)wls);
                this.produce.remove(g);
                logger.finest("At " + this.colony.getName() + " suppress production of " + g);
                continue;
            }
            if (!g.isRefined() || !this.rawBuildingGoodsTypes.contains(g.getRawMaterial()) && !this.buildingGoodsTypes.contains(g.getRawMaterial())) continue;
            int n = 0;
            int idx = this.produce.indexOf(g);
            for (GoodsType type = g.getRawMaterial(); type != null && (wls = (List)suppressed.get(type)) != null && this.colony.getGoodsCount(type) < 50; type = type.getRawMaterial()) {
                n += wls.size();
                while (!wls.isEmpty()) {
                    this.workPlans.add(i - offset, (WorkLocationPlan)wls.remove(0));
                }
                this.produce.add(idx, type);
                logger.finest("At " + this.colony.getName() + " restore production of " + type);
            }
            offset -= n;
        }
    }

    private Map<GoodsType, Map<WorkLocation, Integer>> createProductionMap() {
        HashMap<GoodsType, Map<WorkLocation, Integer>> production = new HashMap<GoodsType, Map<WorkLocation, Integer>>();
        for (WorkLocation wl : this.colony.getAvailableWorkLocations()) {
            for (GoodsType g : this.spec().getGoodsTypeList()) {
                int p = this.getWorkLocationProduction(wl, g);
                if (p <= 0) continue;
                HashMap<WorkLocation, Integer> m = (HashMap<WorkLocation, Integer>)production.get(g);
                if (m == null) {
                    m = new HashMap<WorkLocation, Integer>();
                    production.put(g, m);
                }
                m.put(wl, new Integer(p));
            }
        }
        return production;
    }

    private void updateGoodsTypeLists(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.foodGoodsTypes.clear();
        this.libertyGoodsTypes.clear();
        this.immigrationGoodsTypes.clear();
        this.militaryGoodsTypes.clear();
        this.rawBuildingGoodsTypes.clear();
        this.buildingGoodsTypes.clear();
        this.rawLuxuryGoodsTypes.clear();
        this.luxuryGoodsTypes.clear();
        this.otherRawGoodsTypes.clear();
        for (GoodsType g : new ArrayList<GoodsType>(production.keySet())) {
            if (g.isFoodType()) {
                this.foodGoodsTypes.add(g);
                continue;
            }
            if (g.isLibertyType()) {
                this.libertyGoodsTypes.add(g);
                continue;
            }
            if (g.isImmigrationType()) {
                this.immigrationGoodsTypes.add(g);
                continue;
            }
            if (g.isMilitaryGoods()) {
                this.militaryGoodsTypes.add(g);
                continue;
            }
            if (g.isRawBuildingMaterial()) {
                this.rawBuildingGoodsTypes.add(g);
                continue;
            }
            if (g.isBuildingMaterial() && g.getRawMaterial().isRawBuildingMaterial()) {
                this.buildingGoodsTypes.add(g);
                continue;
            }
            if (g.isNewWorldGoodsType()) {
                this.rawLuxuryGoodsTypes.add(g);
                continue;
            }
            if (g.isRefined() && g.getRawMaterial().isNewWorldGoodsType()) {
                this.luxuryGoodsTypes.add(g);
                continue;
            }
            if (g.isFarmed()) {
                this.otherRawGoodsTypes.add(g);
                continue;
            }
            logger.warning("Ignoring goods type " + g + " at " + this.colony.getName());
            production.remove(g);
        }
    }

    private void updateRawMaterials(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        Player player = this.colony.getOwner();
        Market market = player.getMarket();
        NationType nationType = player.getNationType();
        GoodsType primaryRawMaterial = null;
        GoodsType secondaryRawMaterial = null;
        int primaryValue = -1;
        int secondaryValue = -1;
        this.produce.clear();
        ArrayList<GoodsType> rawMaterials = new ArrayList<GoodsType>(this.rawLuxuryGoodsTypes);
        rawMaterials.addAll(this.otherRawGoodsTypes);
        for (GoodsType g : rawMaterials) {
            int value = 0;
            for (Map.Entry<WorkLocation, Integer> e : production.get(g).entrySet()) {
                value += e.getValue().intValue();
            }
            if (value <= 1) {
                production.remove(g);
                continue;
            }
            if (market != null) {
                if (g.getProducedMaterial() == null) {
                    value *= market.getSalePrice(g, 1);
                } else if (production.containsKey(g.getProducedMaterial())) {
                    value *= (market.getSalePrice(g, 1) + market.getSalePrice(g.getProducedMaterial(), 1)) / 2;
                }
            }
            if (!nationType.getModifierSet(g.getId()).isEmpty()) {
                value = value * 12 / 10;
            }
            if (value > secondaryValue && secondaryRawMaterial != null) {
                production.remove(secondaryRawMaterial);
                production.remove(secondaryRawMaterial.getProducedMaterial());
                if (this.rawLuxuryGoodsTypes.contains(secondaryRawMaterial)) {
                    this.rawLuxuryGoodsTypes.remove(secondaryRawMaterial);
                    this.luxuryGoodsTypes.remove(secondaryRawMaterial.getProducedMaterial());
                } else if (rawMaterials.contains(this.otherRawGoodsTypes)) {
                    rawMaterials.remove(this.otherRawGoodsTypes);
                }
            }
            if (value > primaryValue) {
                secondaryRawMaterial = primaryRawMaterial;
                secondaryValue = primaryValue;
                primaryRawMaterial = g;
                primaryValue = value;
                continue;
            }
            if (value <= secondaryValue) continue;
            secondaryRawMaterial = g;
            secondaryValue = value;
        }
        if (primaryRawMaterial != null) {
            this.produce.add(primaryRawMaterial);
            if (primaryRawMaterial.getProducedMaterial() != null) {
                this.produce.add(primaryRawMaterial.getProducedMaterial());
            }
            if (secondaryRawMaterial != null) {
                this.produce.add(secondaryRawMaterial);
                if (secondaryRawMaterial.getProducedMaterial() != null) {
                    this.produce.add(secondaryRawMaterial.getProducedMaterial());
                }
            }
        }
    }

    private BuildPlan findBuildPlan(BuildableType type) {
        for (BuildPlan bp : this.buildPlans) {
            if (bp.type != type) continue;
            return bp;
        }
        return null;
    }

    private boolean prioritize(BuildableType type, double weight, double support) {
        BuildPlan bp = this.findBuildPlan(type);
        if (bp == null) {
            this.buildPlans.add(new BuildPlan(type, weight, support));
            return true;
        }
        if (bp.weight * bp.support < weight * support) {
            bp.weight = weight;
            bp.support = support;
            return true;
        }
        return false;
    }

    private boolean prioritizeProduction(BuildableType type, GoodsType goodsType) {
        Player player = this.colony.getOwner();
        NationType nationType = player.getNationType();
        String advantage = this.getAIMain().getAIPlayer(player).getAIAdvantage();
        boolean ret = false;
        double factor = 1.0;
        if (!nationType.getModifierSet(goodsType.getId()).isEmpty()) {
            factor *= 1.2;
        }
        if (goodsType.isMilitaryGoods()) {
            if ("conquest".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.4 * factor, 1.0);
        } else if (goodsType.isBuildingMaterial()) {
            ret = this.prioritize(type, 0.9 * factor, 1.0);
        } else if (goodsType.isLibertyType()) {
            ret = this.prioritize(type, 0.75, this.colony.getSoL() >= 100 ? 0.01 : 1.0);
        } else if (goodsType.isImmigrationType()) {
            if ("immigration".equals(advantage)) {
                factor = 1.2;
            }
            ret = this.prioritize(type, 0.05 * factor, 1.0);
        } else if (this.produce.contains(goodsType)) {
            if ("trade".equals(advantage)) {
                factor = 1.2;
            }
            double f = 0.1 * (double)this.colony.getProductionOf(goodsType.getRawMaterial());
            ret = this.prioritize(type, 0.25, f);
        }
        return ret;
    }

    private void updateBuildableTypes() {
        int maxLevel;
        String advantage = this.getAIMain().getAIPlayer(this.colony.getOwner()).getAIAdvantage();
        this.buildPlans.clear();
        switch (this.profileType) {
            case OUTPOST: 
            case SMALL: {
                maxLevel = 1;
                break;
            }
            case MEDIUM: {
                maxLevel = 2;
                break;
            }
            case LARGE: {
                maxLevel = 3;
                break;
            }
            case CAPITAL: {
                maxLevel = 4;
                break;
            }
            default: {
                throw new IllegalStateException("Bogus profile type: " + (Object)((Object)this.profileType));
            }
        }
        Player player = this.colony.getOwner();
        for (BuildingType type : this.spec().getBuildingTypeList()) {
            GoodsType output;
            double factor;
            boolean expectFail = false;
            if (!this.colony.canBuild(type)) continue;
            if (!type.getModifierSet("model.modifier.defence").isEmpty()) {
                factor = 1.0;
                if ("conquest".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.3 * factor, 1.0);
            }
            if (type.hasAbility("model.ability.export")) {
                factor = 1.0;
                if ("trade".equals(advantage)) {
                    factor = 1.1;
                }
                this.prioritize(type, 0.6 * factor, 1.0);
            }
            if (type.getLevel() > maxLevel) continue;
            if (type.hasAbility("model.ability.produceInWater") && !this.colony.hasAbility("model.ability.produceInWater") && this.colony.getTile().isCoast()) {
                int landFood = 0;
                int seaFood = 0;
                for (Tile t : this.colony.getTile().getSurroundingTiles(1)) {
                    if (t.getOwningSettlement() != this.colony && !player.canClaimForSettlement(t)) continue;
                    for (AbstractGoods ag : t.getSortedPotential()) {
                        if (!ag.getType().isFoodType()) continue;
                        if (t.isLand()) {
                            landFood += ag.getAmount();
                            continue;
                        }
                        seaFood += ag.getAmount();
                    }
                }
                if (seaFood > 0) {
                    this.prioritize(type, 0.25, (double)seaFood / (double)(seaFood + landFood));
                }
            }
            if (type.hasAbility("model.ability.build")) {
                double factor2 = 1.0;
                if ("building".equals(advantage)) {
                    factor2 = 1.1;
                }
                double support = 1.0;
                for (Ability a : type.getFeatureContainer().getAbilitySet("model.ability.build")) {
                    List<Scope> scopes = a.getScopes();
                    if (scopes == null || scopes.isEmpty()) continue;
                    support = 0.1;
                }
                this.prioritize(type, 0.9 * factor2, support);
            }
            if (type.hasAbility("model.ability.teach")) {
                this.prioritize(type, 0.2, 1.0);
            }
            if (type.hasAbility("model.ability.repairUnits")) {
                double factor3 = 1.0;
                if ("naval".equals(advantage)) {
                    factor3 = 1.1;
                }
                this.prioritize(type, 0.1 * factor3, 1.0);
            }
            if ((output = type.getProducedGoodsType()) != null) {
                if (!this.prioritizeProduction(type, output)) {
                    expectFail = true;
                }
            } else {
                for (GoodsType g : this.spec().getGoodsTypeList()) {
                    if (type.getModifierSet(g.getId()).isEmpty() || this.prioritizeProduction(type, g)) continue;
                    expectFail = true;
                }
                if (!type.getModifierSet("model.modifier.warehouseStorage").isEmpty()) {
                    double factor4 = 1.0;
                    if ("trade".equals(advantage)) {
                        factor4 = 1.1;
                    }
                    this.prioritize(type, 0.85 * factor4, 1.0);
                }
                if (!type.getModifierSet("model.modifier.breedingDivisor").isEmpty()) {
                    this.prioritize(type, 0.1, 1.0);
                }
            }
            if (this.findBuildPlan(type) != null || expectFail) continue;
            logger.warning("No building priority found for: " + type);
        }
        double wagonNeed = 0.0;
        if (!this.colony.isConnected()) {
            int wagons = 0;
            for (Unit u : player.getUnits()) {
                if (!u.hasAbility("model.ability.carryGoods") || u.isNaval()) continue;
                ++wagons;
            }
            int inland = 0;
            for (Colony c : player.getColonies()) {
                if (c.isConnected()) continue;
                ++inland;
            }
            if (inland > wagons) {
                wagonNeed = (double)(inland - wagons) / (double)inland;
            }
        }
        for (UnitType unitType : this.spec().getUnitTypeList()) {
            if (!this.colony.canBuild(unitType) || unitType.hasAbility("model.ability.navalUnit")) continue;
            if (unitType.getDefence() > 1) {
                if (!AIColony.isBadlyDefended(this.colony)) continue;
                this.prioritize(unitType, 0.1, 1.0);
                continue;
            }
            if (!unitType.hasAbility("model.ability.carryGoods") || !(wagonNeed > 0.0)) continue;
            double factor = 1.0;
            if ("trade".equals(advantage)) {
                factor = 1.1;
            }
            this.prioritize(unitType, 0.15 * factor, wagonNeed);
        }
        for (BuildPlan bp : this.buildPlans) {
            double difficulty = 0.0;
            for (AbstractGoods ag : bp.type.getGoodsRequired()) {
                GoodsType g = ag.getType();
                int need = ag.getAmount() - this.colony.getGoodsCount(g);
                if (need <= 0) continue;
                double f = this.produce.contains(g.getRawMaterial()) ? 1.0 : 5.0;
                difficulty += (double)need * f;
            }
            bp.difficulty = Math.max(1.0, Math.sqrt(difficulty));
        }
        Collections.sort(this.buildPlans, buildPlanComparator);
    }

    private void updatePlans(Map<GoodsType, Map<WorkLocation, Integer>> production) {
        this.workPlans.clear();
        for (GoodsType g : production.keySet()) {
            if (g.isStorable() && this.colony.getGoodsCount(g) >= this.colony.getWarehouseCapacity() && !g.limitIgnored()) continue;
            for (WorkLocation wl : production.get(g).keySet()) {
                if (!wl.canBeWorked() && !wl.canAutoProduce()) continue;
                this.workPlans.add(new WorkLocationPlan(this.getAIMain(), wl, g));
            }
        }
        this.updateProductionList(production);
        ArrayList<WorkLocationPlan> oldPlans = new ArrayList<WorkLocationPlan>(this.workPlans);
        this.workPlans.clear();
        for (WorkLocationPlan wlp : oldPlans) {
            if (!wlp.getWorkLocation().canBeWorked()) continue;
            this.workPlans.add(wlp);
        }
        Collections.sort(this.workPlans, new Comparator<WorkLocationPlan>(){

            @Override
            public int compare(WorkLocationPlan w1, WorkLocationPlan w2) {
                int cmp;
                GoodsType g1 = w1.getGoodsType();
                GoodsType g2 = w2.getGoodsType();
                int i1 = ColonyPlan.this.produce.indexOf(g1);
                int i2 = ColonyPlan.this.produce.indexOf(g2);
                if (i1 < 0 && !g1.isFoodType()) {
                    i1 = 99999;
                }
                if (i2 < 0 && !g2.isFoodType()) {
                    i2 = 99999;
                }
                if ((cmp = i1 - i2) == 0) {
                    cmp = ColonyPlan.this.getWorkLocationProduction(w2.getWorkLocation(), g2) - ColonyPlan.this.getWorkLocationProduction(w1.getWorkLocation(), g1);
                }
                return cmp;
            }
        });
    }

    private void updateProductionList(final Map<GoodsType, Map<WorkLocation, Integer>> production) {
        GoodsType raw;
        Comparator<GoodsType> productionComparator = new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                int p1 = 0;
                for (Integer i : ((Map)production.get(g1)).values()) {
                    p1 += i.intValue();
                }
                int p2 = 0;
                for (Integer i : ((Map)production.get(g2)).values()) {
                    p2 += i.intValue();
                }
                return p2 - p1;
            }
        };
        ArrayList<GoodsType> toAdd = new ArrayList<GoodsType>();
        if (this.colony.getSoL() < 100) {
            for (GoodsType g : this.libertyGoodsTypes) {
                if (!production.containsKey(g)) continue;
                toAdd.add(g);
            }
            Collections.sort(toAdd, productionComparator);
            this.produce.addAll(0, toAdd);
            toAdd.clear();
        }
        Collections.sort(this.rawBuildingGoodsTypes, productionComparator);
        for (GoodsType g : this.buildingGoodsTypes) {
            if (!production.containsKey(g) || this.colony.getGoodsCount(raw = g.getRawMaterial()) < 50 && !production.containsKey(raw)) continue;
            toAdd.add(g);
        }
        Collections.sort(toAdd, new Comparator<GoodsType>(){

            @Override
            public int compare(GoodsType g1, GoodsType g2) {
                int i1 = ColonyPlan.this.rawBuildingGoodsTypes.indexOf(g1.getRawMaterial());
                int i2 = ColonyPlan.this.rawBuildingGoodsTypes.indexOf(g2.getRawMaterial());
                return i1 - i2;
            }
        });
        for (int i = toAdd.size() - 1; i >= 0; --i) {
            GoodsType make = (GoodsType)toAdd.get(i);
            raw = make.getRawMaterial();
            if (production.containsKey(raw)) {
                if (this.colony.getGoodsCount(raw) >= 50) {
                    this.produce.add(raw);
                    this.produce.add(0, make);
                    continue;
                }
                this.produce.add(0, make);
                this.produce.add(0, raw);
                continue;
            }
            this.produce.add(0, make);
        }
        toAdd.clear();
        for (GoodsType g : this.militaryGoodsTypes) {
            if (!production.containsKey(g)) continue;
            toAdd.add(g);
        }
        Collections.sort(toAdd, productionComparator);
        this.produce.addAll(toAdd);
        toAdd.clear();
        if (this.colony.getOwner().getEurope() != null) {
            for (GoodsType g : this.immigrationGoodsTypes) {
                if (!production.containsKey(g)) continue;
                toAdd.add(g);
            }
            Collections.sort(toAdd, productionComparator);
            this.produce.addAll(toAdd);
            toAdd.clear();
        }
    }

    private boolean equipUnit(Unit unit, Unit.Role role, Colony colony) {
        List<EquipmentType> equipment;
        if (role == Unit.Role.SOLDIER) {
            role = Unit.Role.DRAGOON;
        }
        if ((equipment = role.getRoleEquipment(this.spec())).isEmpty() || !unit.isPerson()) {
            return false;
        }
        boolean result = false;
        for (EquipmentType et : equipment) {
            if (!colony.canProvideEquipment(et) || !unit.canBeEquippedWith(et)) continue;
            unit.setLocation(colony.getTile());
            unit.changeEquipment(et, 1);
            colony.addEquipmentGoods(et, -1);
            result = true;
        }
        return result;
    }

    private Unit trySwapExpert(Unit expert, List<Unit> others) {
        GoodsType work = expert.getType().getExpertProduction();
        GoodsType oldWork = expert.getWorkType();
        for (int i = 0; i < others.size(); ++i) {
            Unit other = others.get(i);
            if (!other.isPerson() || other.getWorkType() != work || other.getType().getExpertProduction() == work) continue;
            Location l1 = expert.getLocation();
            Location l2 = other.getLocation();
            other.setLocation(this.colony.getTile());
            expert.setLocation(l2);
            expert.setWorkType(work);
            other.setLocation(l1);
            if (oldWork != null) {
                other.setWorkType(oldWork);
            }
            TypeCountMap<EquipmentType> equipment = expert.getEquipment();
            for (EquipmentType e : new ArrayList<EquipmentType>(equipment.keySet())) {
                int n = equipment.getCount(e);
                expert.changeEquipment(e, -n);
                other.changeEquipment(e, n);
            }
            return other;
        }
        return null;
    }

    private WorkLocationPlan findPlan(GoodsType goodsType, List<WorkLocationPlan> plans) {
        for (WorkLocationPlan wlp : plans) {
            if (wlp.getGoodsType() != goodsType) continue;
            return wlp;
        }
        return null;
    }

    public static Unit getBestWorker(WorkLocation wl, GoodsType goodsType, List<Unit> workers) {
        if (workers == null || workers.isEmpty()) {
            return null;
        }
        Colony colony = wl.getColony();
        ArrayList<Unit> todo = new ArrayList<Unit>(workers);
        ArrayList<Unit> best = new ArrayList<Unit>();
        Unit special = null;
        GoodsType outputType = goodsType.isStoredAs() ? goodsType.getStoredAs() : goodsType;
        best.clear();
        int bestValue = colony.getAdjustedNetProductionOf(outputType);
        for (Unit u : todo) {
            if (!wl.canAdd(u)) continue;
            Location oldLoc = u.getLocation();
            GoodsType oldWork = u.getWorkType();
            u.setLocation(wl);
            u.setWorkType(goodsType);
            int value = colony.getAdjustedNetProductionOf(outputType);
            if (value > bestValue) {
                bestValue = value;
                best.clear();
                best.add(u);
                if (u.getType().getExpertProduction() == goodsType) {
                    special = u;
                }
            } else if (value == bestValue && !best.isEmpty()) {
                best.add(u);
            }
            u.setLocation(oldLoc);
            u.setWorkType(oldWork);
        }
        switch (best.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Unit)best.get(0);
            }
        }
        todo.clear();
        todo.addAll(best);
        if (special != null) {
            return special;
        }
        Specification spec = colony.getSpecification();
        UnitType expert = spec.getExpertForProducing(goodsType);
        best.clear();
        bestValue = Integer.MIN_VALUE;
        for (Unit u : todo) {
            int score;
            boolean relevant = u.getWorkType() == goodsType;
            int n = score = relevant ? u.getExperience() : -u.getExperience();
            if (expert != null && u.getType().canBeUpgraded(expert, UnitTypeChange.ChangeType.EXPERIENCE)) {
                score += 10000;
            } else if (expert != null && u.getType().canBeUpgraded(null, UnitTypeChange.ChangeType.EXPERIENCE)) {
                score -= 10000;
            }
            if (score > bestValue) {
                best.clear();
                best.add(u);
                bestValue = score;
                continue;
            }
            if (score != bestValue) continue;
            best.add(u);
        }
        switch (best.size()) {
            case 0: {
                break;
            }
            case 1: {
                return (Unit)best.get(0);
            }
            default: {
                todo.clear();
                todo.addAll(best);
            }
        }
        int worstSkill = Integer.MAX_VALUE;
        special = null;
        for (Unit u : todo) {
            if (u.getType().getSkill() >= worstSkill) continue;
            special = u;
            worstSkill = u.getType().getSkill();
        }
        return special;
    }

    public Colony assignWorkers(List<Unit> workers) {
        GoodsType goodsType;
        GoodsType foodType = this.spec().getPrimaryFoodType();
        int maxUnitFood = this.colony.getOwner().getMaximumFoodConsumption();
        Turn turn = this.aiMain.getGame().getTurn();
        final List<GoodsType> produce = this.getPreferredProduction();
        List<WorkLocationPlan> foodPlans = this.getFoodPlans();
        List<WorkLocationPlan> workPlans = this.getWorkPlans();
        Colony scratch = this.colony.getScratchColony();
        Tile tile = scratch.getTile();
        String report = "Worker assignment for " + this.colony.getName() + " at " + this.aiMain.getGame().getTurn().getNumber() + "\n";
        for (Unit u : workers) {
            TypeCountMap<EquipmentType> equipment = u.getEquipment();
            u.setLocation(tile);
            for (EquipmentType e : new ArrayList<EquipmentType>(equipment.keySet())) {
                int n = equipment.getCount(e);
                u.changeEquipment(e, -n);
                scratch.addEquipmentGoods(e, n);
            }
        }
        Unit.Role[] outdoorRoles = new Unit.Role[]{Unit.Role.PIONEER, Unit.Role.SOLDIER, Unit.Role.SCOUT};
        if (turn.getAge() <= 1) {
            int nScouts = 0;
            for (Unit u : this.colony.getOwner().getUnits()) {
                if (u.getRole() != Unit.Role.SCOUT) continue;
                ++nScouts;
            }
            if (nScouts < 3) {
                outdoorRoles[1] = Unit.Role.SCOUT;
                outdoorRoles[2] = Unit.Role.SOLDIER;
            }
        }
        block3: for (int j = 0; j < outdoorRoles.length; ++j) {
            String ability = "model.ability.expert" + outdoorRoles[j].toString().substring(0, 1) + outdoorRoles[j].toString().substring(1).toLowerCase();
            for (Unit u : new ArrayList<Unit>(workers)) {
                if (workers.size() <= 1) continue block3;
                if (!u.hasAbility(ability) || !this.equipUnit(u, outdoorRoles[j], scratch)) continue;
                workers.remove(u);
                report = report + u.getId() + "(" + u.getType().toString().substring(11) + ") -> " + (Object)((Object)outdoorRoles[j]) + "\n";
            }
        }
        Comparator<Unit> soldierComparator = new Comparator<Unit>(){

            @Override
            public int compare(Unit u1, Unit u2) {
                int cmp = u1.getSkillLevel() - u2.getSkillLevel();
                if (cmp != 0) {
                    return cmp;
                }
                GoodsType g1 = u1.getType().getExpertProduction();
                GoodsType g2 = u2.getType().getExpertProduction();
                if (g1 != null && g2 != null) {
                    return produce.indexOf(g2) - produce.indexOf(g1);
                }
                return u1.getExperience() - u2.getExperience();
            }
        };
        Collections.sort(workers, soldierComparator);
        for (Unit u : new ArrayList<Unit>(workers)) {
            if (workers.size() <= 1 || !AIColony.isBadlyDefended(scratch)) break;
            if (!this.equipUnit(u, Unit.Role.SOLDIER, scratch)) continue;
            workers.remove(u);
            report = report + u.getId() + "(" + u.getType().toString().substring(11) + ") -> SOLDIER\n";
        }
        ArrayList<AbstractGoods> buildGoods = new ArrayList<AbstractGoods>();
        BuildableType build = this.colony.getCurrentlyBuilding();
        if (build != null) {
            buildGoods.addAll(build.getGoodsRequired());
        }
        boolean done = false;
        block6: while (!workers.isEmpty() && !done) {
            GoodsType raw;
            List<WorkLocationPlan> wlps = null;
            WorkLocationPlan wlp = null;
            if (scratch.getAdjustedNetProductionOf(foodType) > 0) {
                wlps = workPlans;
                while (!produce.isEmpty() && (wlp = this.findPlan(produce.get(0), workPlans)) == null) {
                    produce.remove(0);
                }
            }
            while (true) {
                if (wlp == null) {
                    if (foodPlans.isEmpty()) {
                        report = report + "Food plans exhausted\n";
                        done = true;
                        continue block6;
                    }
                    wlps = foodPlans;
                    wlp = wlps.get(0);
                }
                String err = null;
                goodsType = wlp.getGoodsType();
                WorkLocation wl = wlp.getWorkLocation();
                wl = scratch.getCorrespondingWorkLocation(wl);
                Unit best = null;
                report = report + String.format("%-2d: %15s@%-25s => ", scratch.getUnitCount(), goodsType.toString().substring(12), wl instanceof Building ? ((Building)wl).getType().toString().substring(15) : (wl instanceof ColonyTile ? ((ColonyTile)wl).toString().substring(11, 20) + ((ColonyTile)wl).getWorkTile().getType().toString().substring(11) : wl.toString()));
                if (!wl.canBeWorked()) {
                    err = "can not be worked";
                } else if (wl.isFull()) {
                    err = "full";
                } else {
                    best = ColonyPlan.getBestWorker(wl, goodsType, workers);
                    if (best == null) {
                        err = "no worker found";
                    }
                }
                if (err != null) {
                    wlps.remove(wlp);
                    report = report + err + "\n";
                    continue block6;
                }
                best.setLocation(wl);
                if (scratch.getProductionBonus() < 0) {
                    best.setLocation(tile);
                    done = true;
                    report = report + "broke production bonus\n";
                    continue block6;
                }
                if (scratch.getAdjustedNetProductionOf(foodType) < 0) {
                    int net = scratch.getAdjustedNetProductionOf(foodType);
                    int count = scratch.getGoodsCount(foodType);
                    if (count / -net < 5) {
                        best.setLocation(tile);
                        wlp = null;
                        if (goodsType.isFoodType()) {
                            report = report + "starvation (" + count + "/" + net + ")\n";
                            done = true;
                            continue block6;
                        }
                        report = report + "would starve (" + count + "/" + net + ")\n";
                        continue;
                    }
                }
                raw = goodsType.getRawMaterial();
                int rawNeeded = 0;
                for (AbstractGoods ag : buildGoods) {
                    if (raw != ag.getType()) continue;
                    rawNeeded += ag.getAmount();
                }
                if (raw == null || scratch.getAdjustedNetProductionOf(raw) >= 0 || (scratch.getGoodsCount(raw) - rawNeeded) / -scratch.getAdjustedNetProductionOf(raw) >= 5) {
                    best.setWorkType(goodsType);
                    workers.remove(best);
                    report = report + best.getId() + "(" + best.getType().toString().substring(11) + ")\n";
                    if (goodsType.isFoodType() || !produce.remove(goodsType)) continue block6;
                    produce.add(goodsType);
                    continue block6;
                }
                best.setLocation(tile);
                WorkLocationPlan rawWlp = this.findPlan(raw, workPlans);
                if (rawWlp == null) break;
                if (produce.remove(raw)) {
                    produce.add(0, raw);
                }
                wlp = rawWlp;
                report = report + "retry with " + raw.toString().substring(12) + "\n";
            }
            wlps.remove(wlp);
            produce.remove(goodsType);
            report = report + "needs more " + raw.toString().substring(12) + "\n";
        }
        for (Unit u : workers) {
            if (u.getLocation() == tile) continue;
            u.setLocation(tile);
        }
        if (scratch.getUnitCount() == 0) {
            block11: for (WorkLocationPlan w : this.getFoodPlans()) {
                goodsType = w.getGoodsType();
                WorkLocation wl = w.getWorkLocation();
                for (Unit u : new ArrayList<Unit>(workers)) {
                    GoodsType oldWork = u.getWorkType();
                    u.setLocation(wl);
                    u.setWorkType(goodsType);
                    if (scratch.getAdjustedNetProductionOf(foodType) >= 0) {
                        report = report + "Subsist with " + u + "\n";
                        workers.remove(u);
                        break block11;
                    }
                    u.setLocation(tile);
                    u.setWorkType(oldWork);
                }
            }
        }
        ArrayList<Unit> experts = new ArrayList<Unit>();
        ArrayList<Unit> nonExperts = new ArrayList<Unit>();
        for (Unit u : scratch.getUnitList()) {
            if (u.getType().getExpertProduction() != null) {
                if (u.getType().getExpertProduction() == u.getWorkType()) continue;
                experts.add(u);
                continue;
            }
            nonExperts.add(u);
        }
        int expert = 0;
        while (expert < experts.size()) {
            Unit u1 = (Unit)experts.get(expert);
            Unit other = this.trySwapExpert(u1, experts);
            if (other != null) {
                report = report + "Swapped " + u1.getId() + "(" + u1.getType().toString().substring(11) + ") for " + other + "\n";
                experts.remove(u1);
                continue;
            }
            other = this.trySwapExpert(u1, nonExperts);
            if (other != null) {
                report = report + "Swapped " + u1.getId() + "(" + u1.getType().toString().substring(11) + ") for " + other + "\n";
                experts.remove(u1);
                continue;
            }
            ++expert;
        }
        for (Unit u : tile.getUnitList()) {
            Unit other;
            GoodsType work = u.getType().getExpertProduction();
            if (work == null || (other = this.trySwapExpert(u, scratch.getUnitList())) == null) continue;
            report = report + "Swapped " + u.getId() + "(" + u.getType().toString().substring(11) + ") for " + other + "\n";
        }
        workers.clear();
        for (Unit u : tile.getUnitList()) {
            if (!u.getEquipment().isEmpty()) continue;
            workers.add(u);
        }
        Collections.sort(workers, soldierComparator);
        for (Unit u : workers) {
            if (!this.equipUnit(u, Unit.Role.SOLDIER, scratch)) continue;
            report = report + u.getId() + "(" + u.getType().toString().substring(11) + ") -> SOLDIER\n";
        }
        logger.finest(report.substring(0, report.length() - 1));
        return scratch;
    }

    public String getBuildableReport() {
        String ret = "Buildables:\n";
        for (BuildPlan b : this.buildPlans) {
            ret = ret + b.toString() + "\n";
        }
        return ret;
    }

    public String toString() {
        String wlStr;
        WorkLocation wl;
        Tile tile = this.colony.getTile();
        StringBuilder sb = new StringBuilder();
        sb.append("ColonyPlan: " + this.colony.getName() + " " + this.colony.getTile().getPosition() + "\nProfile: " + this.profileType.toString() + "\nPreferred production:\n");
        for (GoodsType goodsType : this.getPreferredProduction()) {
            sb.append(goodsType.toString().substring(12) + "\n");
        }
        sb.append(this.getBuildableReport());
        sb.append("Food Plans:\n");
        for (WorkLocationPlan wlp : this.getFoodPlans()) {
            wl = wlp.getWorkLocation();
            wlStr = wl instanceof Building ? ((Building)wl).getType().toString().substring(15) : (wl instanceof ColonyTile ? tile.getDirection(((ColonyTile)wl).getWorkTile()).toString() : wl.getId());
            sb.append(wlStr + ": " + this.getWorkLocationProduction(wl, wlp.getGoodsType()) + " " + wlp.getGoodsType().toString().substring(12) + "\n");
        }
        sb.append("Work Plans:\n");
        for (WorkLocationPlan wlp : this.getWorkPlans()) {
            wl = wlp.getWorkLocation();
            wlStr = wl instanceof Building ? ((Building)wl).getType().toString().substring(15) : (wl instanceof ColonyTile ? tile.getDirection(((ColonyTile)wl).getWorkTile()).toString() : wl.getId());
            sb.append(wlStr + ": " + this.getWorkLocationProduction(wl, wlp.getGoodsType()) + " " + wlp.getGoodsType().toString().substring(12) + "\n");
        }
        return sb.toString();
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(ColonyPlan.getXMLElementTagName());
        element.setAttribute("ID", this.colony.getId());
        return element;
    }

    public void readFromXMLElement(Element element) {
        String colonyId = element.getAttribute("ID");
        this.colony = (Colony)this.getAIMain().getFreeColGameObject(colonyId);
        this.profileType = ProfileType.getProfileTypeFromSize(this.colony.getUnitCount());
    }

    public static String getXMLElementTagName() {
        return "colonyPlan";
    }

    private class BuildPlan {
        public BuildableType type;
        public double weight;
        public double support;
        public double difficulty;

        public BuildPlan(BuildableType type, double weight, double support) {
            this.type = type;
            this.weight = weight;
            this.support = support;
            this.difficulty = 1.0;
        }

        public double getValue() {
            return this.weight * this.support / this.difficulty;
        }

        public String toString() {
            String t = this.type.toString();
            return String.format("%s (%1.3f * %1.3f / %1.3f = %1.3f)", t.substring(t.lastIndexOf(".") + 1), this.weight, this.support, this.difficulty, this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProfileType {
        OUTPOST,
        SMALL,
        MEDIUM,
        LARGE,
        CAPITAL;


        public static ProfileType getProfileTypeFromSize(int size) {
            return size <= 1 ? OUTPOST : (size <= 2 ? SMALL : (size <= 4 ? MEDIUM : (size <= 8 ? LARGE : CAPITAL)));
        }
    }
}

