/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTypeOption
extends AbstractOption<UnitType> {
    private static Logger logger = Logger.getLogger(UnitTypeOption.class.getName());
    private UnitType value;
    private boolean addNone;
    private TypeSelector generateChoices = TypeSelector.UNITS;
    private List<UnitType> choices = new ArrayList<UnitType>();

    public UnitTypeOption(String id) {
        super(id);
    }

    public UnitTypeOption(Specification specification) {
        super(specification);
    }

    public UnitTypeOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public UnitTypeOption clone() {
        UnitTypeOption result = new UnitTypeOption(this.getId(), this.getSpecification());
        result.value = this.value;
        result.addNone = this.addNone;
        result.generateChoices = this.generateChoices;
        result.generateChoices();
        result.isDefined = true;
        return result;
    }

    @Override
    public UnitType getValue() {
        return this.value;
    }

    @Override
    public void setValue(UnitType value) {
        UnitType oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        if (valueString != null) {
            this.setValue(this.getSpecification().getUnitType(valueString));
        } else if (defaultValueString != null) {
            this.setValue(this.getSpecification().getUnitType(defaultValueString));
        } else {
            this.setValue(null);
        }
    }

    public final boolean addNone() {
        return this.addNone;
    }

    public final void setAddNone(boolean newAddNone) {
        this.addNone = newAddNone;
    }

    public final List<UnitType> getChoices() {
        return this.choices;
    }

    public final void setChoices(List<UnitType> newChoices) {
        this.choices = newChoices;
    }

    public final TypeSelector getGenerateChoices() {
        return this.generateChoices;
    }

    public final void setGenerateChoices(TypeSelector newGenerateChoices) {
        this.generateChoices = newGenerateChoices;
    }

    @Override
    public void generateChoices() {
        if (this.generateChoices == null) {
            if (this.choices == null || this.choices.isEmpty()) {
                this.choices = new ArrayList<UnitType>();
                this.choices.add(this.getValue());
            }
        } else {
            List<UnitType> unitTypeList = this.getSpecification().getUnitTypeList();
            this.choices = new ArrayList<UnitType>();
            switch (this.generateChoices) {
                case UNITS: {
                    this.choices.addAll(unitTypeList);
                    break;
                }
                case IMMIGRANTS: {
                    for (UnitType unitType : unitTypeList) {
                        if (!unitType.isRecruitable()) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
                case NAVAL_UNITS: {
                    for (UnitType unitType : unitTypeList) {
                        if (!unitType.hasAbility("model.ability.navalUnit")) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
                case LAND_UNITS: {
                    for (UnitType unitType : unitTypeList) {
                        if (unitType.hasAbility("model.ability.navalUnit")) continue;
                        this.choices.add(unitType);
                    }
                    break;
                }
            }
            if (this.addNone) {
                this.choices.add(0, null);
            }
        }
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, UnitTypeOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.value != null) {
            out.writeAttribute("value", this.value.getId());
        }
        if (this.generateChoices != null) {
            out.writeAttribute("generate", this.generateChoices.toString());
        }
        if (this.addNone) {
            out.writeAttribute("addNone", Boolean.toString(this.addNone));
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        super.writeChildren(out);
        if (this.choices != null && !this.choices.isEmpty()) {
            for (UnitType choice : this.choices) {
                out.writeStartElement("choice");
                out.writeAttribute("value", choice.getId());
                out.writeEndElement();
            }
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.addNone = UnitTypeOption.getAttribute(in, "addNone", false);
        String generate = in.getAttributeValue(null, "generate");
        if (generate != null) {
            this.generateChoices = TypeSelector.valueOf(generate);
        }
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        if ("choice".equals(in.getLocalName())) {
            this.choices.add(this.getSpecification().getUnitType(in.getAttributeValue(null, "value")));
            in.nextTag();
        }
    }

    public static String getXMLElementTagName() {
        return "unitTypeOption";
    }

    @Override
    public String toString() {
        return UnitTypeOption.getXMLElementTagName() + " [value=" + this.value + ", addNone=" + this.addNone + ", generateChoices=" + (Object)((Object)this.generateChoices) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeSelector {
        UNITS,
        IMMIGRANTS,
        LAND_UNITS,
        NAVAL_UNITS;

    }
}

