/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanOption
extends AbstractOption<Boolean> {
    private static Logger logger = Logger.getLogger(BooleanOption.class.getName());
    private boolean value;

    public BooleanOption(String id) {
        super(id);
    }

    public BooleanOption(Specification specification) {
        super(specification);
    }

    @Override
    public BooleanOption clone() {
        BooleanOption result = new BooleanOption(this.getId());
        result.setValues(this);
        return result;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        boolean oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", (Object)oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(Boolean.parseBoolean(valueString != null ? valueString : defaultValueString));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        super.toXML(out, BooleanOption.getXMLElementTagName());
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("value", Boolean.toString(this.value));
    }

    public static String getXMLElementTagName() {
        return "booleanOption";
    }
}

