/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetGoodsLevelsMessage
extends DOMMessage {
    private String colonyId;
    private ExportData data;

    public SetGoodsLevelsMessage(Colony colony, ExportData data) {
        this.colonyId = colony.getId();
        this.data = data;
    }

    public SetGoodsLevelsMessage(Game game, Element element) {
        this.colonyId = element.getAttribute("colony");
        this.data = new ExportData();
        this.data.readFromXMLElement((Element)element.getChildNodes().item(0));
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Game game = player.getGame();
        ServerPlayer serverPlayer = server.getPlayer(connection);
        if (!(game.getFreeColGameObject(this.colonyId) instanceof Colony)) {
            return DOMMessage.clientError("Not a colony: " + this.colonyId);
        }
        Colony colony = (Colony)game.getFreeColGameObject(this.colonyId);
        if (player != colony.getOwner()) {
            return DOMMessage.clientError("Player does not own colony: " + this.colonyId);
        }
        return server.getInGameController().setGoodsLevels(serverPlayer, colony, this.data);
    }

    public Element toXMLElement() {
        Element result = SetGoodsLevelsMessage.createNewRootElement(SetGoodsLevelsMessage.getXMLElementTagName());
        Document doc = result.getOwnerDocument();
        result.setAttribute("colony", this.colonyId);
        result.appendChild(this.data.toXMLElement(null, doc));
        return result;
    }

    public static String getXMLElementTagName() {
        return "setGoodsLevels";
    }
}

