/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class MoveToMessage
extends DOMMessage {
    private String unitId;
    private String destinationId;

    public MoveToMessage(Unit unit, Location destination) {
        this.unitId = unit.getId();
        this.destinationId = destination.getId();
    }

    public MoveToMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
        this.destinationId = element.getAttribute("destination");
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        Game game = player.getGame();
        try {
            unit = server.getUnitSafely(this.unitId, serverPlayer);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        FreeColGameObject obj = game.getFreeColGameObjectSafely(this.destinationId);
        if (!(obj instanceof Location)) {
            return DOMMessage.clientError("Not a location: " + this.destinationId);
        }
        Location destination = (Location)((Object)obj);
        return server.getInGameController().moveTo(serverPlayer, unit, destination);
    }

    public Element toXMLElement() {
        Element result = MoveToMessage.createNewRootElement(MoveToMessage.getXMLElementTagName());
        result.setAttribute("unit", this.unitId);
        result.setAttribute("destination", this.destinationId);
        return result;
    }

    public static String getXMLElementTagName() {
        return "moveTo";
    }
}

