/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;

public abstract class WorkLocation
extends UnitLocation
implements Ownable {
    private Colony colony;

    protected WorkLocation() {
    }

    protected WorkLocation(Game game) {
        super(game);
    }

    public WorkLocation(Game game, XMLStreamReader in) throws XMLStreamException {
        super(game, in);
    }

    public WorkLocation(Game game, String id) {
        super(game, id);
    }

    public abstract int getProductionOf(GoodsType var1);

    public abstract int getProductionOf(Unit var1, GoodsType var2);

    public abstract int getPotentialProduction(UnitType var1, GoodsType var2);

    public abstract boolean canAutoProduce();

    public abstract UnitLocation.NoAddReason getNoWorkReason();

    public boolean canBeWorked() {
        return this.getNoWorkReason() == UnitLocation.NoAddReason.NONE;
    }

    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isPerson() ? super.getNoAddReason(locatable) : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    public final Colony getColony() {
        return this.colony;
    }

    public final void setColony(Colony newColony) {
        this.colony = newColony;
    }

    public Tile getTile() {
        return this.colony.getTile();
    }

    public Settlement getSettlement() {
        return this.colony;
    }

    public Player getOwner() {
        return this.colony.getOwner();
    }

    public void setOwner(Player p) {
        throw new UnsupportedOperationException();
    }

    public boolean canTeach() {
        return this.hasAbility("model.ability.teach");
    }

    public boolean add(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (super.add(unit)) {
            if (this.canTeach()) {
                Unit student = unit.getStudent();
                if (student == null && (student = this.getColony().findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                }
                unit.setWorkType(null);
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher == null && (teacher = this.getColony().findTeacher(unit)) != null) {
                    unit.setTeacher(teacher);
                    teacher.setStudent(unit);
                }
            }
            return true;
        }
        return false;
    }

    public boolean remove(Locatable locatable) {
        if (!(locatable instanceof Unit)) {
            throw new IllegalStateException("Not a unit: " + locatable);
        }
        Unit unit = (Unit)locatable;
        if (super.remove(unit)) {
            if (this.canTeach()) {
                Unit student = unit.getStudent();
                if (student != null) {
                    student.setTeacher(null);
                    unit.setStudent(null);
                }
                unit.setTurnsOfTraining(0);
            }
            return true;
        }
        return false;
    }

    public void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.colony = this.getFreeColGameObject(in, "colony", Colony.class);
    }

    public void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("colony", this.colony.getId());
    }
}

